/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAnnotationRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratorRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflectionRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CustomMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CustomUnmarshaller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DynamoDBMappingsRegistry {
    private static final Log log = LogFactory.getLog(DynamoDBMappingsRegistry.class);
    private static final DynamoDBMappingsRegistry INSTANCE = new DynamoDBMappingsRegistry();
    private final ConcurrentMap<Class<?>, Mappings> mappings = new ConcurrentHashMap();
    private final DynamoDBReflectionRegistry reflectionRegistry = new DynamoDBReflectionRegistry();
    private final DynamoDBAnnotationRegistry annotationRegistry = new DynamoDBAnnotationRegistry();
    private final DynamoDBAutoGeneratorRegistry generatorRegistry = new DynamoDBAutoGeneratorRegistry();

    DynamoDBMappingsRegistry() {
    }

    static final DynamoDBMappingsRegistry instance() {
        return INSTANCE;
    }

    final Mappings mappingsOf(Class<?> clazz) {
        if (!this.mappings.containsKey(clazz)) {
            this.mappings.putIfAbsent(clazz, new Mappings(clazz, this));
        }
        return (Mappings)this.mappings.get(clazz);
    }

    final Mapping mappingOf(Method method) {
        return this.mappingsOf(method.getDeclaringClass()).getMapping(method);
    }

    private final Collection<Mapping> map(Class<?> clazz, Mappings mappings) {
        Collection<DynamoDBReflectionRegistry.BeanProperty> properties = this.reflectionRegistry.beanPropertiesOf(clazz);
        ArrayList<Mapping> map = new ArrayList<Mapping>(properties.size());
        for (DynamoDBReflectionRegistry.BeanProperty property : properties) {
            DynamoDBAnnotationRegistry.AnnotationMap annotations;
            if (!clazz.equals(property.getDeclaringType()) && !(annotations = this.annotationRegistry.annotationsOf(property.getDeclaringType())).isTable() && !annotations.isDocument() || (annotations = this.annotationRegistry.annotationsOf(property.getGetter(), property.getField())).isIgnore()) continue;
            DynamoDBAutoGeneratorRegistry.Generator<Object> generator = this.generatorRegistry.generatorOf(property.getGetterType(), annotations);
            String attributeName = annotations.getAttributeName();
            if (attributeName == null) {
                attributeName = property.getFieldName();
            }
            map.add(new Mapping(mappings, property, annotations, generator, attributeName));
        }
        return map;
    }

    static final class Mapping {
        private final Mappings mappings;
        private final DynamoDBReflectionRegistry.BeanProperty property;
        private final DynamoDBAnnotationRegistry.AnnotationMap annotations;
        private final DynamoDBAutoGeneratorRegistry.Generator<Object> generator;
        private final String attributeName;

        private Mapping(Mappings mappings, DynamoDBReflectionRegistry.BeanProperty property, DynamoDBAnnotationRegistry.AnnotationMap annotations, DynamoDBAutoGeneratorRegistry.Generator<Object> generator, String attributeName) {
            this.mappings = mappings;
            this.property = property;
            this.annotations = annotations;
            this.generator = generator;
            this.attributeName = attributeName;
        }

        private final DynamoDBAutoGeneratorRegistry.Generator<Object> getAutoGenerator() {
            return this.generator;
        }

        final Method getter() {
            return this.property.getGetter();
        }

        final Method setter() {
            return this.property.getSetter();
        }

        final Object getValueOf(Object target) {
            return this.property.getValueOf(target);
        }

        final void setValueOf(Object target, Object value) {
            this.property.setValueOf(target, value);
        }

        final boolean isPrimaryKey() {
            return this.isHashKey() || this.isRangeKey();
        }

        final boolean isAutoGeneratedKey() {
            return this.annotations.isAutoGeneratedKey();
        }

        final boolean isAutoGeneratedTimestamp() {
            return this.annotations.isAutoGeneratedTimestamp();
        }

        final boolean isHashKey() {
            return this.annotations.isHashKey();
        }

        final boolean isIndexHashKey() {
            return this.annotations.isIndexHashKey();
        }

        final boolean isIndexRangeKey() {
            return this.annotations.isIndexRangeKey();
        }

        final boolean isRangeKey() {
            return this.annotations.isRangeKey();
        }

        final boolean isVersion() {
            return this.annotations.isVersion();
        }

        final String getAttributeName() {
            return this.attributeName;
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexHashKey() {
            Collection<String> indexNames = this.annotations.getGlobalSecondaryIndexNamesOfIndexHashKey();
            if (indexNames.isEmpty()) {
                throw new DynamoDBMappingException("@DynamoDBIndexHashKey annotation on getter " + this.getter() + " doesn't contain any index name.");
            }
            return indexNames;
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexRangeKey() {
            return this.annotations.getGlobalSecondaryIndexNamesOfIndexRangeKey();
        }

        final Collection<String> getLocalSecondaryIndexNamesOfIndexRangeKey() {
            return this.annotations.getLocalSecondaryIndexNamesOfIndexRangeKey();
        }

        final DynamoDBAutoGenerateStrategy getAutoGenerateStrategy() {
            return this.annotations.getAutoGenerateStrategy();
        }

        final ArgumentMarshaller getCustomMarshaller() {
            Class<? extends DynamoDBMarshaller<?>> marshallerClass = this.annotations.getMarshallerClass();
            if (marshallerClass != null) {
                return new CustomMarshaller(marshallerClass);
            }
            if (this.annotations.isNativeBoolean()) {
                return BooleanToBooleanMarshaller.instance();
            }
            return null;
        }

        final ArgumentUnmarshaller getCustomUnmarshaller() {
            Class<? extends DynamoDBMarshaller<?>> marshallerClass = this.annotations.getMarshallerClass();
            if (marshallerClass != null) {
                return new CustomUnmarshaller(this.property.getGetterType(), marshallerClass);
            }
            return null;
        }

        final boolean canAutoGenerate(Object value, Object objectValue, DynamoDBMapperConfig.SaveBehavior saveBehavior) {
            if (!this.getAutoGenerator().canGenerate(value)) {
                return false;
            }
            if (this.isPrimaryKey() || this.isIndexHashKey() || this.isIndexRangeKey()) {
                return this.isAutoGeneratedKey();
            }
            if (DynamoDBAutoGenerateStrategy.CREATE == this.getAutoGenerateStrategy()) {
                return saveBehavior == DynamoDBMapperConfig.SaveBehavior.CLOBBER || saveBehavior == DynamoDBMapperConfig.SaveBehavior.UPDATE || this.mappings.anyPrimaryKeyAutoGeneratable(objectValue);
            }
            return true;
        }

        final Object autoGenerate(Object value) {
            return this.getAutoGenerator().generate(value);
        }
    }

    static final class Mappings {
        private final Class<?> objectType;
        private final DynamoDBAnnotationRegistry.AnnotationMap annotations;
        private final Map<String, Mapping> byNames = new HashMap<String, Mapping>();
        private final Map<Method, Mapping> byGetters = new HashMap<Method, Mapping>();
        private final Collection<Mapping> primaryKeys = new HashSet<Mapping>();
        private Mapping hashKey;
        private Mapping rangeKey;

        private Mappings(Class<?> clazz, DynamoDBMappingsRegistry registry) {
            this.objectType = clazz;
            this.annotations = registry.annotationRegistry.annotationsOf(clazz);
            for (Mapping mapping : registry.map(clazz, this)) {
                if (this.byNames.containsKey(mapping.getAttributeName())) {
                    throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps duplicate attributes named " + mapping.getAttributeName());
                }
                if (mapping.isHashKey()) {
                    if (this.hasHashKey()) {
                        throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps @DynamoDBHashKey to multiple attributes");
                    }
                    this.hashKey = mapping;
                    this.primaryKeys.add(mapping);
                }
                if (mapping.isRangeKey()) {
                    if (this.hasRangeKey()) {
                        throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " maps @DynamoDBRangeKey to multiple attributes");
                    }
                    this.rangeKey = mapping;
                    this.primaryKeys.add(mapping);
                }
                this.byNames.put(mapping.getAttributeName(), mapping);
                this.byGetters.put(mapping.getter(), mapping);
            }
            if (this.annotations.isTable() && !this.hasHashKey()) {
                log.warn((Object)("Class " + this.getObjectType().getName() + " does not map a @DynamoDBHashKey attribute"));
            }
        }

        final Class<?> getObjectType() {
            return this.objectType;
        }

        final Collection<Mapping> getMappings() {
            return this.byNames.values();
        }

        final Mapping getMapping(Method method) {
            Mapping mapping = this.byGetters.get(method);
            if (mapping == null) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map any getter named " + method.getName());
            }
            return mapping;
        }

        final Collection<Mapping> getPrimaryKeys() {
            return this.primaryKeys;
        }

        final boolean hasHashKey() {
            return this.hashKey != null;
        }

        final Mapping getHashKey() {
            if (!this.hasHashKey()) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map a @DynamoDBHashKey attribute; ensure a public, zero-parameter get method/field is annotated");
            }
            return this.hashKey;
        }

        final boolean hasRangeKey() {
            return this.rangeKey != null;
        }

        final Mapping getRangeKey() {
            return this.rangeKey;
        }

        final boolean isDocument() {
            return this.annotations.isDocument();
        }

        final String getTableName() {
            if (!this.annotations.isTable()) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " must be annotated with @DynamoDBTable");
            }
            return this.annotations.getTableName();
        }

        final boolean anyPrimaryKeyAutoGeneratable(Object objectValue) {
            for (Mapping primaryKey : this.getPrimaryKeys()) {
                if (!primaryKey.isAutoGeneratedKey()) continue;
                Object primaryKeyValue = primaryKey.getValueOf(objectValue);
                if (!primaryKey.getAutoGenerator().canGenerate(primaryKeyValue)) continue;
                return true;
            }
            return false;
        }
    }
}

