/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinsert;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforce.SalesforceStep;
import org.pentaho.di.trans.steps.salesforceinsert.SalesforceInsertData;
import org.pentaho.di.trans.steps.salesforceinsert.SalesforceInsertMeta;
import org.pentaho.di.trans.steps.salesforceutils.SalesforceUtils;

public class SalesforceInsert
extends SalesforceStep {
    private static Class<?> PKG = SalesforceInsertMeta.class;
    private SalesforceInsertMeta meta;
    private SalesforceInsertData data;

    public SalesforceInsert(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (this.data.iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.nrfields = this.meta.getUpdateLookup().length;
            if (this.data.nrfields == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.fieldnrs = new int[this.meta.getUpdateStream().length];
            for (int i = 0; i < this.meta.getUpdateStream().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInsert.CanNotFindField", (String[])new String[]{this.meta.getUpdateStream()[i]}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SalesforceInsert.log.Exception", (Object[])new Object[]{e}));
        }
        return true;
    }

    @VisibleForTesting
    void writeToSalesForce(Object[] rowData) throws KettleException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.WriteToSalesforce", (Object[])new Object[]{this.data.iBufferPos, this.meta.getBatchSizeInt()}));
            }
            if (this.data.iBufferPos < this.meta.getBatchSizeInt()) {
                ArrayList<XmlObject> insertfields = new ArrayList<XmlObject>();
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                for (int i = 0; i < this.data.nrfields; ++i) {
                    Object value;
                    ValueMetaInterface valueMeta = this.data.inputRowMeta.getValueMeta(this.data.fieldnrs[i]);
                    if (valueMeta.isNull(value = rowData[this.data.fieldnrs[i]])) {
                        fieldsToNull.add(SalesforceUtils.getFieldToNullName(this.log, this.meta.getUpdateLookup()[i], this.meta.getUseExternalId()[i]));
                        continue;
                    }
                    if (valueMeta.isDate()) {
                        Calendar cal = Calendar.getInstance(valueMeta.getDateFormatTimeZone());
                        cal.setTime(valueMeta.getDate(value));
                        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        utc.clear();
                        utc.set(cal.get(1), cal.get(2), cal.get(5));
                        value = utc.getTime();
                    } else if (valueMeta.isStorageBinaryString()) {
                        value = valueMeta.convertToNormalStorageType(value);
                    }
                    insertfields.add(SalesforceConnection.createMessageElement(this.meta.getUpdateLookup()[i], value, this.meta.getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(this.data.connection.getModule());
                if (insertfields.size() > 0) {
                    for (XmlObject element : insertfields) {
                        sobjPass.setSObjectField(element.getName().getLocalPart(), element.getValue());
                    }
                }
                if (fieldsToNull.size() > 0) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                this.data.sfBuffer[this.data.iBufferPos] = sobjPass;
                this.data.outputBuffer[this.data.iBufferPos] = rowData;
                ++this.data.iBufferPos;
            }
            if (this.data.iBufferPos >= this.meta.getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.CallingFlushBuffer", (String[])new String[0]));
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInsert.Error", (String[])new String[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws KettleException {
        try {
            this.data.saveResult = this.data.connection.insert(this.data.sfBuffer);
            for (int j = 0; j < this.data.saveResult.length; ++j) {
                if (this.data.saveResult[j].isSuccess()) {
                    String id = this.data.saveResult[j].getId();
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceInsert.RowInserted", (String[])new String[]{id}));
                    }
                    Object[] newRow = RowDataUtil.resizeArray((Object[])this.data.outputBuffer[j], (int)this.data.outputRowMeta.size());
                    if (this.data.realSalesforceFieldName != null) {
                        int newIndex = this.getInputRowMeta().size();
                        newRow[newIndex++] = id;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.NewRow", (Object[])new Object[]{newRow[0]}));
                    }
                    this.putRow(this.data.outputRowMeta, newRow);
                    this.incrementLinesOutput();
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.log.LineRow", (Object[])new Object[]{this.getLinesInput()}));
                    continue;
                }
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceInsert.ErrorFound", (String[])new String[0]));
                    }
                    Error err = this.data.saveResult[j].getErrors()[0];
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()}));
                }
                String errorMessage = "";
                for (int i = 0; i < this.data.saveResult[j].getErrors().length; ++i) {
                    Error err = this.data.saveResult[j].getErrors()[i];
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"SalesforceInsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.PassingRowToErrorStep", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), this.data.outputBuffer[j], 1L, errorMessage, null, "SalesforceInsert001");
            }
            this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInsert.FailedToInsertObject", (String[])new String[]{e.getMessage()}));
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error step");
            }
            for (int i = 0; i < this.data.iBufferPos; ++i) {
                this.putError(this.data.inputRowMeta, this.data.outputBuffer[i], 1L, e.getMessage(), null, "SalesforceInsert002");
            }
        }
        finally {
            if (this.data.saveResult != null) {
                this.data.saveResult = null;
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInsertMeta)smi;
        this.data = (SalesforceInsertData)sdi;
        if (super.init(smi, sdi)) {
            try {
                String salesfoceIdFieldname = this.environmentSubstitute(this.meta.getSalesforceIDFieldName());
                if (!Utils.isEmpty((CharSequence)salesfoceIdFieldname)) {
                    this.data.realSalesforceFieldName = salesfoceIdFieldname;
                }
                this.data.connection.setRollbackAllChangesOnError(this.meta.isRollbackAllChangesOnError());
                this.data.connection.connect();
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInsert.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.outputBuffer != null) {
            this.data.outputBuffer = null;
        }
        if (this.data.sfBuffer != null) {
            this.data.sfBuffer = null;
        }
        super.dispose(smi, sdi);
    }
}

