/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforce;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class SalesforceStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SalesforceStepMeta.class;
    private String targetURL;
    private String username;
    private String password;
    private String timeout;
    private boolean compression;
    private String module;

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)"targeturl", (String)this.getTargetURL()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"username", (String)this.getUsername()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timeout", (String)this.getTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useCompression", (boolean)this.isCompression()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"module", (String)this.getModule()));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.setTargetURL(XMLHandler.getTagValue((Node)stepnode, (String)"targeturl"));
        this.setUsername(XMLHandler.getTagValue((Node)stepnode, (String)"username"));
        this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password")));
        this.setTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"timeout"));
        this.setCompression("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCompression")));
        this.setModule(XMLHandler.getTagValue((Node)stepnode, (String)"module"));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "targeturl", this.getTargetURL());
        rep.saveStepAttribute(id_transformation, id_step, "username", this.getUsername());
        rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword()));
        rep.saveStepAttribute(id_transformation, id_step, "timeout", this.getTimeout());
        rep.saveStepAttribute(id_transformation, id_step, "useCompression", this.isCompression());
        rep.saveStepAttribute(id_transformation, id_step, "module", this.getModule());
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.setTargetURL(rep.getStepAttributeString(id_step, "targeturl"));
        this.setUsername(rep.getStepAttributeString(id_step, "username"));
        this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password")));
        this.setTimeout(rep.getStepAttributeString(id_step, "timeout"));
        this.setCompression(rep.getStepAttributeBoolean(id_step, "useCompression"));
        this.setModule(rep.getStepAttributeString(id_step, "module"));
    }

    public Object clone() {
        SalesforceStepMeta retval = (SalesforceStepMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.setTargetURL("https://login.salesforce.com/services/Soap/u/37.0");
        this.setUsername("");
        this.setPassword("");
        this.setTimeout("60000");
        this.setCompression(false);
        this.setModule("Account");
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.getTargetURL()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.NoURL", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.URLOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.getUsername()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.NoUsername", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.UsernameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.getModule()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.NoModule", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceMeta.CheckResult.ModuleOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public void setTargetURL(String targetURL) {
        this.targetURL = targetURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Deprecated
    public String getUserName() {
        return this.getUsername();
    }

    @Deprecated
    public void setUserName(String username) {
        this.setUsername(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Deprecated
    public String getTimeOut() {
        return this.getTimeout();
    }

    @Deprecated
    public void setTimeOut(String timeOut) {
        this.setTimeout(timeOut);
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    @Deprecated
    public boolean isUsingCompression() {
        return this.isCompression();
    }

    @Deprecated
    public void setUseCompression(boolean useCompression) {
        this.setCompression(useCompression);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

