/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROPERTYKEY;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];
    long mTaskbarList3;
    static final char[] EXE_PATH;
    static final char[] ICO_DIR;
    static final PROPERTYKEY PKEY_Title;
    static final PROPERTYKEY PKEY_AppUserModel_IsDestListSeparator;
    static final String EXE_PATH_KEY = "org.eclipse.swt.win32.taskbar.executable";
    static final String EXE_ARGS_KEY = "org.eclipse.swt.win32.taskbar.arguments";
    static final String ICON_KEY = "org.eclipse.swt.win32.taskbar.icon";
    static final String ICON_INDEX_KEY = "org.eclipse.swt.win32.taskbar.icon.index";
    static final byte[] CLSID_TaskbarList;
    static final byte[] CLSID_DestinationList;
    static final byte[] CLSID_EnumerableObjectCollection;
    static final byte[] CLSID_ShellLink;
    static final byte[] CLSID_FileOperation;
    static final byte[] IID_ITaskbarList3;
    static final byte[] IID_ICustomDestinationList;
    static final byte[] IID_IObjectArray;
    static final byte[] IID_IObjectCollection;
    static final byte[] IID_IShellLinkW;
    static final byte[] IID_IPropertyStore;
    static final byte[] IID_IShellItem;
    static final byte[] IID_IFileOperation;
    static final byte[] FOLDERID_LocalAppData;

    TaskBar(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.createHandle();
        this.reskinWidget();
    }

    void createHandle() {
        long[] lArray = new long[1];
        int n = OS.CoCreateInstance(CLSID_TaskbarList, 0L, 1, IID_ITaskbarList3, lArray);
        if (n != 0) {
            this.error(2);
        }
        this.mTaskbarList3 = lArray[0];
    }

    void createItem(TaskItem taskItem, int n) {
        if (n == -1) {
            n = this.itemCount;
        }
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] taskItemArray = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, taskItemArray, 0, this.items.length);
            this.items = taskItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = taskItem;
    }

    void createItems() {
        Shell[] shellArray = this.display.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            this.getItem(shellArray[i]);
        }
        this.getItem(null);
    }

    long createShellLink(MenuItem menuItem, String string) {
        long l;
        PROPERTYKEY pROPERTYKEY;
        int n = menuItem.getStyle();
        if ((n & 0x40) != 0) {
            return 0L;
        }
        long[] lArray = new long[1];
        int n2 = OS.CoCreateInstance(CLSID_ShellLink, 0L, 1, IID_IShellLinkW, lArray);
        if (n2 != 0) {
            this.error(2);
        }
        long l2 = lArray[0];
        long l3 = OS.GetProcessHeap();
        long l4 = OS.HeapAlloc(l3, 8, OS.PROPVARIANT_sizeof());
        long l5 = 0L;
        if ((n & 2) != 0) {
            OS.MoveMemory(l4, new short[]{11}, 2);
            OS.MoveMemory(l4 + 8L, new short[]{-1}, 2);
            pROPERTYKEY = PKEY_AppUserModel_IsDestListSeparator;
        } else {
            String string2 = menuItem.getText();
            int n3 = string2.length();
            char[] cArray = new char[n3 + 1];
            string2.getChars(0, n3, cArray, 0);
            l5 = OS.HeapAlloc(l3, 8, cArray.length * 2);
            OS.MoveMemory(l5, cArray, cArray.length * 2);
            OS.MoveMemory(l4, new short[]{31}, 2);
            OS.MoveMemory(l4 + 8L, new long[]{l5}, OS.PTR_SIZEOF);
            pROPERTYKEY = PKEY_Title;
            String string3 = (String)menuItem.getData(EXE_PATH_KEY);
            if (string3 != null) {
                n3 = string3.length();
                cArray = new char[n3 + 1];
                string3.getChars(0, n3, cArray, 0);
            } else {
                cArray = EXE_PATH;
            }
            n2 = OS.VtblCall(20, l2, cArray);
            if (n2 != 0) {
                this.error(5);
            }
            if ((string2 = (String)menuItem.getData(EXE_ARGS_KEY)) == null) {
                string2 = "--launcher.openFile /SWTINTERNAL_ID" + menuItem.id;
            }
            n3 = string2.length();
            cArray = new char[n3 + 1];
            string2.getChars(0, n3, cArray, 0);
            n2 = OS.VtblCall(11, l2, cArray);
            if (n2 != 0) {
                this.error(5);
            }
            String string4 = (String)menuItem.getData(ICON_KEY);
            int n4 = 0;
            if (string4 != null) {
                string2 = (String)menuItem.getData(ICON_INDEX_KEY);
                if (string2 != null) {
                    n4 = Integer.parseInt(string2);
                }
            } else {
                Image image = menuItem.getImage();
                if (image != null && string != null) {
                    ImageData imageData;
                    Object object;
                    string4 = string + "\\menu" + menuItem.id + ".ico";
                    if (menuItem.hBitmap != 0L) {
                        object = Image.win32_new(this.display, 0, menuItem.hBitmap);
                        imageData = ((Image)object).getImageDataAtCurrentZoom();
                    } else {
                        imageData = image.getImageDataAtCurrentZoom();
                    }
                    object = new ImageLoader();
                    ((ImageLoader)object).data = new ImageData[]{imageData};
                    ((ImageLoader)object).save(string4, 3);
                }
            }
            if (string4 != null) {
                n3 = string4.length();
                cArray = new char[n3 + 1];
                string4.getChars(0, n3, cArray, 0);
                n2 = OS.VtblCall(17, l2, cArray, n4);
                if (n2 != 0) {
                    this.error(5);
                }
            }
        }
        n2 = OS.VtblCall(0, l2, IID_IPropertyStore, lArray);
        if (n2 != 0) {
            this.error(2);
        }
        if ((n2 = OS.VtblCall(6, l = lArray[0], pROPERTYKEY, l4)) != 0) {
            this.error(5);
        }
        OS.VtblCall(7, l);
        OS.VtblCall(2, l);
        OS.HeapFree(l3, 0, l4);
        if (l5 != 0L) {
            OS.HeapFree(l3, 0, l5);
        }
        return l2;
    }

    long createShellLinkArray(MenuItem[] menuItemArray, String string) {
        if (menuItemArray == null) {
            return 0L;
        }
        if (menuItemArray.length == 0) {
            return 0L;
        }
        long[] lArray = new long[1];
        int n = OS.CoCreateInstance(CLSID_EnumerableObjectCollection, 0L, 1, IID_IObjectCollection, lArray);
        if (n != 0) {
            this.error(2);
        }
        long l = lArray[0];
        for (int i = 0; i < menuItemArray.length; ++i) {
            long l2 = this.createShellLink(menuItemArray[i], string);
            if (l2 == 0L) continue;
            n = OS.VtblCall(5, l, l2);
            if (n != 0) {
                this.error(5);
            }
            OS.VtblCall(2, l2);
        }
        n = OS.VtblCall(0, l, IID_IObjectArray, lArray);
        if (n != 0) {
            this.error(2);
        }
        long l3 = lArray[0];
        OS.VtblCall(2, l);
        return l3;
    }

    void destroyItem(TaskItem taskItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != taskItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    String getDirectory(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        block3: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    cArray2[i] = 95;
                    continue block3;
                }
                default: {
                    cArray2[i] = c;
                }
            }
        }
        String string = null;
        long[] lArray = new long[1];
        int n = OS.SHCreateItemInKnownFolder(FOLDERID_LocalAppData, 0, null, IID_IShellItem, lArray);
        if (n == 0) {
            long l = lArray[0];
            n = OS.CoCreateInstance(CLSID_FileOperation, 0L, 1, IID_IFileOperation, lArray);
            if (n == 0) {
                long l2;
                long l3 = lArray[0];
                n = OS.VtblCall(5, l3, 1556);
                if (n == 0 && (l2 = this.getDirectory(l, l3, cArray2, false)) != 0L) {
                    long l4 = this.getDirectory(l2, l3, ICO_DIR, true);
                    if (l4 != 0L) {
                        n = OS.VtblCall(5, l4, -2147123200, lArray);
                        if (n == 0) {
                            long l5 = lArray[0];
                            int n2 = OS.wcslen(l5);
                            char[] cArray3 = new char[n2];
                            OS.MoveMemory(cArray3, l5, n2 * 2);
                            string = new String(cArray3);
                            OS.CoTaskMemFree(l5);
                        }
                        OS.VtblCall(2, l4);
                    }
                    OS.VtblCall(2, l2);
                }
                OS.VtblCall(2, l3);
            }
            OS.VtblCall(2, l);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getDirectory(long l, long l2, char[] cArray, boolean bl) {
        long[] lArray = new long[1];
        int n = OS.SHCreateItemFromRelativeName(l, cArray, 0L, IID_IShellItem, lArray);
        if (n == 0) {
            if (!bl) return lArray[0];
            n = OS.VtblCall(18, l2, lArray[0], 0);
            OS.VtblCall(2, lArray[0]);
            if (n != 0 || (n = OS.VtblCall(20, l2, l, 16, cArray, null, 0L)) != 0 || (n = OS.VtblCall(21, l2)) != 0 || (n = OS.SHCreateItemFromRelativeName(l, cArray, 0L, IID_IShellItem, lArray)) != 0) return 0L;
            return lArray[0];
        }
        n = OS.VtblCall(20, l2, l, 16, cArray, null, 0L);
        if (n != 0 || (n = OS.VtblCall(21, l2)) != 0 || (n = OS.SHCreateItemFromRelativeName(l, cArray, 0L, IID_IShellItem, lArray)) != 0) return 0L;
        return lArray[0];
    }

    public TaskItem getItem(int n) {
        this.checkWidget();
        this.createItems();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].shell != shell) continue;
            return this.items[i];
        }
        TaskItem taskItem = new TaskItem(this, 0);
        if (shell != null) {
            taskItem.setShell(shell);
        }
        return taskItem;
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] taskItemArray = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, taskItemArray, 0, taskItemArray.length);
        return taskItemArray;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TaskItem taskItem = this.items[i];
                if (taskItem == null || taskItem.isDisposed()) continue;
                taskItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.display.taskBar == this) {
            this.display.taskBar = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.mTaskbarList3 != 0L) {
            OS.VtblCall(2, this.mTaskbarList3);
            this.mTaskbarList3 = 0L;
        }
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TaskItem taskItem = this.items[i];
                if (taskItem == null) continue;
                taskItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    void setMenu(Menu menu) {
        long[] lArray = new long[1];
        int n = OS.CoCreateInstance(CLSID_DestinationList, 0L, 1, IID_ICustomDestinationList, lArray);
        if (n != 0) {
            this.error(2);
        }
        long l = lArray[0];
        String string = Display.APP_NAME;
        char[] cArray = new char[]{'S', 'W', 'T', '\u0000'};
        if (string != null && string.length() > 0) {
            int n2 = string.length();
            cArray = new char[n2 + 1];
            string.getChars(0, n2, cArray, 0);
        }
        MenuItem[] menuItemArray = null;
        if (menu != null && (menuItemArray = menu.getItems()).length != 0) {
            long l2;
            String string2 = null;
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (menuItem.getImage() == null || menuItem.getData(ICON_KEY) != null) continue;
                string2 = this.getDirectory(cArray);
                break;
            }
            if ((l2 = this.createShellLinkArray(menuItemArray, string2)) != 0L) {
                n = OS.VtblCall(3, l, cArray);
                if (n != 0) {
                    this.error(5);
                }
                int[] nArray = new int[1];
                OS.VtblCall(4, l, nArray, IID_IObjectArray, lArray);
                if (n != 0) {
                    this.error(5);
                }
                long l3 = lArray[0];
                int[] nArray2 = new int[1];
                OS.VtblCall(3, l2, nArray2);
                if (nArray2[0] != 0 && (n = OS.VtblCall(7, l, l2)) != 0) {
                    this.error(5);
                }
                for (int i = 0; i < menuItemArray.length; ++i) {
                    long l4;
                    Menu menu2;
                    MenuItem menuItem = menuItemArray[i];
                    if ((menuItem.getStyle() & 0x40) == 0 || (menu2 = menuItem.getMenu()) == null) continue;
                    MenuItem[] menuItemArray2 = menu2.getItems();
                    if (string2 == null) {
                        for (int j = 0; j < menuItemArray2.length; ++j) {
                            MenuItem menuItem2 = menuItemArray2[j];
                            if (menuItem2.getImage() == null || menuItem2.getData(ICON_KEY) != null) continue;
                            string2 = this.getDirectory(cArray);
                            break;
                        }
                    }
                    if ((l4 = this.createShellLinkArray(menuItemArray2, string2)) == 0L) continue;
                    OS.VtblCall(3, l4, nArray2);
                    if (nArray2[0] != 0) {
                        String string3 = menuItem.getText();
                        int n3 = string3.length();
                        char[] cArray2 = new char[n3 + 1];
                        string3.getChars(0, n3, cArray2, 0);
                        n = OS.VtblCall(5, l, cArray2, l4);
                        if (n != 0) {
                            this.error(5);
                        }
                    }
                    OS.VtblCall(2, l4);
                }
                n = OS.VtblCall(8, l);
                if (n != 0) {
                    this.error(5);
                }
                if (l3 != 0L) {
                    OS.VtblCall(2, l3);
                }
                OS.VtblCall(2, l2);
            }
        } else {
            n = OS.VtblCall(10, l, cArray);
            if (n != 0) {
                this.error(5);
            }
        }
        OS.VtblCall(2, l);
    }

    static {
        ICO_DIR = new char[]{'i', 'c', 'o', '_', 'd', 'i', 'r', '\u0000'};
        PKEY_Title = new PROPERTYKEY();
        PKEY_AppUserModel_IsDestListSeparator = new PROPERTYKEY();
        CLSID_TaskbarList = new byte[16];
        CLSID_DestinationList = new byte[16];
        CLSID_EnumerableObjectCollection = new byte[16];
        CLSID_ShellLink = new byte[16];
        CLSID_FileOperation = new byte[16];
        IID_ITaskbarList3 = new byte[16];
        IID_ICustomDestinationList = new byte[16];
        IID_IObjectArray = new byte[16];
        IID_IObjectCollection = new byte[16];
        IID_IShellLinkW = new byte[16];
        IID_IPropertyStore = new byte[16];
        IID_IShellItem = new byte[16];
        IID_IFileOperation = new byte[16];
        FOLDERID_LocalAppData = new byte[16];
        OS.IIDFromString("{56FDF344-FD6D-11d0-958A-006097C9A090}\u0000".toCharArray(), CLSID_TaskbarList);
        OS.IIDFromString("{77f10cf0-3db5-4966-b520-b7c54fd35ed6}\u0000".toCharArray(), CLSID_DestinationList);
        OS.IIDFromString("{2d3468c1-36a7-43b6-ac24-d3f02fd9607a}\u0000".toCharArray(), CLSID_EnumerableObjectCollection);
        OS.IIDFromString("{00021401-0000-0000-C000-000000000046}\u0000".toCharArray(), CLSID_ShellLink);
        OS.IIDFromString("{3ad05575-8857-4850-9277-11b85bdb8e09}\u0000".toCharArray(), CLSID_FileOperation);
        OS.IIDFromString("{EA1AFB91-9E28-4B86-90E9-9E9F8A5EEFAF}\u0000".toCharArray(), IID_ITaskbarList3);
        OS.IIDFromString("{6332debf-87b5-4670-90c0-5e57b408a49e}\u0000".toCharArray(), IID_ICustomDestinationList);
        OS.IIDFromString("{92CA9DCD-5622-4bba-A805-5E9F541BD8C9}\u0000".toCharArray(), IID_IObjectArray);
        OS.IIDFromString("{5632b1a4-e38a-400a-928a-d4cd63230295}\u0000".toCharArray(), IID_IObjectCollection);
        OS.IIDFromString("{000214F9-0000-0000-C000-000000000046}\u0000".toCharArray(), IID_IShellLinkW);
        OS.IIDFromString("{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}\u0000".toCharArray(), IID_IPropertyStore);
        OS.IIDFromString("{43826d1e-e718-42ee-bc55-a1e261c37bfe}\u0000".toCharArray(), IID_IShellItem);
        OS.IIDFromString("{947aab5f-0a5c-4c13-b4d6-4bf7836fc9f8}\u0000".toCharArray(), IID_IFileOperation);
        OS.IIDFromString("{F1B32785-6FBA-4FCF-9D55-7B8E7F157091}\u0000".toCharArray(), FOLDERID_LocalAppData);
        OS.PSPropertyKeyFromString("{F29F85E0-4FF9-1068-AB91-08002B27B3D9} 2\u0000".toCharArray(), PKEY_Title);
        OS.PSPropertyKeyFromString("{9F4C2855-9F79-4B39-A8D0-E1D42DE1D5F3}, 6\u0000".toCharArray(), PKEY_AppUserModel_IsDestListSeparator);
        TCHAR tCHAR = new TCHAR(0, 260);
        while (OS.GetModuleFileName(0L, tCHAR, tCHAR.length()) == tCHAR.length()) {
            tCHAR = new TCHAR(0, tCHAR.length() + 260);
        }
        int n = tCHAR.strlen();
        EXE_PATH = new char[n + 1];
        System.arraycopy(tCHAR.chars, 0, EXE_PATH, 0, n);
    }
}

