/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.rsa.discovery.zookeeper.publish.PublishingEndpointListenerFactory;
import org.apache.aries.rsa.discovery.zookeeper.subscribe.EndpointListenerTracker;
import org.apache.aries.rsa.discovery.zookeeper.subscribe.InterfaceMonitorManager;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperDiscovery
implements Watcher,
ManagedService {
    public static final String DISCOVERY_ZOOKEEPER_ID = "org.apache.cxf.dosgi.discovery.zookeeper";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDiscovery.class);
    private final BundleContext bctx;
    private PublishingEndpointListenerFactory endpointListenerFactory;
    private ServiceTracker<EndpointListener, EndpointListener> endpointListenerTracker;
    private InterfaceMonitorManager imManager;
    private ZooKeeper zkClient;
    private boolean closed;
    private boolean started;
    private Dictionary<String, ?> curConfiguration;

    public ZooKeeperDiscovery(BundleContext bctx) {
        this.bctx = bctx;
    }

    public synchronized void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        LOG.debug("Received configuration update for Zookeeper Discovery: {}", configuration);
        if (!ZooKeeperDiscovery.toMap(configuration).equals(ZooKeeperDiscovery.toMap(this.curConfiguration))) {
            this.stop(false);
            this.curConfiguration = configuration;
            if (!this.closed && configuration != null) {
                try {
                    this.createZookeeper(configuration);
                }
                catch (IOException e) {
                    throw new ConfigurationException(null, "Error starting zookeeper client", (Throwable)e);
                }
            }
        }
    }

    private synchronized void start() {
        if (this.closed) {
            return;
        }
        if (this.started) {
            LOG.debug("ZookeeperDiscovery already started");
            return;
        }
        LOG.debug("starting ZookeeperDiscovery");
        this.endpointListenerFactory = new PublishingEndpointListenerFactory(this.zkClient, this.bctx);
        this.endpointListenerFactory.start();
        this.imManager = new InterfaceMonitorManager(this.bctx, this.zkClient);
        this.endpointListenerTracker = new EndpointListenerTracker(this.bctx, this.imManager);
        this.endpointListenerTracker.open();
        this.started = true;
    }

    public synchronized void stop(boolean close) {
        if (this.started) {
            LOG.debug("stopping ZookeeperDiscovery");
        }
        this.started = false;
        this.closed |= close;
        if (this.endpointListenerFactory != null) {
            this.endpointListenerFactory.stop();
        }
        if (this.endpointListenerTracker != null) {
            this.endpointListenerTracker.close();
        }
        if (this.imManager != null) {
            this.imManager.close();
        }
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                LOG.error("Error closing ZooKeeper", (Throwable)e);
            }
        }
    }

    protected ZooKeeper createZooKeeper(String host, String port, int timeout) throws IOException {
        LOG.info("ZooKeeper discovery connecting to {}:{} with timeout {}", new Object[]{host, port, timeout});
        return new ZooKeeper(host + ":" + port, timeout, (Watcher)this);
    }

    public void process(WatchedEvent event) {
        LOG.debug("got ZooKeeper event " + event);
        switch (event.getState()) {
            case SyncConnected: {
                LOG.info("Connection to ZooKeeper established");
                this.start();
                break;
            }
            case Expired: {
                LOG.info("Connection to ZooKeeper expired. Trying to create a new connection");
                this.stop(false);
                try {
                    this.createZookeeper(this.curConfiguration);
                }
                catch (IOException e) {
                    LOG.error("Error starting zookeeper client", (Throwable)e);
                }
                break;
            }
        }
    }

    private void createZookeeper(Dictionary<String, ?> config) throws IOException {
        String host = (String)this.getWithDefault(config, "zookeeper.host", "localhost");
        String port = (String)this.getWithDefault(config, "zookeeper.port", "2181");
        int timeout = Integer.parseInt((String)this.getWithDefault(config, "zookeeper.timeout", "3000"));
        this.zkClient = this.createZooKeeper(host, port, timeout);
    }

    public Object getWithDefault(Dictionary<String, ?> config, String key, Object defaultValue) {
        Object value = config.get(key);
        return value != null ? value : defaultValue;
    }

    public static <K, V> Map<K, V> toMap(Dictionary<K, V> dict) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (dict != null) {
            Enumeration<K> keys = dict.keys();
            while (keys.hasMoreElements()) {
                K key = keys.nextElement();
                map.put(key, dict.get(key));
            }
        }
        return map;
    }
}

