/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur.metastore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;

public class PurRepositoryMetaStore
extends MemoryMetaStore
implements IMetaStore {
    public static final String ELEMENT_TYPE_DETAILS_FILENAME = "ElementTypeDetails";
    protected static final String PROP_NAME = "NAME";
    protected static final String PROP_ELEMENT_TYPE_NAME = "element_type_name";
    protected static final String PROP_ELEMENT_CHILDREN = "element_children";
    protected static final String PROP_ELEMENT_TYPE_DESCRIPTION = "element_type_description";
    protected static final String METASTORE_FOLDER_PATH = "/etc/metastore";
    protected PurRepository repository;
    protected IUnifiedRepository pur;
    protected RepositoryFile namespacesFolder;

    public PurRepositoryMetaStore(PurRepository repository) throws KettleException {
        this.repository = repository;
        this.pur = repository.getPur();
        this.namespacesFolder = this.pur.getFile(METASTORE_FOLDER_PATH);
        if (this.namespacesFolder == null) {
            throw new KettleException("/etc/metastore folder is not available");
        }
    }

    public String getName() {
        return this.repository.getRepositoryMeta().getName();
    }

    public String getDescription() {
        return this.repository.getRepositoryMeta().getDescription();
    }

    public void createNamespace(String namespace) throws MetaStoreException {
        if (this.namespaceExists(namespace)) {
            throw new MetaStoreNamespaceExistsException("Namespace '" + namespace + "' can not be created, it already exists");
        }
        RepositoryFile namespaceFolder = new RepositoryFile.Builder(namespace).folder(true).versioned(false).build();
        this.pur.createFolder(this.namespacesFolder.getId(), namespaceFolder, "Created namespace");
    }

    public boolean namespaceExists(String namespace) throws MetaStoreException {
        return this.getNamespaceRepositoryFile(namespace) != null;
    }

    public void deleteNamespace(String namespace) throws MetaStoreException {
        RepositoryFile namespaceFile = this.getNamespaceRepositoryFile(namespace);
        if (namespaceFile == null) {
            return;
        }
        List<RepositoryFile> children = this.getChildren(namespaceFile.getId());
        if (children != null && !children.isEmpty()) {
            ArrayList<String> elementTypeIds = new ArrayList<String>();
            for (RepositoryFile child : children) {
                elementTypeIds.add(child.getId().toString());
            }
            throw new MetaStoreDependenciesExistsException(elementTypeIds, "Namespace '" + namespace + " can not be deleted because it is not empty");
        }
        this.pur.deleteFile(namespaceFile.getId(), true, "Delete namespace");
    }

    public List<String> getNamespaces() throws MetaStoreException {
        ArrayList<String> namespaces = new ArrayList<String>();
        List<RepositoryFile> children = this.getChildren(this.namespacesFolder.getId());
        for (RepositoryFile child : children) {
            namespaces.add(child.getName());
        }
        return namespaces;
    }

    public void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile namespaceFile = this.validateNamespace(namespace);
        IMetaStoreElementType existingType = this.getElementTypeByName(namespace, elementType.getName());
        if (existingType != null) {
            throw new MetaStoreElementTypeExistsException(Collections.singletonList(existingType), "Can not create element type with id '" + elementType.getId() + "' because it already exists");
        }
        RepositoryFile elementTypeFile = new RepositoryFile.Builder(elementType.getName()).folder(true).versioned(false).build();
        RepositoryFile folder = this.pur.createFolder(namespaceFile.getId(), elementTypeFile, null);
        elementType.setId(folder.getId().toString());
        RepositoryFile detailsFile = new RepositoryFile.Builder(ELEMENT_TYPE_DETAILS_FILENAME).folder(false).title(ELEMENT_TYPE_DETAILS_FILENAME).description(elementType.getDescription()).hidden(true).build();
        DataNode dataNode = this.getElementTypeDataNode(elementType);
        this.pur.createFile(folder.getId(), detailsFile, (IRepositoryFileData)new NodeRepositoryFileData(dataNode), null);
        elementType.setMetaStoreName(this.getName());
    }

    public synchronized void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile folder = this.getElementTypeRepositoryFolder(namespace, elementType);
        RepositoryFile detailsFile = this.findChildByName(folder.getId(), ELEMENT_TYPE_DETAILS_FILENAME, true);
        DataNode dataNode = this.getElementTypeDataNode(elementType);
        this.pur.updateFile(detailsFile, (IRepositoryFileData)new NodeRepositoryFileData(dataNode), null);
        elementType.setMetaStoreName(this.getName());
    }

    private DataNode getElementTypeDataNode(IMetaStoreElementType elementType) {
        DataNode dataNode = new DataNode(ELEMENT_TYPE_DETAILS_FILENAME);
        dataNode.setProperty(PROP_ELEMENT_TYPE_DESCRIPTION, elementType.getDescription());
        dataNode.setProperty(PROP_ELEMENT_TYPE_NAME, elementType.getName());
        dataNode.setProperty(PROP_NAME, elementType.getName());
        return dataNode;
    }

    public IMetaStoreElementType getElementType(String namespace, String elementTypeId) throws MetaStoreException {
        NodeRepositoryFileData data;
        DataProperty property;
        RepositoryFile elementTypeFolder = this.pur.getFileById((Serializable)((Object)elementTypeId));
        if (elementTypeFolder == null) {
            return null;
        }
        IMetaStoreElementType elementType = this.newElementType(namespace);
        elementType.setId(elementTypeFolder.getId().toString());
        elementType.setName(elementTypeFolder.getName());
        RepositoryFile detailsFile = this.findChildByName(elementTypeFolder.getId(), ELEMENT_TYPE_DETAILS_FILENAME, true);
        if (detailsFile != null && (property = (data = (NodeRepositoryFileData)this.pur.getDataForRead(detailsFile.getId(), NodeRepositoryFileData.class)).getNode().getProperty(PROP_ELEMENT_TYPE_DESCRIPTION)) != null) {
            elementType.setDescription(property.getString());
        }
        return elementType;
    }

    public List<IMetaStoreElementType> getElementTypes(String namespace) throws MetaStoreException {
        ArrayList<IMetaStoreElementType> elementTypes = new ArrayList<IMetaStoreElementType>();
        RepositoryFile namespaceFile = this.validateNamespace(namespace);
        List<RepositoryFile> children = this.getChildren(namespaceFile.getId());
        for (RepositoryFile child : children) {
            if (child.isHidden().booleanValue()) continue;
            elementTypes.add(this.getElementType(namespace, child.getId().toString()));
        }
        return elementTypes;
    }

    public IMetaStoreElementType getElementTypeByName(String namespace, String elementTypeName) throws MetaStoreException {
        RepositoryFile file = this.getElementTypeRepositoryFileByName(namespace, elementTypeName);
        if (file == null) {
            return null;
        }
        return this.getElementType(namespace, file.getId().toString());
    }

    public List<String> getElementTypeIds(String namespace) throws MetaStoreException {
        ArrayList<String> ids = new ArrayList<String>();
        for (IMetaStoreElementType type : this.getElementTypes(namespace)) {
            ids.add(type.getId());
        }
        return ids;
    }

    public void deleteElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile namespaceRepositoryFile = this.validateNamespace(namespace);
        RepositoryFile elementTypeFile = this.findChildByName(namespaceRepositoryFile.getId(), elementType.getName());
        List<RepositoryFile> children = this.getChildren(elementTypeFile.getId());
        this.removeHiddenFilesFromList(children);
        if (!children.isEmpty()) {
            List<String> ids = this.getElementIds(namespace, elementType);
            throw new MetaStoreDependenciesExistsException(ids, "Can't delete element type with name '" + elementType.getName() + "' because it is not empty");
        }
        this.pur.deleteFile(elementTypeFile.getId(), true, null);
    }

    protected void removeHiddenFilesFromList(List<RepositoryFile> children) {
        Iterator<RepositoryFile> it = children.iterator();
        while (it.hasNext()) {
            RepositoryFile child = it.next();
            if (!child.isHidden().booleanValue()) continue;
            it.remove();
        }
    }

    public void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException {
        RepositoryFile elementTypeFolder = this.validateElementTypeRepositoryFolder(namespace, elementType);
        RepositoryFile elementFile = new RepositoryFile.Builder(PurRepository.checkAndSanitize(element.getName())).title(element.getName()).versioned(false).build();
        DataNode elementDataNode = new DataNode(PurRepository.checkAndSanitize(element.getName()));
        this.elementToDataNode(element, elementDataNode);
        RepositoryFile createdFile = this.pur.createFile(elementTypeFolder.getId(), elementFile, (IRepositoryFileData)new NodeRepositoryFileData(elementDataNode), null);
        element.setId(createdFile.getId().toString());
        if (this.pur.getFileById(createdFile.getId()) == null) {
            throw new RuntimeException("Unable to verify creation of element '" + element.getName() + "' in folder: " + elementTypeFolder.getPath());
        }
    }

    protected void elementToDataNode(IMetaStoreElement element, DataNode elementDataNode) {
        elementDataNode.setProperty(PROP_NAME, element.getName());
        DataNode childrenNode = elementDataNode.addNode(PROP_ELEMENT_CHILDREN);
        if (Utils.isEmpty((CharSequence)element.getId())) {
            element.setId(element.getName());
        }
        this.attributeToDataNode((IMetaStoreAttribute)element, childrenNode);
    }

    protected void dataNodeToElement(DataNode dataNode, IMetaStoreElement element) throws MetaStoreException {
        DataProperty nameProperty = dataNode.getProperty(PROP_NAME);
        if (nameProperty != null) {
            element.setName(nameProperty.getString());
        }
        DataNode childrenNode = dataNode.getNode(PROP_ELEMENT_CHILDREN);
        this.dataNodeToAttribute(childrenNode, (IMetaStoreAttribute)element);
    }

    public synchronized void updateElement(String namespace, IMetaStoreElementType elementType, String elementId, IMetaStoreElement element) throws MetaStoreException {
        String elementTypeName;
        if (!(elementType.getMetaStoreName() != null && elementType.getName().equals(this.getName()) || (elementType = this.getElementTypeByName(namespace, elementTypeName = elementType.getName())) != null)) {
            throw new MetaStoreException("The element type '" + elementTypeName + "' could not be found in the meta store in which you are updating.");
        }
        RepositoryFile existingFile = this.pur.getFileById((Serializable)((Object)elementId));
        if (existingFile == null) {
            throw new MetaStoreException("The element to update with id " + elementId + " could not be found in the store");
        }
        DataNode elementDataNode = new DataNode(PurRepository.checkAndSanitize(element.getName()));
        this.elementToDataNode(element, elementDataNode);
        RepositoryFile updatedFile = this.pur.updateFile(existingFile, (IRepositoryFileData)new NodeRepositoryFileData(elementDataNode), null);
        element.setId(updatedFile.getId().toString());
    }

    public IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        NodeRepositoryFileData data = (NodeRepositoryFileData)this.pur.getDataForRead((Serializable)((Object)elementId), NodeRepositoryFileData.class);
        if (data == null) {
            return null;
        }
        IMetaStoreElement element = this.newElement();
        element.setId(elementId);
        element.setElementType(elementType);
        DataNode dataNode = data.getNode();
        this.dataNodeToElement(dataNode, element);
        return element;
    }

    public List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<IMetaStoreElement> elements = new ArrayList<IMetaStoreElement>();
        RepositoryFile typeFolder = this.validateElementTypeRepositoryFolder(namespace, elementType);
        List<RepositoryFile> children = this.getChildren(typeFolder.getId());
        this.removeHiddenFilesFromList(children);
        for (RepositoryFile child : children) {
            IMetaStoreElement element = this.getElement(namespace, elementType, child.getId().toString());
            elements.add(element);
        }
        return elements;
    }

    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public List<String> getElementIds(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile folder = this.validateElementTypeRepositoryFolder(namespace, elementType);
        List<RepositoryFile> children = this.getChildren(folder.getId());
        this.removeHiddenFilesFromList(children);
        ArrayList<String> ids = new ArrayList<String>();
        for (RepositoryFile child : children) {
            ids.add(child.getId().toString());
        }
        return ids;
    }

    public void deleteElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        this.pur.deleteFile((Serializable)((Object)elementId), true, null);
    }

    protected void attributeToDataNode(IMetaStoreAttribute attribute, DataNode dataNode) {
        String id = attribute.getId();
        Object value = attribute.getValue();
        if (id == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            if (value instanceof Double) {
                dataNode.setProperty(id, ((Double)value).doubleValue());
            } else if (value instanceof Date) {
                dataNode.setProperty(id, (Date)value);
            } else if (value instanceof Long) {
                dataNode.setProperty(id, ((Long)value).longValue());
            } else {
                dataNode.setProperty(id, value.toString());
            }
        }
        for (IMetaStoreAttribute child : attribute.getChildren()) {
            DataNode subNode = new DataNode(child.getId());
            this.attributeToDataNode(child, subNode);
            dataNode.addNode(subNode);
        }
    }

    protected void dataNodeToAttribute(DataNode dataNode, IMetaStoreAttribute attribute) throws MetaStoreException {
        block6: for (DataProperty dataProperty : dataNode.getProperties()) {
            Object value;
            switch (dataProperty.getType()) {
                case DATE: {
                    value = dataProperty.getDate();
                    break;
                }
                case DOUBLE: {
                    value = dataProperty.getDouble();
                    break;
                }
                case LONG: {
                    value = dataProperty.getLong();
                    break;
                }
                case STRING: {
                    value = dataProperty.getString();
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (dataProperty.getName().equals(dataNode.getName())) {
                attribute.setValue(value);
            }
            attribute.addChild(this.newAttribute(dataProperty.getName(), value));
        }
        for (DataNode subNode : dataNode.getNodes()) {
            IMetaStoreAttribute subAttr = this.newAttribute(subNode.getName(), null);
            this.dataNodeToAttribute(subNode, subAttr);
            attribute.addChild(subAttr);
        }
    }

    protected RepositoryFile validateNamespace(String namespace) throws MetaStoreException {
        RepositoryFile namespaceFile = this.getNamespaceRepositoryFile(namespace);
        if (namespaceFile == null) {
            throw new MetaStoreException("Namespace '" + namespace + " doesn't exist in the repository");
        }
        return namespaceFile;
    }

    protected RepositoryFile validateElementTypeRepositoryFolder(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile elementTypeFolder = this.pur.getFileById((Serializable)((Object)elementType.getId()));
        if (elementTypeFolder == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.namespacesFolder.getPath()).append(Const.CR);
            String available = this.getMetaStoreFolders(builder, this.namespacesFolder, 0);
            throw new MetaStoreException("The element type with name '" + elementType.getName() + " doesn't exist in namespace '" + namespace + "'." + Const.CR + "Available nodes:" + Const.CR + available);
        }
        return elementTypeFolder;
    }

    private String getMetaStoreFolders(StringBuilder builder, RepositoryFile folder, int level) {
        String spaces = Const.rightPad((String)" ", (int)(level * 2));
        builder.append(spaces);
        if (folder.isFolder()) {
            builder.append("/");
        }
        builder.append(folder.getName()).append(Const.CR);
        for (RepositoryFile file : this.getChildren(folder.getId())) {
            this.getMetaStoreFolders(builder, file, level + 1);
        }
        return builder.toString();
    }

    protected RepositoryFile getNamespaceRepositoryFile(String namespace) {
        return this.findChildByName(this.namespacesFolder.getId(), namespace);
    }

    protected RepositoryFile getElementTypeRepositoryFolder(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        RepositoryFile namespaceRepositoryFile = this.validateNamespace(namespace);
        return this.findChildByName(namespaceRepositoryFile.getId(), elementType.getName());
    }

    protected RepositoryFile getElementTypeRepositoryFileByName(String namespace, String elementTypeName) {
        RepositoryFile namespaceFolder = this.getNamespaceRepositoryFile(namespace);
        if (namespace == null) {
            return null;
        }
        return this.findChildByName(namespaceFolder.getId(), elementTypeName);
    }

    protected RepositoryFile findChildByName(Serializable folderId, String childName, boolean showHiddenFiles) {
        for (RepositoryFile child : this.getChildren(folderId, showHiddenFiles)) {
            if (!child.getName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    protected RepositoryFile findChildByName(Serializable folderId, String childName) {
        return this.findChildByName(folderId, childName, false);
    }

    protected RepositoryFileAcl getAcls() {
        return null;
    }

    public IMetaStoreElementType newElementType(String namespace) throws MetaStoreException {
        IMetaStoreElementType elementType = super.newElementType(namespace);
        elementType.setMetaStoreName(this.getName());
        return elementType;
    }

    private List<RepositoryFile> getChildren(Serializable folderId) {
        return this.getChildren(folderId, false);
    }

    private List<RepositoryFile> getChildren(Serializable folderId, boolean showHiddenFiles) {
        return this.pur.getChildren(new RepositoryRequest(folderId.toString(), Boolean.valueOf(showHiddenFiles), Integer.valueOf(-1), null));
    }
}

