/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class PostgreSqlDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(PostgreSqlDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return super.acceptsConnection(connection) && !JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.GREENPLUM, connection) && !JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.NETEZZA, connection) && !JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.REDSHIFT, connection);
        }
    };

    public PostgreSqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (this.productVersion.compareTo("8.3") >= 0) {
            return this.generateOrderByNullsAnsi(expr, ascending, collateNullsLast);
        }
        return super.generateOrderByNulls(expr, ascending, collateNullsLast);
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.POSTGRESQL;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = javaRegex.replace("\\Q", "");
        javaRegex = javaRegex.replace("\\E", "");
        StringBuilder sb = new StringBuilder();
        sb.append("cast(");
        sb.append(source);
        sb.append(" as text) is not null and ");
        sb.append("cast(");
        sb.append(source);
        sb.append(" as text) ~ ");
        this.quoteStringLiteral(sb, javaRegex);
        return sb.toString();
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int precision = metaData.getPrecision(columnIndex + 1);
        int scale = metaData.getScale(columnIndex + 1);
        int columnType = metaData.getColumnType(columnIndex + 1);
        String columnName = metaData.getColumnName(columnIndex + 1);
        if (columnType == 2 && scale == 0 && precision == 0 && columnName.startsWith("m")) {
            this.logTypeInfo(metaData, columnIndex, SqlStatement.Type.OBJECT);
            return SqlStatement.Type.OBJECT;
        }
        return super.getType(metaData, columnIndex);
    }
}

