/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.spi.Dialect;
import mondrian.spi.impl.HiveDialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class ImpalaDialect
extends HiveDialect {
    private final String flagsRegexp = "^(\\(\\?([a-zA-Z])\\)).*$";
    private final Pattern flagsPattern = Pattern.compile("^(\\(\\?([a-zA-Z])\\)).*$");
    private final String escapeRegexp = "(\\\\Q([^\\\\Q]+)\\\\E)";
    private final Pattern escapePattern = Pattern.compile("(\\\\Q([^\\\\Q]+)\\\\E)");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(ImpalaDialect.class, Dialect.DatabaseProduct.IMPALA){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.IMPALA, connection);
        }
    };

    public ImpalaDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        return "`";
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.IMPALA;
    }

    @Override
    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (ascending) {
            return expr + " ASC";
        }
        return expr + " DESC";
    }

    @Override
    public String generateOrderItem(String expr, boolean nullable, boolean ascending, boolean collateNullsLast) {
        String ret = null;
        ret = nullable && collateNullsLast ? "CASE WHEN " + expr + " IS NULL THEN 1 ELSE 0 END, " : "CASE WHEN " + expr + " IS NULL THEN 0 ELSE 1 END, ";
        ret = ascending ? ret + expr + " ASC" : ret + expr + " DESC";
        return ret;
    }

    @Override
    public boolean allowsMultipleCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return true;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return false;
    }

    @Override
    public boolean allowsSelectNotInGroupBy() {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public boolean allowsJoinOn() {
        return false;
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String value) {
        String quote = "'";
        String s0 = value;
        if (s0.contains("\\")) {
            s0.replaceAll("\\\\", "\\\\");
        }
        if (s0.contains(quote)) {
            s0 = s0.replaceAll(quote, "\\\\" + quote);
        }
        buf.append(quote);
        buf.append(s0);
        buf.append(quote);
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        String flags;
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        Matcher flagsMatcher = this.flagsPattern.matcher(javaRegex);
        boolean caseSensitive = true;
        if (flagsMatcher.matches() && (flags = flagsMatcher.group(2)).contains("i")) {
            caseSensitive = false;
        }
        if (flagsMatcher.matches()) {
            javaRegex = javaRegex.substring(0, flagsMatcher.start(1)) + javaRegex.substring(flagsMatcher.end(1));
        }
        Matcher escapeMatcher = this.escapePattern.matcher(javaRegex);
        while (escapeMatcher.find()) {
            javaRegex = javaRegex.replace(escapeMatcher.group(1), escapeMatcher.group(2));
        }
        source = "cast(" + source + " as string)";
        StringBuilder sb = new StringBuilder();
        sb.append(source);
        sb.append(" IS NOT NULL AND ");
        if (caseSensitive) {
            sb.append(source);
        } else {
            sb.append("UPPER(");
            sb.append(source);
            sb.append(")");
        }
        sb.append(" REGEXP ");
        if (caseSensitive) {
            this.quoteStringLiteral(sb, javaRegex);
        } else {
            this.quoteStringLiteral(sb, javaRegex.toUpperCase());
        }
        return sb.toString();
    }

    @Override
    public boolean allowsDdl() {
        return true;
    }
}

