/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class SystemSettings
extends PentahoBase
implements ISystemSettings {
    private static final long serialVersionUID = 3727605230748352557L;
    public static final String PENTAHOSETTINGSFILENAME = "pentaho.xml";
    private static final String LOG_NAME = Messages.getInstance().getString("SYSTEMSETTINGS.CODE_LOG_NAME");
    private static final Log logger = LogFactory.getLog(SystemSettings.class);
    private final Map settingsDocumentMap = new ConcurrentHashMap();
    String logId = LOG_NAME + ":";

    public String getSystemSetting(String path, String settingName, String defaultValue) {
        this.debug(Messages.getInstance().getString("SYSTEMSETTINGS.DEBUG_GET_SYSTEM_SETTING_PATH", File.separator + path));
        Document doc = this.getSystemSettingsDocument(path);
        if (doc == null) {
            return defaultValue;
        }
        Node node = doc.selectSingleNode("//" + settingName);
        if (node == null) {
            return defaultValue;
        }
        return node.getText();
    }

    public String getSystemSetting(String settingName, String defaultValue) {
        return this.getSystemSetting(PENTAHOSETTINGSFILENAME, settingName, defaultValue);
    }

    public List getSystemSettings(String path, String settingName) {
        List settings = (List)this.settingsDocumentMap.get(path + settingName);
        if (settings != null) {
            return settings;
        }
        Document doc = this.getSystemSettingsDocument(path);
        if (doc == null) {
            return null;
        }
        settings = doc.selectNodes("//" + settingName);
        this.settingsDocumentMap.put(path + settingName, settings);
        return settings;
    }

    public List getSystemSettings(String settingName) {
        return this.getSystemSettings(PENTAHOSETTINGSFILENAME, settingName);
    }

    public Document getSettingsDocumentFromFile(File f) throws IOException, DocumentException {
        return XmlDom4JHelper.getDocFromFile(f, null);
    }

    public Document getSystemSettingsDocument(String actionPath) {
        Document systemSettingsDocument = (Document)this.settingsDocumentMap.get(actionPath);
        if (systemSettingsDocument == null) {
            File f = this.getFile(actionPath);
            if (f == null) {
                return null;
            }
            try {
                systemSettingsDocument = this.getSettingsDocumentFromFile(f);
                this.settingsDocumentMap.put(actionPath, systemSettingsDocument);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return systemSettingsDocument;
    }

    private File getFile(String path) {
        File f = new File(this.getAbsolutePath(path));
        if (!f.exists()) {
            this.error(Messages.getInstance().getErrorString("SYSTEMSETTINGS.ERROR_0002_FILE_NOT_IN_SOLUTION", f.getAbsolutePath()));
            return null;
        }
        this.debug(Messages.getInstance().getString("SYSTEMSETTINGS.DEBUG_SYSTEM_SETTINGS_GET_FILE", f.getAbsolutePath()));
        return f;
    }

    protected String getAbsolutePath(String path) {
        return PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + path);
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    public void resetSettingsCache() {
        this.settingsDocumentMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getSystemSettingsProperties(String path) {
        block7: {
            Properties properties;
            String fullPath = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + path);
            File propsFile = new File(fullPath);
            if (!propsFile.exists()) {
                return null;
            }
            Properties props = new Properties();
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(propsFile));
            try {
                props.load(fileInputStream);
                properties = props;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)Messages.getInstance().getErrorString("SystemSettings.ERROR_0003_FAILED_INITIALIZE", path), (Throwable)e);
                    break block7;
                }
                catch (IOException ioe) {
                    logger.error((Object)Messages.getInstance().getErrorString("SystemSettings.ERROR_0003_FAILED_INITIALIZE", path), (Throwable)ioe);
                }
            }
            ((InputStream)fileInputStream).close();
            return properties;
        }
        return null;
    }

    public String getSystemCfgSourceName() {
        return this.getAbsolutePath(PENTAHOSETTINGSFILENAME);
    }
}

