/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.apache.aries.rsa.provider.fastbin.api.AsyncCallback;
import org.apache.aries.rsa.provider.fastbin.tcp.AsyncFutureInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AsyncInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AsyncPromiseInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.BlockingInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationStrategy;
import org.osgi.util.promise.Promise;

public enum InvocationType {
    ASYNC_FUTURE(new AsyncFutureInvocationStrategy()){

        @Override
        protected boolean applies(Method method) {
            Class<?> returnType = method.getReturnType();
            if (returnType != null) {
                return Future.class.isAssignableFrom(returnType);
            }
            return false;
        }
    }
    ,
    ASYNC_CALLBACK(new AsyncInvocationStrategy()){

        @Override
        protected boolean applies(Method method) {
            Class<?>[] types = method.getParameterTypes();
            return types.length != 0 && types[types.length - 1] == AsyncCallback.class;
        }
    }
    ,
    PROMISE(new AsyncPromiseInvocationStrategy()){

        @Override
        protected boolean applies(Method method) {
            if (!promiseAvailable) {
                return false;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType != null) {
                return Promise.class.isAssignableFrom(returnType);
            }
            return false;
        }
    }
    ,
    BLOCKING(new BlockingInvocationStrategy()){

        @Override
        protected boolean applies(Method method) {
            return true;
        }
    };

    private InvocationStrategy strategy;
    private static boolean promiseAvailable;

    private InvocationType(InvocationStrategy strategy) {
        this.strategy = strategy;
    }

    public static InvocationStrategy forMethod(Method method) {
        InvocationType[] values;
        for (InvocationType invocationType : values = InvocationType.values()) {
            if (!invocationType.applies(method)) continue;
            return invocationType.strategy;
        }
        return null;
    }

    protected abstract boolean applies(Method var1);

    static {
        try {
            String name = Promise.class.getName();
            promiseAvailable = true;
        }
        catch (Throwable t) {
            promiseAvailable = false;
        }
    }
}

