/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;

public class HiveSemiJoin
extends SemiJoin
implements HiveRelNode {
    public static final RelFactories.SemiJoinFactory HIVE_SEMIJOIN_FACTORY = new HiveSemiJoinFactoryImpl();
    private final RexNode joinFilter;

    public static HiveSemiJoin getSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        try {
            HiveSemiJoin semiJoin = new HiveSemiJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys);
            return semiJoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new RuntimeException(e);
        }
    }

    protected HiveSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) throws InvalidRelException, CalciteSemanticException {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys);
        ImmutableList<RelDataTypeField> systemFieldList = ImmutableList.of();
        ArrayList<List<RexNode>> joinKeyExprs = new ArrayList<List<RexNode>>();
        ArrayList<Integer> filterNulls = new ArrayList<Integer>();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            joinKeyExprs.add(new ArrayList());
        }
        this.joinFilter = HiveRelOptUtil.splitJoinCondition(systemFieldList, this.getInputs(), this.getCondition(), joinKeyExprs, filterNulls, null);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
            HiveSemiJoin semijoin = new HiveSemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
            HiveRulesRegistry registry = (HiveRulesRegistry)semijoin.getCluster().getPlanner().getContext().unwrap(HiveRulesRegistry.class);
            if (registry != null) {
                registry.copyPushedPredicates(this, semijoin);
            }
            return semijoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return RelMetadataQuery.getNonCumulativeCost((RelNode)this);
    }

    private static class HiveSemiJoinFactoryImpl
    implements RelFactories.SemiJoinFactory {
        private HiveSemiJoinFactoryImpl() {
        }

        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
            RelOptCluster cluster = left.getCluster();
            return HiveSemiJoin.getSemiJoin(cluster, left.getTraitSet(), left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }
}

