/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.reporting;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface SubscriptionManager {
    public <S extends LogicalModelElement, D extends Serializable> Publisher<PDIEvent<S, D>> eventStream(S var1, Class<D> var2);

    public Collection<LogicalModelElement> getReportingSources();

    default public <S extends LogicalModelElement, D extends Serializable> void subscribe(S source, Class<D> type, Subscriber<? super PDIEvent<S, D>> subscriber) {
        this.eventStream(source, type).subscribe(subscriber);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribe(S source, Class<D> type, final Consumer<D> onNext, final Consumer<Throwable> onError, final Runnable onComplete) {
        this.subscribe(source, type, new Subscriber<PDIEvent<S, D>>(){

            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            public void onNext(PDIEvent<S, D> event) {
                if (onNext != null) {
                    onNext.accept(event.getData());
                }
            }

            public void onError(Throwable t) {
                if (onError != null) {
                    onError.accept(t);
                }
            }

            public void onComplete() {
                if (onComplete != null) {
                    onComplete.run();
                }
            }
        });
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribe(S source, Class<D> type, Consumer<D> onNext, Runnable onComplete) {
        this.subscribe(source, type, onNext, null, onComplete);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribe(S source, Class<D> type, Consumer<D> onNext, Consumer<Throwable> onError) {
        this.subscribe(source, type, onNext, onError, null);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribe(S source, Class<D> type, Consumer<D> onNext) {
        this.subscribe(source, type, onNext, null, null);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribeAll(Class<S> sourceType, Class<D> type, BiConsumer<S, D> onNext, BiConsumer<S, Throwable> onError, Consumer<S> onComplete) {
        this.getReportingSources().stream().filter(sourceType::isInstance).map(sourceType::cast).forEach(s -> {
            Consumer<Serializable> next = onNext == null ? null : d -> onNext.accept(s, d);
            Consumer<Throwable> error = onError == null ? null : t -> onError.accept((Object)s, (Throwable)t);
            Runnable complete = onComplete == null ? null : () -> onComplete.accept(s);
            this.subscribe(s, type, next, error, complete);
        });
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribeAll(Class<S> sourceType, Class<D> type, BiConsumer<S, D> onNext, Consumer<S> onComplete) {
        this.subscribeAll(sourceType, type, onNext, null, onComplete);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribeAll(Class<S> sourceType, Class<D> type, BiConsumer<S, D> onNext, BiConsumer<S, Throwable> onError) {
        this.subscribeAll(sourceType, type, onNext, onError, null);
    }

    default public <S extends LogicalModelElement, D extends Serializable> void subscribeAll(Class<S> sourceType, Class<D> type, BiConsumer<S, D> onNext) {
        this.subscribeAll(sourceType, type, onNext, null, null);
    }
}

