/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.pentaho.pdi.spark.driver.Messages;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.CommandLineHandler;
import org.pentaho.pdi.spark.driver.app.builder.SparkDriverAssembly;

public class SparkDriverAppBuilder {
    public static void main(String[] args) {
        CommandLineHandler commandLineHandler = new CommandLineHandler(args);
        AppBuilderContext context = commandLineHandler.parse();
        if (context == null || !context.isValid()) {
            return;
        }
        System.out.println(Messages.getString("INFO.CreatingZip", context.getOutputFilePath()));
        SparkDriverAssembly driverAssembly = new SparkDriverAssembly(context);
        try {
            File pluginsfolder;
            driverAssembly.build();
            if (driverAssembly.driverBuilder.getExcludedPlugins().size() > 0) {
                System.out.println("");
                System.out.println("**************************");
                System.out.println("* " + Messages.getString("INFO.PluginsExcluded"));
                System.out.println("**************************");
                driverAssembly.driverBuilder.getExcludedPlugins().stream().forEach(path -> System.out.println(path.toFile().getName()));
            }
            if ((pluginsfolder = new File(context.getPdiLocation(), "plugins")) != null && pluginsfolder.listFiles() != null && pluginsfolder.listFiles().length > driverAssembly.driverBuilder.getExcludedPlugins().size()) {
                System.out.println("");
                System.out.println("**************************");
                System.out.println("* " + Messages.getString("INFO.PluginsIncluded"));
                System.out.println("**************************");
                Arrays.stream(pluginsfolder.listFiles()).filter(File::isDirectory).filter(file -> {
                    Optional<String> first = driverAssembly.driverBuilder.getExcludedPlugins().stream().map(path -> path.toFile().getAbsolutePath()).filter(s -> s.equals(file.getAbsolutePath())).findFirst();
                    return !first.isPresent();
                }).forEach(file -> System.out.println(file.getName()));
            }
            System.out.println("");
            System.out.println(Messages.getString("INFO.Done"));
        }
        catch (IOException e) {
            System.err.println(Messages.getString("ERROR.FailedToBuildZip", context.getOutputFilePath()));
            e.printStackTrace();
        }
    }
}

