/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.remote.client;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pentaho.di.core.annotations.EnginePlugin;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.Execution;
import org.pentaho.di.engine.api.remote.ExecutionManager;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.remote.client.Context;
import org.pentaho.osgi.objecttunnel.TunnelFactory;
import org.pentaho.osgi.objecttunnel.TunnelInput;
import org.pentaho.osgi.objecttunnel.TunneledInputObject;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnginePlugin(id="remote", name="Spark Remote Engine")
public class RemoteClientEngine
implements Engine {
    private static Logger logger = LoggerFactory.getLogger(RemoteClientEngine.class);
    static final String ENDPOINT_ID_PROPERTY = "execution.uuid";
    static final String ENGINE_TYPE_PARAMETER = "engine.remote";
    static final String CLUSTER_NAME_PARAMETER = "engine.remote.cluster";
    static final String DEFAULT_ENGINE_TYPE = "spark";
    static final String DEFAULT_CLUSTER_NAME = "default";
    static final String SERVICE_ENGINE_TYPE_PROPERTY = "service.engine.type";
    static final String SERVICE_CLUSTER_NAME_PROPERTY = "service.cluster.name";
    private final Map<ExecutionManagerKey, ExecutionManager> executionManagers = Maps.newHashMap();
    private final ConcurrentMap<String, CompletableFuture<Execution>> activeExecutions = Maps.newConcurrentMap();
    private final ConcurrentMap<ExecutionManagerKey, CompletableFuture<ExecutionManager>> availableManagers = Maps.newConcurrentMap();
    private TunnelFactory tunnelFactory;

    public RemoteClientEngine(TunnelFactory tunnelFactory) {
        this.tunnelFactory = tunnelFactory;
    }

    public ExecutionContext prepare(Transformation trans) {
        return new Context(this, trans);
    }

    public String getId() {
        return RemoteClientEngine.class.getAnnotation(EnginePlugin.class).id();
    }

    CompletableFuture<ExecutionResult> execute(Context context) {
        CompletableFuture<ExecutionResult> result = this.generateReport(context);
        ExecutionRequest request = context.createRequest();
        String engineType = Optional.ofNullable(request.getParameters().get(ENGINE_TYPE_PARAMETER)).map(Object::toString).map(Strings::emptyToNull).orElse(DEFAULT_ENGINE_TYPE);
        String clusterName = Optional.ofNullable(request.getParameters().get(CLUSTER_NAME_PARAMETER)).map(Object::toString).map(Strings::emptyToNull).orElse(DEFAULT_CLUSTER_NAME);
        logger.info("Attempting to submit {0} to ExecutionManager[{1}, {2}]", new Object[]{request.getTransformation().getId(), engineType, clusterName});
        try {
            this.getExecutionManager(this.createKey(engineType, clusterName)).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("Interuppted while waiting for execution manager {0}", (Object)engineType);
        }
        List<ExecutionManager> managers = this.executionManagers.values().stream().filter(this.findManager(engineType, clusterName)).collect(Collectors.toList());
        logger.info("Located {0} available managers", (Object)managers.size());
        this.submit(request, managers).timeout(30L, TimeUnit.SECONDS, (SingleSource)Single.error(() -> new TimeoutException("Execution manager is not responding"))).observeOn(Schedulers.computation()).flatMap(endpointId -> {
            logger.info("Connecting to {0} : {1}", (Object)ENDPOINT_ID_PROPERTY, endpointId);
            return Single.create(RemoteClientEngine.subscribeTo(this.getExecution((String)endpointId))).timeout(30L, TimeUnit.SECONDS, (SingleSource)Single.error(() -> new TimeoutException("Unable to locate execution service")));
        }).doOnSuccess(execution -> logger.info("Connected to {0}", execution)).flatMapPublisher(this::processExecutionEvents).subscribe((Subscriber)context);
        return result;
    }

    private CompletableFuture<ExecutionResult> generateReport(Context context) {
        CompletableFuture<ExecutionResult> result = new CompletableFuture<ExecutionResult>();
        context.getTransformation().getOperations().stream().map(op -> context.eventStream(op, Metrics.class)).map(Flowable::fromPublisher).reduce(Flowable.empty(), Flowable::merge).toMap(PDIEvent::getSource, PDIEvent::getData).map(x$0 -> new Result((Map<Operation, Metrics>)x$0)).subscribe(result::complete, result::completeExceptionally);
        return result;
    }

    private Predicate<ExecutionManager> findManager(String engineType, String clusterName) {
        return executionManager -> Objects.equals(executionManager.getEngineType(), engineType) && Objects.equals(executionManager.getClusterName(), clusterName);
    }

    private Single<String> submit(ExecutionRequest request, List<ExecutionManager> managers) {
        if (managers.isEmpty()) {
            return Single.error((Throwable)new RuntimeException("No managers are available to submit transformation for execution"));
        }
        CompletableFuture future = managers.get(0).submit(request);
        return Single.create(RemoteClientEngine.subscribeTo(future)).onErrorResumeNext(error -> {
            if (managers.size() > 1) {
                logger.warn("Error submitting request, trying again", error);
                return this.submit(request, managers.subList(1, managers.size()));
            }
            return Single.error((Throwable)error);
        });
    }

    private Flowable<PDIEvent> processExecutionEvents(Execution execution) throws IOException {
        TunnelInput input = this.tunnelFactory.createInput(new ObjectInputStream(execution.eventStream()));
        input.setErrorThreshold(30);
        return Flowable.fromPublisher((Publisher)input).doOnSubscribe(subscription -> input.open()).map(TunneledInputObject::getObject).ofType(PDIEvent.class);
    }

    private CompletableFuture<Execution> getExecution(String endpointId) {
        return this.activeExecutions.computeIfAbsent(endpointId, key -> new CompletableFuture());
    }

    public void bindExecution(Execution execution, Map<String, String> properties) {
        String id = properties.get(ENDPOINT_ID_PROPERTY);
        if (id != null && execution != null) {
            this.getExecution(id).complete(execution);
        }
    }

    public void unbindExecution(Execution execution, Map<String, String> properties) {
        String id = properties.get(ENDPOINT_ID_PROPERTY);
        if (id != null) {
            this.activeExecutions.remove(id);
        }
    }

    public Map<String, CompletableFuture<Execution>> getActiveExecutions() {
        return ImmutableMap.copyOf(this.activeExecutions);
    }

    private CompletableFuture<ExecutionManager> getExecutionManager(ExecutionManagerKey executionManagerKey) {
        return this.availableManagers.computeIfAbsent(executionManagerKey, key -> new CompletableFuture());
    }

    public void bindExecutionManager(ExecutionManager executionManager, Map<String, String> properties) {
        if (executionManager != null) {
            ExecutionManagerKey key = this.createKey(properties.get(SERVICE_ENGINE_TYPE_PROPERTY), properties.get(SERVICE_CLUSTER_NAME_PROPERTY));
            this.executionManagers.put(key, executionManager);
            this.getExecutionManager(key).complete(executionManager);
        }
    }

    public void unbindExecutionManager(ExecutionManager executionManager, Map<String, String> properties) {
        if (executionManager != null) {
            ExecutionManagerKey key = this.createKey(properties.get(SERVICE_ENGINE_TYPE_PROPERTY), properties.get(SERVICE_CLUSTER_NAME_PROPERTY));
            this.executionManagers.remove(key);
            this.availableManagers.remove(key);
        }
    }

    public Map<ExecutionManagerKey, CompletableFuture<ExecutionManager>> getAvailableManagers() {
        return ImmutableMap.copyOf(this.availableManagers);
    }

    private static <T> SingleOnSubscribe<T> subscribeTo(CompletableFuture<T> future) {
        return e -> {
            future.whenComplete((value, error) -> {
                if (value != null) {
                    e.onSuccess(value);
                } else {
                    e.onError(error);
                }
            });
            e.setCancellable(() -> future.cancel(false));
        };
    }

    private ExecutionManagerKey createKey(String engineType, String clusterName) {
        return new ExecutionManagerKey(engineType, clusterName);
    }

    private class ExecutionManagerKey {
        private String engineType;
        private String clusterName;

        public ExecutionManagerKey(String engineType, String clusterName) {
            this.engineType = engineType;
            this.clusterName = clusterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionManagerKey executionManagerKey = (ExecutionManagerKey)o;
            return Objects.equals(this.engineType, executionManagerKey.engineType) && Objects.equals(this.clusterName, executionManagerKey.clusterName);
        }

        public int hashCode() {
            return Objects.hash(this.engineType, this.clusterName);
        }
    }

    private class Result
    implements ExecutionResult {
        private final Map<Operation, Metrics> report;

        Result(Map<Operation, Metrics> report) {
            this.report = report;
        }

        public Map<Operation, Metrics> getDataEventReport() {
            return this.report;
        }
    }
}

