/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.remote.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.converter.RowConversionManager;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.api.reporting.Topic;
import org.pentaho.di.engine.remote.client.RemoteClientEngine;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class Context
implements ExecutionContext,
Subscriber<PDIEvent> {
    private final RemoteClientEngine engine;
    private final Transformation transformation;
    private final ImmutableList<LogicalModelElement> reportingSources;
    private final ConcurrentMap<Topic, Flowable<? extends Serializable>> subscriptions = Maps.newConcurrentMap();
    private final FlowableProcessor<PDIEvent> eventProcessor = PublishProcessor.create();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private Principal actingPrincipal;
    private LogLevel loggingLogLevel = LogLevel.BASIC;

    Context(RemoteClientEngine engine, Transformation transformation) {
        this(engine, transformation, (Map<String, Object>)ImmutableMap.of(), Context.getReportingSources(transformation));
    }

    private Context(RemoteClientEngine engine, Transformation transformation, Map<String, Object> parameters, ImmutableList<LogicalModelElement> reportingSources) {
        this.engine = engine;
        this.transformation = transformation;
        this.parameters.putAll(parameters);
        this.reportingSources = reportingSources;
    }

    private static ImmutableList<LogicalModelElement> getReportingSources(Transformation transformation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)transformation);
        builder.addAll((Iterable)transformation.getOperations());
        builder.addAll((Iterable)transformation.getHops());
        return builder.build();
    }

    public Map<String, Object> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public Map<String, Object> getEnvironment() {
        return ImmutableMap.copyOf(this.environment);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void setEnvironment(String key, Object value) {
        this.environment.put(key, value);
    }

    public void setLoggingLogLevel(LogLevel logLevel) {
        this.loggingLogLevel = logLevel;
    }

    public LogLevel getLoggingLogLevel() {
        return this.loggingLogLevel;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    Map<String, Set<Class<? extends Serializable>>> getReportingTopics() {
        return this.subscriptions.keySet().stream().collect(Collectors.groupingBy(Topic::getSourceId, Collectors.mapping(Topic::getEventType, Collectors.toSet())));
    }

    public CompletableFuture<ExecutionResult> execute() {
        return this.engine.execute(this);
    }

    public Principal getActingPrincipal() {
        return this.actingPrincipal;
    }

    public void setActingPrincipal(Principal actingPrincipal) {
        this.actingPrincipal = actingPrincipal;
    }

    ExecutionRequest createRequest() {
        return new ExecutionRequest(this.parameters, this.environment, this.transformation, this.getReportingTopics(), this.loggingLogLevel, this.actingPrincipal);
    }

    public RowConversionManager getConversionManager() {
        return null;
    }

    public <S extends LogicalModelElement, D extends Serializable> Publisher<PDIEvent<S, D>> eventStream(S source, Class<D> type) {
        return this.subscriptions.computeIfAbsent(new Topic(source, type), this::topicStream).cast(type).map(data -> LocalReportingEvent.create(source, data));
    }

    public Collection<LogicalModelElement> getReportingSources() {
        return this.reportingSources;
    }

    private Flowable<? extends Serializable> topicStream(Topic topic) {
        return this.eventProcessor.serialize().filter(event -> Objects.equals(event.getSource().getId(), topic.getSourceId())).map(PDIEvent::getData).ofType(topic.getEventType());
    }

    public void onSubscribe(Subscription s) {
        this.eventProcessor.onSubscribe(s);
    }

    public void onNext(PDIEvent event) {
        this.eventProcessor.onNext((Object)event);
    }

    public void onError(Throwable t) {
        this.eventProcessor.onError(t);
    }

    public void onComplete() {
        this.eventProcessor.onComplete();
    }

    private static class LocalReportingEvent<S extends LogicalModelElement, D extends Serializable>
    implements PDIEvent<S, D> {
        private final S source;
        private final D data;

        static <S extends LogicalModelElement, D extends Serializable> PDIEvent<S, D> create(S source, D data) {
            return new LocalReportingEvent<S, D>(source, data);
        }

        LocalReportingEvent(S source, D data) {
            this.source = source;
            this.data = data;
        }

        public S getSource() {
            return this.source;
        }

        public D getData() {
            return this.data;
        }
    }
}

