/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.dataservice.client.ConnectionAbortingSupport;
import org.pentaho.di.trans.dataservice.client.DataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinServiceInformation;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RemoteClient
implements DataServiceClientService,
ConnectionAbortingSupport {
    private static final String SQL = "SQL";
    private static final String MAX_ROWS = "MaxRows";
    private static final int MAX_SQL_LENGTH = 7500;
    private final ThinConnection connection;
    private final HttpClient client;
    private DocumentBuilderFactory docBuilderFactory;
    private static final String SERVICE_PATH = "/sql/";
    private final CopyOnWriteArrayList<PostMethod> activeMethods = new CopyOnWriteArrayList();

    RemoteClient(ThinConnection connection, HttpClient client) {
        this.connection = connection;
        this.client = client;
    }

    @Override
    public DataInputStream query(String sql, int maxRows) throws SQLException {
        Object object;
        PostMethod method = null;
        try {
            String url = this.connection.constructUrl(SERVICE_PATH);
            method = new PostMethod(url);
            method.setDoAuthentication(true);
            method.getParams().setParameter("http.socket.timeout", (Object)0);
            if (sql.length() < 7500) {
                method.addRequestHeader(new Header(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' ')));
                method.addRequestHeader(new Header(MAX_ROWS, Integer.toString(maxRows)));
            }
            method.addParameter(SQL, CharMatcher.anyOf((CharSequence)"\n\r").collapseFrom((CharSequence)sql, ' '));
            method.addParameter(MAX_ROWS, Integer.toString(maxRows));
            for (Map.Entry parameterEntry : this.connection.getParameters().entrySet()) {
                method.addParameter((String)parameterEntry.getKey(), (String)parameterEntry.getValue());
            }
            if (!Strings.isNullOrEmpty((String)this.connection.getDebugTransFilename())) {
                method.addParameter("debugtrans", this.connection.getDebugTransFilename());
            }
            this.activeMethods.add(method);
            object = new DataInputStream(this.execMethod((HttpMethod)method).getResponseBodyAsStream());
            this.activeMethods.remove(method);
        }
        catch (Exception e) {
            try {
                throw RemoteClient.serverException(e);
            }
            catch (Throwable throwable) {
                this.activeMethods.remove(method);
                throw throwable;
            }
        }
        return object;
    }

    @Override
    public List<ThinServiceInformation> getServiceInformation() throws SQLException {
        ArrayList services = Lists.newArrayList();
        try {
            String result = this.execService("/listServices");
            Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.createDocumentBuilder(), (String)result);
            Node servicesNode = XMLHandler.getSubNode((Node)doc, (String)"services");
            List serviceNodes = XMLHandler.getNodes((Node)servicesNode, (String)"service");
            for (Node serviceNode : serviceNodes) {
                String name = XMLHandler.getTagValue((Node)serviceNode, (String)"name");
                Node rowMetaNode = XMLHandler.getSubNode((Node)serviceNode, (String)"row-meta");
                RowMeta serviceFields = new RowMeta(rowMetaNode);
                ThinServiceInformation service = new ThinServiceInformation(name, (RowMetaInterface)serviceFields);
                services.add(service);
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return services;
    }

    @Override
    public ThinServiceInformation getServiceInformation(String name) throws SQLException {
        try {
            String result = this.execService("/listServices");
            Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.createDocumentBuilder(), (String)result);
            Node servicesNode = XMLHandler.getSubNode((Node)doc, (String)"services");
            List serviceNodes = XMLHandler.getNodes((Node)servicesNode, (String)"service");
            for (Node serviceNode : serviceNodes) {
                String serviceName = XMLHandler.getTagValue((Node)serviceNode, (String)"name");
                if (!serviceName.equals(name)) continue;
                Node rowMetaNode = XMLHandler.getSubNode((Node)serviceNode, (String)"row-meta");
                RowMeta serviceFields = new RowMeta(rowMetaNode);
                return new ThinServiceInformation(serviceName, (RowMetaInterface)serviceFields);
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return null;
    }

    @Override
    public List<String> getServiceNames(String serviceName) throws SQLException {
        return this.getServiceNames();
    }

    @Override
    public List<String> getServiceNames() throws SQLException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        try {
            String result = this.execService("/listServices");
            Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.createDocumentBuilder(), (String)result);
            Node servicesNode = XMLHandler.getSubNode((Node)doc, (String)"services");
            List serviceNodes = XMLHandler.getNodes((Node)servicesNode, (String)"service");
            for (Node serviceNode : serviceNodes) {
                String serviceName = XMLHandler.getTagValue((Node)serviceNode, (String)"name");
                serviceNames.add(serviceName);
            }
        }
        catch (Exception e) {
            throw RemoteClient.serverException(e);
        }
        return serviceNames;
    }

    @Override
    public void disconnect() {
        for (PostMethod method : this.activeMethods) {
            method.abort();
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return this.docBuilderFactory.newDocumentBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String execService(String serviceAndArguments) throws SQLException {
        String string;
        String urlString = this.connection.constructUrl(serviceAndArguments);
        GetMethod method = new GetMethod(urlString);
        try {
            string = this.execMethod((HttpMethod)method).getResponseBodyAsString();
        }
        catch (Throwable throwable) {
            try {
                method.releaseConnection();
                throw throwable;
            }
            catch (Exception e) {
                throw RemoteClient.serverException(e);
            }
        }
        method.releaseConnection();
        return string;
    }

    HttpMethod execMethod(HttpMethod method) throws SQLException {
        try {
            int result = this.client.executeMethod(method);
            if (result == 500) {
                throw new SQLException("There was an error reading data from the server.");
            }
            if (result == 401) {
                throw new SQLException("Nice try-but we couldn't log you in. Check your username and password and try again.");
            }
            if (result != 200) {
                throw new SQLException(method.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new SQLException("You don't seem to be getting a connection to the server or you have closed it. Check the host and port you're using and make sure the sever is up and running.");
        }
        return method;
    }

    private static SQLException serverException(Exception e) throws SQLException {
        Throwables.propagateIfPossible((Throwable)e, SQLException.class);
        throw new SQLException("Error connecting to server", e);
    }

    @Override
    @Deprecated
    public void setRepository(Repository repository) {
    }

    @Override
    @Deprecated
    public void setMetaStore(IMetaStore metaStore) {
    }
}

