/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import java.beans.IntrospectionException;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.LayoutPreprocessorPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LayoutPreprocessorReadHandler
extends AbstractXmlReadHandler {
    private BeanUtility beanUtility;
    private ReportPreProcessor preProcessor;

    protected void startParsing(Attributes attrs) throws SAXException {
        String preprocessorClass = attrs.getValue(this.getUri(), "class");
        if (preprocessorClass == null) {
            throw new ParseException("Required attribute 'class' is missing");
        }
        this.preProcessor = (ReportPreProcessor)ObjectUtilities.loadAndInstantiate((String)CompatibilityMapperUtil.mapClassName(preprocessorClass), LayoutPreprocessorReadHandler.class, ReportPreProcessor.class);
        if (this.preProcessor == null) {
            throw new ParseException("Failed to instantiate the specified preprocessor '" + preprocessorClass + '\'', this.getLocator());
        }
        try {
            this.beanUtility = new BeanUtility(this.preProcessor);
        }
        catch (IntrospectionException e) {
            throw new ParseException("Failed to introspect the specified preprocessor '" + preprocessorClass + '\'', this.getLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "property".equals(tagName)) {
            return new LayoutPreprocessorPropertyReadHandler(this.beanUtility);
        }
        return null;
    }

    public ReportPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public Object getObject() throws SAXException {
        return this.preProcessor;
    }
}

