/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SequenceRegistry {
    private static final String PREFIX = "org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.";
    private ArrayList<SequenceDescription> sequences = new ArrayList();

    public SequenceRegistry() {
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = config.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String clazz = config.getConfigProperty(key);
            SequenceDescription sequenceDescription = (SequenceDescription)ObjectUtilities.loadAndInstantiate((String)clazz, SequenceRegistry.class, SequenceDescription.class);
            if (sequenceDescription == null) continue;
            this.sequences.add(sequenceDescription);
        }
    }

    public String[] getSequenceGroups(Locale locale) {
        TreeSet<String> sequenceGroups = new TreeSet<String>();
        for (SequenceDescription sd : this.sequences) {
            sequenceGroups.add(sd.getSequenceGroup(locale));
        }
        return sequenceGroups.toArray(new String[sequenceGroups.size()]);
    }

    public SequenceDescription[] getSequences() {
        return this.sequences.toArray(new SequenceDescription[this.sequences.size()]);
    }

    public SequenceDescription[] getSequencesForGroup(String groupName, Locale locale) {
        ArrayList<SequenceDescription> sequenceGroups = new ArrayList<SequenceDescription>();
        for (SequenceDescription sd : this.sequences) {
            if (!ObjectUtilities.equal((Object)groupName, (Object)sd.getSequenceGroup(locale))) continue;
            sequenceGroups.add(sd);
        }
        return sequenceGroups.toArray(new SequenceDescription[sequenceGroups.size()]);
    }
}

