/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class RichTextSpec {
    private String text;
    private AttributedString attributedString;
    private List<StyledChunk> styleChunks;
    private TextDirection runDirection;

    public RichTextSpec(String text, TextDirection runDirection, List<StyledChunk> styleChunks) {
        ArgumentNullException.validate((String)"text", (Object)text);
        ArgumentNullException.validate((String)"styleChunks", styleChunks);
        ArgumentNullException.validate((String)"runDirection", (Object)runDirection);
        if (styleChunks.isEmpty()) {
            throw new IllegalStateException("Need at least one style chunk");
        }
        if (text.length() == 0) {
            throw new IllegalStateException("Text must not be empty.");
        }
        this.runDirection = runDirection;
        this.text = text;
        this.styleChunks = Collections.unmodifiableList(new ArrayList<StyledChunk>(styleChunks));
        this.attributedString = this.createText();
    }

    private AttributedString createText() {
        AttributedString str = new AttributedString(this.text);
        str.addAttribute(TextAttribute.RUN_DIRECTION, TextDirection.RTL.equals(this.runDirection));
        int startPosition = 0;
        for (StyledChunk chunk : this.styleChunks) {
            int length = chunk.getText().length();
            int endIndex = startPosition + length;
            str.addAttributes(chunk.getAttributes(), startPosition, endIndex);
            startPosition = endIndex;
        }
        return str;
    }

    public String getText() {
        return this.text;
    }

    public AttributedString getAttributedString() {
        return this.attributedString;
    }

    public AttributedCharacterIterator createAttributedCharacterIterator() {
        return this.attributedString.getIterator();
    }

    public List<StyledChunk> getStyleChunks() {
        return this.styleChunks;
    }

    public RichTextSpec substring(int start, int end) {
        ArrayList<StyledChunk> clippedChunks = new ArrayList<StyledChunk>();
        for (StyledChunk chunk : this.styleChunks) {
            int textEnd;
            int chunkEnd;
            int textStart;
            int chunkStart;
            if (chunk.end <= start || chunk.start >= end) continue;
            if (chunk.start < start) {
                chunkStart = 0;
                textStart = start;
            } else {
                chunkStart = chunk.start - start;
                textStart = chunk.start;
            }
            if (chunk.end < end) {
                chunkEnd = chunk.end - start;
                textEnd = chunk.end;
            } else {
                chunkEnd = end - start;
                textEnd = end;
            }
            String clippedText = this.text.substring(textStart, textEnd);
            clippedChunks.add(new StyledChunk(chunkStart, chunkEnd, chunk.originatingTextNode, chunk.attributes, chunk.originalAttributes, chunk.styleSheet, chunk.instanceID, clippedText));
        }
        return new RichTextSpec(this.text.substring(start, end), this.runDirection, clippedChunks);
    }

    public RenderableComplexText create(RenderBox lineBoxContainer) {
        AttributedCharacterIterator ci = this.createAttributedCharacterIterator();
        return this.create(lineBoxContainer, ci.getBeginIndex(), ci.getEndIndex());
    }

    public RenderableComplexText create(RenderBox lineBoxContainer, int start, int end) {
        return new RenderableComplexText(lineBoxContainer.getStyleSheet(), lineBoxContainer.getInstanceId(), lineBoxContainer.getElementType(), lineBoxContainer.getAttributes(), this.substring(start, end));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichTextSpec that = (RichTextSpec)o;
        if (!this.styleChunks.equals(that.styleChunks)) {
            return false;
        }
        return this.text.equals(that.text);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.styleChunks.hashCode();
        return result;
    }

    public int length() {
        return this.text.length();
    }

    public boolean isEmpty() {
        return this.styleChunks.isEmpty();
    }

    public static class StyledChunk {
        private int start;
        private int end;
        private RenderNode originatingTextNode;
        private String text;
        private Map<AttributedCharacterIterator.Attribute, Object> attributes;
        private ReportAttributeMap<Object> originalAttributes;
        private StyleSheet styleSheet;
        private InstanceID instanceID;

        public StyledChunk(int start, int end, RenderNode originatingTextNode, Map<AttributedCharacterIterator.Attribute, Object> attributes, ReportAttributeMap<Object> originalAttributes, StyleSheet styleSheet, InstanceID instanceID, String text) {
            ArgumentNullException.validate((String)"originatingTextNode", (Object)originatingTextNode);
            ArgumentNullException.validate((String)"attributes", attributes);
            ArgumentNullException.validate((String)"text", (Object)text);
            ArgumentNullException.validate((String)"originalAttributes", originalAttributes);
            ArgumentNullException.validate((String)"styleSheet", (Object)styleSheet);
            ArgumentNullException.validate((String)"instanceID", (Object)instanceID);
            this.instanceID = instanceID;
            this.start = start;
            this.end = end;
            this.originatingTextNode = originatingTextNode;
            this.attributes = Collections.unmodifiableMap(attributes);
            this.originalAttributes = originalAttributes;
            this.styleSheet = styleSheet;
            this.text = text;
        }

        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            return this.attributes;
        }

        public ReportAttributeMap<Object> getOriginalAttributes() {
            return this.originalAttributes;
        }

        public StyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        public String getText() {
            return this.text;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public RenderNode getOriginatingTextNode() {
            return this.originatingTextNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyledChunk that = (StyledChunk)o;
            if (this.instanceID != that.instanceID) {
                return false;
            }
            if (this.end != that.end) {
                return false;
            }
            if (this.start != that.start) {
                return false;
            }
            if (!this.attributes.equals(that.attributes)) {
                return false;
            }
            if (!this.originatingTextNode.equals(that.originatingTextNode)) {
                return false;
            }
            return this.text.equals(that.text);
        }

        public InstanceID getInstanceID() {
            return this.instanceID;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.end;
            result = 31 * result + this.instanceID.hashCode();
            result = 31 * result + this.originatingTextNode.hashCode();
            result = 31 * result + this.text.hashCode();
            result = 31 * result + this.attributes.hashCode();
            return result;
        }
    }
}

