/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.Image;
import java.awt.image.BufferedImage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ReplacedContentUtil;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class RichTextImageProducer {
    private static final Log logger = LogFactory.getLog(RichTextImageProducer.class);
    private OutputProcessorMetaData metaData;
    private ResourceManager resourceManager;

    public RichTextImageProducer(OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        this.metaData = metaData;
        this.resourceManager = resourceManager;
    }

    public Image createImagePlaceholder(RenderableReplacedContentBox content) {
        long bcw = ProcessUtility.computeBlockContextWidth(content);
        long width = ReplacedContentUtil.computeWidth(content);
        long height = ReplacedContentUtil.computeHeight(content, bcw, width);
        int w = (int)Math.max(1.0, StrictGeomUtility.toExternalValue(width));
        int h = (int)Math.max(1.0, StrictGeomUtility.toExternalValue(height));
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.DIRECT_RICHTEXT_RENDERING)) {
            Image img = this.processRenderableReplacedContent(content.getStyleSheet(), width, height, content.getContent().getRawObject());
            if (img != null) {
                return img;
            }
            return new BufferedImage(1, 1, 5).getScaledInstance(w, h, 2);
        }
        return new BufferedImage(1, 1, 5).getScaledInstance(w, h, 2);
    }

    private Image processRenderableReplacedContent(StyleSheet styleSheet, long width, long height, Object rawObject) {
        if (rawObject instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)rawObject;
            return li.getImage();
        }
        if (rawObject instanceof URLImageContainer) {
            URLImageContainer imageContainer = (URLImageContainer)rawObject;
            if (!imageContainer.isLoadable()) {
                logger.info((Object)"URL-image cannot be rendered, as it was declared to be not loadable.");
                return null;
            }
            ResourceKey sourceURL = imageContainer.getResourceKey();
            if (sourceURL == null) {
                logger.info((Object)"URL-image cannot be rendered, as it did not return a valid URL.");
            }
            try {
                Resource resource = this.resourceManager.create(sourceURL, null, Image.class);
                return (Image)resource.getResource();
            }
            catch (ResourceException e) {
                logger.info((Object)"URL-image cannot be rendered, as the image was not loadable.", (Throwable)e);
            }
        }
        if (rawObject instanceof DrawableWrapper) {
            DrawableWrapper drawable = (DrawableWrapper)rawObject;
            StrictBounds cb = new StrictBounds(0L, 0L, width, height);
            DefaultImageReference image = RenderUtility.createImageFromDrawable(drawable, cb, styleSheet, this.metaData);
            if (image == null) {
                return null;
            }
            return image.getImage();
        }
        return null;
    }
}

