/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output.crosstab;

import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.RelationalGroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.CrosstabOutputHelper;

public class CrosstabOtherOutputHandler
extends RelationalGroupOutputHandler {
    @Override
    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabOtherGroup group = (CrosstabOtherGroup)event.getReport().getGroup(gidx);
        GroupHeader b = group.getHeader();
        GroupBody groupBody = group.getBody();
        outputFunction.updateFooterArea(event);
        Renderer renderer = outputFunction.getRenderer();
        renderer.startGroup(group, event.getState().getPredictedStateCount());
        renderer.startSection(Renderer.SectionType.NORMALFLOW);
        renderer.add(b, outputFunction.getRuntime());
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.startGroupBody(groupBody, event.getState().getPredictedStateCount());
    }

    @Override
    public void groupBodyFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        CrosstabOutputHelper.closeCrosstabTable(outputFunction);
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.endGroupBody();
    }

    @Override
    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabOtherGroup g = (CrosstabOtherGroup)event.getReport().getGroup(gidx);
        GroupFooter b = g.getFooter();
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.startSection(Renderer.SectionType.NORMALFLOW);
        renderer.add(b, outputFunction.getRuntime());
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.endGroup();
    }

    @Override
    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a detail band. Never.");
    }

    @Override
    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a detail band. Never.");
    }

    @Override
    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a detail band. Never.");
    }

    @Override
    public void summaryRowStart(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a summary band. Never.");
    }

    @Override
    public void summaryRowEnd(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a summary band. Never.");
    }

    @Override
    public void summaryRow(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-other-group cannot contain a summary band. Never.");
    }
}

