/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.io.IOException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RewriteParseContextGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)RewriteParseContextGenerator.class.getName());

    public static Operator<? extends OperatorDesc> generateOperatorTree(QueryState queryState, String command) throws SemanticException {
        Operator<?> operatorTree;
        try {
            Context ctx = new Context(queryState.getConf());
            ParseDriver pd = new ParseDriver();
            ASTNode tree = pd.parse(command, ctx);
            tree = ParseUtils.findRootNonNullToken(tree);
            BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(queryState, tree);
            assert (sem instanceof SemanticAnalyzer);
            operatorTree = RewriteParseContextGenerator.doSemanticAnalysis((SemanticAnalyzer)sem, tree, ctx);
            LOG.info("Sub-query Semantic Analysis Completed");
        }
        catch (IOException e) {
            LOG.error("IOException in generating the operator tree for input command - " + command + " ", (Throwable)e);
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        catch (ParseException e) {
            LOG.error("ParseException in generating the operator tree for input command - " + command + " ", (Throwable)e);
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        catch (SemanticException e) {
            LOG.error("SemanticException in generating the operator tree for input command - " + command + " ", (Throwable)e);
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        return operatorTree;
    }

    private static Operator<?> doSemanticAnalysis(SemanticAnalyzer sem, ASTNode ast, Context ctx) throws SemanticException {
        QB qb = new QB(null, null, false);
        ASTNode child = ast;
        ParseContext subPCtx = sem.getParseContext();
        subPCtx.setContext(ctx);
        sem.initParseCtx(subPCtx);
        LOG.info("Starting Sub-query Semantic Analysis");
        sem.doPhase1(child, qb, sem.initPhase1Ctx(), null);
        LOG.info("Completed phase 1 of Sub-query Semantic Analysis");
        sem.getMetaData(qb);
        LOG.info("Completed getting MetaData in Sub-query Semantic Analysis");
        LOG.info("Sub-query Abstract syntax tree: " + ast.toStringTree());
        Operator operator = sem.genPlan(qb);
        LOG.info("Sub-query Completed plan generation");
        return operator;
    }
}

