/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.CorrelationReferenceFinder;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;

public class HiveRelFieldTrimmer
extends RelFieldTrimmer {
    protected static final Log LOG = LogFactory.getLog(HiveRelFieldTrimmer.class);
    private RelBuilder relBuilder;
    private ColumnAccessInfo columnAccessInfo;
    private Map<HiveProject, Table> viewProjectToTableSchema;

    public HiveRelFieldTrimmer(SqlValidator validator, RelBuilder relBuilder) {
        super(validator, relBuilder);
        this.relBuilder = relBuilder;
    }

    public HiveRelFieldTrimmer(SqlValidator validator, RelBuilder relBuilder, ColumnAccessInfo columnAccessInfo, Map<HiveProject, Table> viewToTableSchema) {
        super(validator, relBuilder);
        this.relBuilder = relBuilder;
        this.columnAccessInfo = columnAccessInfo;
        this.viewProjectToTableSchema = viewToTableSchema;
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveMultiJoin join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        List<RexNode> joinFilters = join.getJoinFilters();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept((RexVisitor)inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.inputBitSet.build();
        int inputStartPos = 0;
        int changeCount = 0;
        int newFieldCount = 0;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            Iterator i$ = fieldsUsedPlus.iterator();
            while (i$.hasNext()) {
                int bit = (Integer)i$.next();
                if (bit < inputStartPos || bit >= inputStartPos + inputFieldCount) continue;
                inputFieldsUsed.set(bit - inputStartPos);
            }
            Set inputExtraFields = Collections.emptySet();
            RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add((RelNode)trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            inputStartPos += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)newFieldCount);
        int offset = 0;
        int newOffset = 0;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount();
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new RelFieldTrimmer.TrimResult((RelNode)join, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, newInputs.toArray(new RelNode[newInputs.size()]));
        RexNode newConditionExpr = (RexNode)conditionExpr.accept((RexVisitor)shuttle);
        ArrayList<RexNode> newJoinFilters = Lists.newArrayList();
        for (RexNode joinFilter : joinFilters) {
            newJoinFilters.add((RexNode)joinFilter.accept((RexVisitor)shuttle));
        }
        RelDataType newRowType = RelOptUtil.permute((RelDataTypeFactory)join.getCluster().getTypeFactory(), (RelDataType)join.getRowType(), (Mapping)mapping);
        HiveMultiJoin newJoin = new HiveMultiJoin(join.getCluster(), newInputs, newConditionExpr, newRowType, join.getJoinInputs(), join.getJoinTypes(), newJoinFilters);
        return new RelFieldTrimmer.TrimResult((RelNode)newJoin, mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveSortLimit sort, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getInput();
        RelOptCluster cluster = sort.getCluster();
        ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder((ImmutableBitSet)fieldsUsed);
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set inputExtraFields = Collections.emptySet();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild(sort, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(sort, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        this.relBuilder.push(newInput);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue((RexNode)sort.offset);
        int fetch = sort.fetch == null ? -1 : RexLiteral.intValue((RexNode)sort.fetch);
        ImmutableList fields = this.relBuilder.fields(RexUtil.apply((Mappings.TargetMapping)inputMapping, (RelCollation)collation));
        this.sortLimit(cluster, this.relBuilder, offset, fetch, fields);
        return this.result(this.relBuilder.build(), inputMapping);
    }

    private List<RexNode> projects(RelDataType inputRowType, RelOptCluster cluster) {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (RelDataTypeField field : inputRowType.getFieldList()) {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            exprList.add((RexNode)rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return exprList;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, (RelFieldCollation.NullDirection)Util.first((Object)nullDirection, (Object)direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return HiveRelFieldTrimmer.collation((RexNode)((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return HiveRelFieldTrimmer.collation((RexNode)((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return HiveRelFieldTrimmer.collation((RexNode)((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, (RelFieldCollation.NullDirection)Util.first((Object)nullDirection, (Object)direction.defaultNullDirection()));
    }

    private void sortLimit(RelOptCluster cluster, RelBuilder relBuilder, int offset, int fetch, Iterable<? extends RexNode> nodes) {
        boolean addedFields;
        RexNode rexNode;
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        RelDataType inputRowType = relBuilder.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType, cluster);
        ImmutableList<RexNode> originalExtraNodes = ImmutableList.copyOf(extraNodes);
        for (RexNode rexNode2 : nodes) {
            fieldCollations.add(HiveRelFieldTrimmer.collation(rexNode2, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST, extraNodes));
        }
        RexNode offsetNode = offset <= 0 ? null : relBuilder.literal((Object)offset);
        RexNode rexNode3 = rexNode = fetch < 0 ? null : relBuilder.literal((Object)fetch);
        if (offsetNode == null && rexNode == null && fieldCollations.isEmpty()) {
            return;
        }
        boolean bl = addedFields = extraNodes.size() > originalExtraNodes.size();
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (!addedFields);
            RelNode top = relBuilder.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    relBuilder.build();
                    relBuilder.push(sort2.getInput());
                    HiveSortLimit sort = HiveSortLimit.create(relBuilder.build(), sort2.collation, offsetNode, rexNode);
                    relBuilder.push((RelNode)sort);
                    return;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    relBuilder.build();
                    relBuilder.push(sort2.getInput());
                    HiveSortLimit sort = HiveSortLimit.create(relBuilder.build(), sort2.collation, offsetNode, rexNode);
                    relBuilder.push((RelNode)sort);
                    relBuilder.project((Iterable)project.getProjects());
                    return;
                }
            }
        }
        if (addedFields) {
            relBuilder.project(extraNodes);
        }
        HiveSortLimit sort = HiveSortLimit.create(relBuilder.build(), RelCollations.of(fieldCollations), offsetNode, rexNode);
        relBuilder.push((RelNode)sort);
        if (addedFields) {
            relBuilder.project(originalExtraNodes);
        }
    }

    private RelFieldTrimmer.TrimResult result(RelNode r, final Mapping mapping) {
        final RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        for (final CorrelationId correlation : r.getVariablesSet()) {
            r = r.accept((RelShuttle)new CorrelationReferenceFinder(){

                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals((Object)correlation) && v.getType().getFieldCount() == mapping.getSourceCount()) {
                        int old = fieldAccess.getField().getIndex();
                        int new_ = mapping.getTarget(old);
                        RelDataTypeFactory.FieldInfoBuilder typeBuilder = HiveRelFieldTrimmer.this.relBuilder.getTypeFactory().builder();
                        Iterator i$ = Util.range((int)mapping.getTargetCount()).iterator();
                        while (i$.hasNext()) {
                            int target = (Integer)i$.next();
                            typeBuilder.add((RelDataTypeField)v.getType().getFieldList().get(mapping.getSource(target)));
                        }
                        RexNode newV = rexBuilder.makeCorrel(typeBuilder.build(), v.id);
                        if (old != new_) {
                            return rexBuilder.makeFieldAccess(newV, new_);
                        }
                    }
                    return fieldAccess;
                }
            });
        }
        return new RelFieldTrimmer.TrimResult(r, mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        for (Ord ord : Ord.zip((List)project.getProjects())) {
            if (!fieldsUsed.get(ord.i) || this.columnAccessInfo == null || this.viewProjectToTableSchema == null || !this.viewProjectToTableSchema.containsKey(project)) continue;
            Table tab = this.viewProjectToTableSchema.get(project);
            this.columnAccessInfo.add(tab.getCompleteName(), tab.getCols().get(ord.i).getName());
        }
        return super.trimFields(project, fieldsUsed, extraFields);
    }
}

