/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.InPlaceUpdates;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.fusesource.jansi.Ansi;

public class TezJobMonitor {
    private static final String CLASS_NAME = TezJobMonitor.class.getName();
    private static final int COLUMN_1_WIDTH = 16;
    private static final int SEPARATOR_WIDTH = 94;
    private static final int FILE_HEADER_SEPARATOR_WIDTH = 128;
    private static final String SEPARATOR = new String(new char[94]).replace("\u0000", "-");
    private static final String FILE_HEADER_SEPARATOR = new String(new char[128]).replace("\u0000", "-");
    private static final String QUERY_EXEC_SUMMARY_HEADER = "Query Execution Summary";
    private static final String TASK_SUMMARY_HEADER = "Task Execution Summary";
    private static final String LLAP_IO_SUMMARY_HEADER = "LLAP IO Summary";
    private static final String HEADER_FORMAT = "%16s%10s %13s  %5s  %9s  %7s  %7s  %6s  %6s  ";
    private static final String VERTEX_FORMAT = "%-16s%10s %13s  %5s  %9s  %7s  %7s  %6s  %6s  ";
    private static final String FOOTER_FORMAT = "%-15s  %-30s %-4s  %-25s";
    private static final String HEADER = String.format("%16s%10s %13s  %5s  %9s  %7s  %7s  %6s  %6s  ", "VERTICES", "MODE", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "FAILED", "KILLED");
    private static final String SUMMARY_HEADER_FORMAT = "%10s %14s %13s %12s %14s %15s";
    private static final String SUMMARY_HEADER = String.format("%10s %14s %13s %12s %14s %15s", "VERTICES", "DURATION(ms)", "CPU_TIME(ms)", "GC_TIME(ms)", "INPUT_RECORDS", "OUTPUT_RECORDS");
    private static final String FILE_HEADER_FORMAT = "%10s %12s %16s %13s %14s %13s %12s %14s %15s";
    private static final String FILE_HEADER = String.format("%10s %12s %16s %13s %14s %13s %12s %14s %15s", "VERTICES", "TOTAL_TASKS", "FAILED_ATTEMPTS", "KILLED_TASKS", "DURATION(ms)", "CPU_TIME(ms)", "GC_TIME(ms)", "INPUT_RECORDS", "OUTPUT_RECORDS");
    private static final String LLAP_SUMMARY_HEADER_FORMAT = "%10s %9s %9s %10s %9s %10s %11s %8s %9s";
    private static final String LLAP_SUMMARY_HEADER = String.format("%10s %9s %9s %10s %9s %10s %11s %8s %9s", "VERTICES", "ROWGROUPS", "META_HIT", "META_MISS", "DATA_HIT", "DATA_MISS", "ALLOCATION", "USED", "TOTAL_IO");
    private static final String OPERATION_SUMMARY = "%-35s %9s";
    private static final String OPERATION = "OPERATION";
    private static final String DURATION = "DURATION";
    private int lines;
    private final PrintStream out;
    private transient SessionState.LogHelper console;
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private final int checkInterval = 200;
    private final int maxRetryInterval = 2500;
    private final int printInterval = 3000;
    private final int progressBarChars = 30;
    private long lastPrintTime;
    private Set<String> completed;
    private final NumberFormat secondsFormat;
    private final NumberFormat commaFormat;
    private static final List<DAGClient> shutdownList = new LinkedList<DAGClient>();
    private final Map<String, BaseWork> workMap;
    private StringBuffer diagnostics;

    public static void initShutdownHook() {
        Preconditions.checkNotNull(shutdownList, "Shutdown hook was not properly initialized");
    }

    public TezJobMonitor(Map<String, BaseWork> workMap) {
        this.workMap = workMap;
        this.console = SessionState.getConsole();
        this.secondsFormat = new DecimalFormat("#0.00");
        this.commaFormat = NumberFormat.getNumberInstance(Locale.US);
        TezJobMonitor tezJobMonitor = this;
        this.out = tezJobMonitor.console.getInfoStream();
    }

    public void reprintLine(String line) {
        InPlaceUpdates.reprintLine(this.out, line);
        ++this.lines;
    }

    public void reprintLineWithColorAsBold(String line, Ansi.Color color) {
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).fg(color).bold().a(line).a('\n').boldOff().reset().toString());
        this.out.flush();
        ++this.lines;
    }

    public void reprintMultiLine(String line) {
        int numLines = line.split("\r\n|\r|\n").length;
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        this.out.flush();
        this.lines += numLines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            this.out.print(Ansi.ansi().cursorUp(this.lines).toString());
            this.out.flush();
            this.lines = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int monitorExecution(DAGClient dagClient, HiveConf conf, DAG dag, Context ctx) throws InterruptedException {
        monitorStartTime = System.currentTimeMillis();
        status = null;
        this.completed = new HashSet<String>();
        this.diagnostics = new StringBuffer();
        running = false;
        done = false;
        success = false;
        failedCounter = 0;
        rc = 0;
        lastState = null;
        lastReport = null;
        opts = new HashSet<E>();
        startTime = 0L;
        isProfileEnabled = HiveConf.getBoolVar(conf, HiveConf.ConfVars.TEZ_EXEC_SUMMARY) != false || Utilities.isPerfOrAboveLogging(conf) != false;
        llapIoEnabled = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_ENABLED, false);
        inPlaceEligible = InPlaceUpdates.inPlaceEligible(conf);
        var21_19 = TezJobMonitor.shutdownList;
        synchronized (var21_19) {
            TezJobMonitor.shutdownList.add(dagClient);
        }
        this.console.printInfo("\n");
        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezRunDag");
        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezSubmitToRunningDag");
        progressMap = null;
        block28: while (true) lbl-1000:
        // 11 sources

        {
            try {
                if (ctx != null) {
                    ctx.checkHeartbeaterLockException();
                }
                status = dagClient.getDAGStatus(opts, 200L);
                progressMap = status.getVertexProgress();
                state = status.getState();
                if (state == lastState && state != DAGStatus.State.RUNNING) continue;
                lastState = state;
                switch (2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[state.ordinal()]) {
                    case 1: {
                        this.console.printInfo("Status: Submitted");
                        ** break;
                    }
                    case 2: {
                        this.console.printInfo("Status: Initializing");
                        startTime = System.currentTimeMillis();
                        ** break;
                    }
                    case 3: {
                        if (!running) {
                            this.perfLogger.PerfLogEnd(TezJobMonitor.CLASS_NAME, "TezSubmitToRunningDag");
                            this.console.printInfo("Status: Running (" + dagClient.getExecutionContext() + ")\n");
                            startTime = System.currentTimeMillis();
                            running = true;
                        }
                        if (inPlaceEligible) {
                            this.printStatusInPlace(progressMap, startTime, false, dagClient);
                            lastReport = this.logStatus(progressMap, lastReport, this.console);
                            ** break;
                        }
                        lastReport = this.printStatus(progressMap, lastReport, this.console);
                        ** break;
                    }
                    case 4: {
                        if (!running) {
                            startTime = monitorStartTime;
                        }
                        if (inPlaceEligible) {
                            this.printStatusInPlace(progressMap, startTime, false, dagClient);
                            lastReport = this.logStatus(progressMap, lastReport, this.console);
                        } else {
                            lastReport = this.printStatus(progressMap, lastReport, this.console);
                        }
                        success = true;
                        running = false;
                        done = true;
                        ** break;
                    }
                    case 5: {
                        if (!running) {
                            startTime = monitorStartTime;
                        }
                        if (inPlaceEligible) {
                            this.printStatusInPlace(progressMap, startTime, true, dagClient);
                            lastReport = this.logStatus(progressMap, lastReport, this.console);
                        }
                        this.console.printInfo("Status: Killed");
                        running = false;
                        done = true;
                        rc = 1;
                        ** break;
                    }
                    case 6: 
                    case 7: {
                        if (!running) {
                            startTime = monitorStartTime;
                        }
                        if (inPlaceEligible) {
                            this.printStatusInPlace(progressMap, startTime, true, dagClient);
                            lastReport = this.logStatus(progressMap, lastReport, this.console);
                        }
                        this.console.printError("Status: Failed");
                        running = false;
                        done = true;
                        rc = 2;
                        continue block28;
                    }
                    ** default:
lbl94:
                    // 1 sources

                    continue block28;
                }
            }
            catch (Exception e) {
                this.console.printInfo("Exception: " + e.getMessage());
                isInterrupted = TezJobMonitor.hasInterruptedException(e);
                if (isInterrupted || ++failedCounter % 2500 / 200 == 0) {
                    try {
                        this.console.printInfo("Killing DAG...");
                        dagClient.tryKillDAG();
                    }
                    catch (IOException io) {
                    }
                    catch (TezException te) {
                        // empty catch block
                    }
                    e.printStackTrace();
                    this.console.printError("Execution has failed.");
                    rc = 1;
                    done = true;
                }
                this.console.printInfo("Retrying...");
            }
            finally {
                if (done) ** break;
                continue;
                if (rc != 0 && status != null) {
                    for (String diag : status.getDiagnostics()) {
                        this.console.printError(diag);
                        this.diagnostics.append(diag);
                    }
                }
                var22_23 = TezJobMonitor.shutdownList;
                synchronized (var22_23) {
                    TezJobMonitor.shutdownList.remove(dagClient);
                }
            }
            break;
        }
        this.perfLogger.PerfLogEnd(TezJobMonitor.CLASS_NAME, "TezRunDag");
        if (isProfileEnabled && success && progressMap != null) {
            duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            this.console.printInfo("Status: DAG finished successfully in " + String.format("%.2f seconds", new Object[]{duration}));
            this.console.printInfo("");
            this.console.printInfo("Query Execution Summary");
            this.printQueryExecutionBreakDown();
            this.console.printInfo(TezJobMonitor.SEPARATOR);
            this.console.printInfo("");
            this.console.printInfo("Task Execution Summary");
            this.printDagSummary(progressMap, this.console, dagClient, conf, dag, inPlaceEligible);
            if (inPlaceEligible) {
                this.console.printInfo(TezJobMonitor.SEPARATOR);
            } else {
                this.console.printInfo(TezJobMonitor.FILE_HEADER_SEPARATOR);
            }
            if (llapIoEnabled) {
                this.console.printInfo("");
                this.console.printInfo("LLAP IO Summary");
                this.printLlapIOSummary(progressMap, this.console, dagClient);
                this.console.printInfo(TezJobMonitor.SEPARATOR);
            }
            this.console.printInfo("");
        }
        return rc;
    }

    private static boolean hasInterruptedException(Throwable e) {
        while (e != null) {
            if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        List<DAGClient> list = shutdownList;
        synchronized (list) {
            for (DAGClient c : shutdownList) {
                try {
                    System.err.println("Trying to shutdown DAG");
                    c.tryKillDAG();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static long getCounterValueByGroupName(TezCounters vertexCounters, String groupNamePattern, String counterName) {
        TezCounter tezCounter = ((CounterGroup)vertexCounters.getGroup(groupNamePattern)).findCounter(counterName);
        return tezCounter == null ? 0L : tezCounter.getValue();
    }

    private void printQueryExecutionBreakDown() {
        String execBreakdownHeader = String.format(OPERATION_SUMMARY, OPERATION, DURATION);
        this.console.printInfo(SEPARATOR);
        this.reprintLineWithColorAsBold(execBreakdownHeader, Ansi.Color.CYAN);
        this.console.printInfo(SEPARATOR);
        long compile = this.perfLogger.getEndTime("compile") - this.perfLogger.getStartTime("Driver.run");
        this.console.printInfo(String.format(OPERATION_SUMMARY, "Compile Query", this.secondsFormat.format((double)compile / 1000.0) + "s"));
        long totalDAGPrep = this.perfLogger.getStartTime("TezSubmitDag") - this.perfLogger.getEndTime("compile");
        this.console.printInfo(String.format(OPERATION_SUMMARY, "Prepare Plan", this.secondsFormat.format((double)totalDAGPrep / 1000.0) + "s"));
        long submitToAccept = this.perfLogger.getStartTime("TezRunDag") - this.perfLogger.getStartTime("TezSubmitDag");
        this.console.printInfo(String.format(OPERATION_SUMMARY, "Submit Plan", this.secondsFormat.format((double)submitToAccept / 1000.0) + "s"));
        long acceptToStart = this.perfLogger.getDuration("TezSubmitToRunningDag");
        this.console.printInfo(String.format(OPERATION_SUMMARY, "Start DAG", this.secondsFormat.format((double)acceptToStart / 1000.0) + "s"));
        long startToEnd = acceptToStart == 0L ? this.perfLogger.getDuration("TezRunDag") : this.perfLogger.getEndTime("TezRunDag") - this.perfLogger.getEndTime("TezSubmitToRunningDag");
        this.console.printInfo(String.format(OPERATION_SUMMARY, "Run DAG", this.secondsFormat.format((double)startToEnd / 1000.0) + "s"));
    }

    private void printDagSummary(Map<String, Progress> progressMap, SessionState.LogHelper console, DAGClient dagClient, HiveConf conf, DAG dag, boolean inPlaceEligible) {
        String hiveCountersGroup = HiveConf.getVar(conf, HiveConf.ConfVars.HIVECOUNTERGROUP);
        EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        TezCounters hiveCounters = null;
        try {
            hiveCounters = dagClient.getDAGStatus(statusGetOpts).getDAGCounters();
        }
        catch (IOException e) {
        }
        catch (TezException e) {
            // empty catch block
        }
        if (hiveCounters == null) {
            return;
        }
        if (inPlaceEligible) {
            console.printInfo(SEPARATOR);
            this.reprintLineWithColorAsBold(SUMMARY_HEADER, Ansi.Color.CYAN);
            console.printInfo(SEPARATOR);
        } else {
            console.printInfo(FILE_HEADER_SEPARATOR);
            this.reprintLineWithColorAsBold(FILE_HEADER, Ansi.Color.CYAN);
            console.printInfo(FILE_HEADER_SEPARATOR);
        }
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        for (String vertexName : keys) {
            Progress progress = progressMap.get(vertexName);
            if (progress == null) continue;
            int totalTasks = progress.getTotalTaskCount();
            int failedTaskAttempts = progress.getFailedTaskAttemptCount();
            int killedTaskAttempts = progress.getKilledTaskAttemptCount();
            double duration = this.perfLogger.getDuration("TezRunVertex." + vertexName).longValue();
            VertexStatus vertexStatus = null;
            try {
                vertexStatus = dagClient.getVertexStatus(vertexName, statusOptions);
            }
            catch (IOException e) {
            }
            catch (TezException e) {
                // empty catch block
            }
            if (vertexStatus == null) continue;
            Vertex currentVertex = dag.getVertex(vertexName);
            List inputVerticesList = currentVertex.getInputVertices();
            long hiveInputRecordsFromOtherVertices = 0L;
            if (inputVerticesList.size() > 0) {
                for (Vertex inputVertex : inputVerticesList) {
                    String inputVertexName = inputVertex.getName();
                    hiveInputRecordsFromOtherVertices += TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString()) + inputVertexName.replace(" ", "_"));
                    hiveInputRecordsFromOtherVertices += TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", FileSinkOperator.Counter.RECORDS_OUT.toString()) + inputVertexName.replace(" ", "_"));
                }
            }
            TezCounters vertexCounters = vertexStatus.getVertexCounters();
            double cpuTimeMillis = TezJobMonitor.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.CPU_MILLISECONDS.name());
            double gcTimeMillis = TezJobMonitor.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.GC_TIME_MILLIS.name());
            long hiveInputRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", AbstractMapOperator.Counter.RECORDS_IN.toString()) + vertexName.replace(" ", "_")) + hiveInputRecordsFromOtherVertices;
            long hiveOutputIntermediateRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString()) + vertexName.replace(" ", "_"));
            long hiveOutputRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", FileSinkOperator.Counter.RECORDS_OUT.toString()) + vertexName.replace(" ", "_")) + hiveOutputIntermediateRecords;
            String vertexExecutionStats = inPlaceEligible ? String.format(SUMMARY_HEADER_FORMAT, vertexName, this.secondsFormat.format(duration), this.commaFormat.format(cpuTimeMillis), this.commaFormat.format(gcTimeMillis), this.commaFormat.format(hiveInputRecords), this.commaFormat.format(hiveOutputRecords)) : String.format(FILE_HEADER_FORMAT, vertexName, totalTasks, failedTaskAttempts, killedTaskAttempts, this.secondsFormat.format(duration), this.commaFormat.format(cpuTimeMillis), this.commaFormat.format(gcTimeMillis), this.commaFormat.format(hiveInputRecords), this.commaFormat.format(hiveOutputRecords));
            console.printInfo(vertexExecutionStats);
        }
    }

    private String humanReadableByteCount(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String suffix = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.2f%sB", (double)bytes / Math.pow(unit, exp), suffix);
    }

    private void printLlapIOSummary(Map<String, Progress> progressMap, SessionState.LogHelper console, DAGClient dagClient) {
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        boolean first = false;
        String counterGroup = LlapIOCounters.class.getName();
        for (String vertexName : keys) {
            if (vertexName.startsWith("Reducer")) continue;
            TezCounters vertexCounters = null;
            try {
                vertexCounters = dagClient.getVertexStatus(vertexName, statusOptions).getVertexCounters();
            }
            catch (IOException e) {
            }
            catch (TezException e) {
                // empty catch block
            }
            if (vertexCounters == null) continue;
            long selectedRowgroups = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.SELECTED_ROWGROUPS.name());
            long metadataCacheHit = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.METADATA_CACHE_HIT.name());
            long metadataCacheMiss = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.METADATA_CACHE_MISS.name());
            long cacheHitBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.CACHE_HIT_BYTES.name());
            long cacheMissBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.CACHE_MISS_BYTES.name());
            long allocatedBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.ALLOCATED_BYTES.name());
            long allocatedUsedBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.ALLOCATED_USED_BYTES.name());
            long totalIoTime = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.TOTAL_IO_TIME_NS.name());
            if (!first) {
                console.printInfo(SEPARATOR);
                this.reprintLineWithColorAsBold(LLAP_SUMMARY_HEADER, Ansi.Color.CYAN);
                console.printInfo(SEPARATOR);
                first = true;
            }
            String queryFragmentStats = String.format(LLAP_SUMMARY_HEADER_FORMAT, vertexName, selectedRowgroups, metadataCacheHit, metadataCacheMiss, this.humanReadableByteCount(cacheHitBytes), this.humanReadableByteCount(cacheMissBytes), this.humanReadableByteCount(allocatedBytes), this.humanReadableByteCount(allocatedUsedBytes), this.secondsFormat.format((double)totalIoTime / 1.0E9) + "s");
            console.printInfo(queryFragmentStats);
        }
    }

    private void printStatusInPlace(Map<String, Progress> progressMap, long startTime, boolean vextexStatusFromAM, DAGClient dagClient) {
        StringBuilder reportBuffer = new StringBuilder();
        int sumComplete = 0;
        int sumTotal = 0;
        this.repositionCursor();
        this.reprintLine(SEPARATOR);
        this.reprintLineWithColorAsBold(HEADER, Ansi.Color.CYAN);
        this.reprintLine(SEPARATOR);
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        int idx = 0;
        int maxKeys = keys.size();
        for (String s : keys) {
            ++idx;
            Progress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskAttemptCount();
            int pending = progress.getTotalTaskCount() - progress.getSucceededTaskCount() - progress.getRunningTaskCount();
            int killed = progress.getKilledTaskAttemptCount();
            VertexStatus.State vertexState = VertexStatus.State.INITIALIZING;
            if (total > 0) {
                vertexState = VertexStatus.State.INITED;
                sumComplete += complete;
                sumTotal += total;
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                vertexState = VertexStatus.State.RUNNING;
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
            }
            if (complete == total) {
                vertexState = VertexStatus.State.SUCCEEDED;
                if (!this.completed.contains(s)) {
                    this.completed.add(s);
                    if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                    }
                    this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunVertex." + s);
                }
            }
            if (vextexStatusFromAM) {
                VertexStatus vertexStatus = null;
                try {
                    vertexStatus = dagClient.getVertexStatus(s, null);
                }
                catch (IOException e) {
                }
                catch (TezException e) {
                    // empty catch block
                }
                if (vertexStatus != null) {
                    vertexState = vertexStatus.getState();
                }
            }
            String nameWithProgress = this.getNameWithProgress(s, complete, total);
            String mode = this.getMode(s, this.workMap);
            String vertexStr = String.format(VERTEX_FORMAT, nameWithProgress, mode, vertexState.toString(), total, complete, running, pending, failed, killed);
            reportBuffer.append(vertexStr);
            if (idx == maxKeys) continue;
            reportBuffer.append("\n");
        }
        this.reprintMultiLine(reportBuffer.toString());
        this.reprintLine(SEPARATOR);
        float progress = sumTotal == 0 ? 0.0f : (float)sumComplete / (float)sumTotal;
        String footer = this.getFooter(keys.size(), this.completed.size(), progress, startTime);
        this.reprintLineWithColorAsBold(footer, Ansi.Color.RED);
        this.reprintLine(SEPARATOR);
    }

    private String getMode(String name, Map<String, BaseWork> workMap) {
        String mode = "container";
        BaseWork work = workMap.get(name);
        if (work != null) {
            mode = work.getUberMode() ? "uber" : (work.getLlapMode() ? "llap" : "container");
        }
        return mode;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        String result = "";
        if (s != null) {
            float percent = total == 0 ? 0.0f : (float)complete / (float)total;
            int spaceRemaining = 16 - s.length() - 1;
            String trimmedVName = s;
            if (s.length() > 16) {
                trimmedVName = s.substring(0, 15);
                trimmedVName = trimmedVName + "..";
            }
            result = trimmedVName + " ";
            int toFill = (int)((float)spaceRemaining * percent);
            for (int i = 0; i < toFill; ++i) {
                result = result + ".";
            }
        }
        return result;
    }

    private String getFooter(int keySize, int completedSize, float progress, long startTime) {
        String verticesSummary = String.format("VERTICES: %02d/%02d", completedSize, keySize);
        String progressBar = this.getInPlaceProgressBar(progress);
        int progressPercent = (int)(progress * 100.0f);
        String progressStr = "" + progressPercent + "%";
        float et = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        String elapsedTime = "ELAPSED TIME: " + this.secondsFormat.format(et) + " s";
        String footer = String.format(FOOTER_FORMAT, verticesSummary, progressBar, progressStr, elapsedTime);
        return footer;
    }

    private String getInPlaceProgressBar(float percent) {
        int i;
        StringBuilder bar = new StringBuilder("[");
        int remainingChars = 26;
        int completed = (int)((float)remainingChars * percent);
        int pending = remainingChars - completed;
        for (i = 0; i < completed; ++i) {
            bar.append("=");
        }
        bar.append(">>");
        for (i = 0; i < pending; ++i) {
            bar.append("-");
        }
        bar.append("]");
        return bar.toString();
    }

    private String printStatus(Map<String, Progress> progressMap, String lastReport, SessionState.LogHelper console) {
        String report = this.getReport(progressMap);
        if (!report.equals(lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L) {
            console.printInfo(report);
            this.lastPrintTime = System.currentTimeMillis();
        }
        return report;
    }

    private String logStatus(Map<String, Progress> progressMap, String lastReport, SessionState.LogHelper console) {
        String report = this.getReport(progressMap);
        if (!report.equals(lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L) {
            console.logInfo(report);
            this.lastPrintTime = System.currentTimeMillis();
        }
        return report;
    }

    private String getReport(Map<String, Progress> progressMap) {
        StringBuilder reportBuffer = new StringBuilder();
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        for (String s : keys) {
            Progress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskAttemptCount();
            if (total <= 0) {
                reportBuffer.append(String.format("%s: -/-\t", s));
                continue;
            }
            if (complete == total && !this.completed.contains(s)) {
                this.completed.add(s);
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
                this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunVertex." + s);
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", s, complete, running, failed, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d(+%d)/%d\t", s, complete, running, total));
                continue;
            }
            if (failed > 0) {
                reportBuffer.append(String.format("%s: %d(-%d)/%d\t", s, complete, failed, total));
                continue;
            }
            reportBuffer.append(String.format("%s: %d/%d\t", s, complete, total));
        }
        return reportBuffer.toString();
    }

    public String getDiagnostics() {
        return this.diagnostics.toString();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TezJobMonitor.killRunningJobs();
                try {
                    TezSessionPoolManager.getInstance().closeNonDefaultSessions(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State;

        static {
            $SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State = new int[DAGStatus.State.values().length];
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.SUBMITTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.INITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.SUCCEEDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.KILLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[DAGStatus.State.ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

