/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsGetForRecoveryJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private long checkAgeSecs = 0L;

    public CoordActionsGetForRecoveryJPAExecutor(long checkAgeSecs) {
        ParamChecker.notNull(checkAgeSecs, "checkAgeSecs");
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public String getName() {
        return "CoordActionsGetForRecoveryJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorActionBean> allActions = new ArrayList<CoordinatorActionBean>();
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN");
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            q.setParameter("lastModifiedTime", (Object)ts);
            List actions = q.getResultList();
            for (CoordinatorActionBean action : actions) {
                allActions.add(action);
            }
            q = em.createNamedQuery("GET_COORD_ACTIONS_WAITING_SUBMITTED_OLDER_THAN");
            q.setParameter("lastModifiedTime", (Object)ts);
            actions = q.getResultList();
            for (CoordinatorActionBean action : actions) {
                allActions.add(action);
            }
            return allActions;
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
    }
}

