/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginUtil;
import org.pentaho.platform.web.servlet.AbstractGwtRpcProxyServlet;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GwtRpcPluginProxyServlet
extends AbstractGwtRpcProxyServlet {
    private static final Log logger = LogFactory.getLog(GwtRpcPluginProxyServlet.class);
    private static final Pattern pentahoBasePattern = Pattern.compile("^/.*/WEBAPP_ROOT/");

    @Override
    protected Object resolveDispatchTarget(String servletContextPath) {
        String key;
        IServiceManager serviceManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        if (null == serviceManager.getServiceConfig("gwt", key = this.getDispatchKey())) {
            String errMsg = Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0001_SERVICE_NOT_FOUND", new Object[]{key});
            logger.error((Object)errMsg);
            throw new GwtRpcProxyException(errMsg);
        }
        Object targetBean = null;
        try {
            targetBean = serviceManager.getServiceBean("gwt", key);
        }
        catch (ServiceException e) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0002_FAILED_TO_GET_BEAN_REFERENCE", new Object[]{key}), e);
        }
        return targetBean;
    }

    protected URL getSerializationPolicyUrl(String serializationPolicyFilename, String appContextPath, String servletContextPath) {
        IPluginResourceLoader resLoader;
        List urls;
        ClassLoader serviceClassloader = PluginUtil.getClassLoaderForService(servletContextPath);
        if (serviceClassloader == null) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0005_FAILED_TO_FIND_PLUGIN", new Object[]{appContextPath}));
        }
        if ((urls = (resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, (IPentahoSession)PentahoSessionHolder.getSession())).findResources(serviceClassloader, serializationPolicyFilename)).size() < 1) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0006_FAILED_TO_FIND_FILE", new Object[]{serializationPolicyFilename}));
            return null;
        }
        if (urls.size() > 1) {
            logger.warn((Object)Messages.getInstance().getString("GwtRpcPluginProxyServlet.WARN_MULTIPLE_RESOURCES_FOUND", new Object[]{serializationPolicyFilename}));
        }
        return (URL)urls.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = null;
        String appContextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0004_MALFORMED_URL", new Object[]{moduleBaseURL}), (Throwable)ex);
                return null;
            }
        }
        if (modulePath.contains("WEBAPP_ROOT")) {
            modulePath = this.scrubWebAppRoot(modulePath);
        }
        String servletContextPath = modulePath.substring(appContextPath.length());
        String pluginId = PluginUtil.getPluginIdFromPath(servletContextPath);
        serializationPolicy = (SerializationPolicy)PentahoSystem.get(SerializationPolicy.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap("plugin", pluginId));
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        String serializationPolicyFilename = SerializationPolicyLoader.getSerializationPolicyFileName((String)strongName);
        URL serializationPolicyUrl = this.getSerializationPolicyUrl(serializationPolicyFilename, appContextPath, servletContextPath);
        if (serializationPolicyUrl == null) {
            return null;
        }
        InputStream rpcFileInputStream = null;
        try {
            rpcFileInputStream = serializationPolicyUrl.openStream();
            if (rpcFileInputStream != null) {
                serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)rpcFileInputStream, null);
            }
        }
        catch (IOException e) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0007_FAILED_TO_OPEN_FILE", new Object[]{serializationPolicyFilename}), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0008_FAILED_TO_PARSE_FILE", new Object[]{serializationPolicyFilename}), (Throwable)e);
        }
        finally {
            if (rpcFileInputStream != null) {
                try {
                    rpcFileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return serializationPolicy;
    }

    protected String scrubWebAppRoot(String modulePath) {
        Matcher matcher = pentahoBasePattern.matcher(modulePath);
        if (matcher.find()) {
            String garbagePathPart = matcher.group();
            int idx = modulePath.indexOf(garbagePathPart);
            String contextPath = PentahoRequestContextHolder.getRequestContext().getContextPath();
            String rewrittenModulePath = new StringBuffer(modulePath).replace(idx, idx + garbagePathPart.length(), contextPath).toString();
            return rewrittenModulePath;
        }
        return modulePath;
    }
}

