/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.context;

import java.util.List;
import javax.jcr.Repository;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPlatformReadyListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;

public class PentahoSystemReadyListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        IPentahoSession session = PentahoSessionHolder.getSession();
        IPluginProvider pluginProvider = (IPluginProvider)PentahoSystem.get(IPluginProvider.class, (String)"IPluginProvider", (IPentahoSession)session);
        try {
            List providedPlugins = pluginProvider.getPlugins(session);
            for (IPlatformPlugin plugin : providedPlugins) {
                try {
                    ClassLoader loader;
                    Object listener;
                    if (StringUtils.isEmpty((String)plugin.getLifecycleListenerClassname()) || !IPlatformReadyListener.class.isAssignableFrom((listener = (loader = pluginManager.getClassLoader(plugin.getId())).loadClass(plugin.getLifecycleListenerClassname()).newInstance()).getClass())) continue;
                    ((IPlatformReadyListener)listener).ready();
                }
                catch (Exception e) {
                    Logger.warn((String)PentahoSystemReadyListener.class.getName(), (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (PlatformPluginRegistrationException e) {
            Logger.warn((String)PentahoSystemReadyListener.class.getName(), (String)e.getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Repository jcrRepository = (Repository)PentahoSystem.get(Repository.class, (String)"jcrRepository", null);
        if (jcrRepository == null) {
            Logger.error((String)PentahoSystemReadyListener.class.getName(), (String)"Cannot obtain JCR repository. Exiting");
            return;
        }
        if (!(jcrRepository instanceof JackrabbitRepository)) {
            Logger.error((String)PentahoSystemReadyListener.class.getName(), (String)String.format("Expected RepositoryImpl, but got: [%s]. Exiting", jcrRepository.getClass().getName()));
            return;
        }
        ((JackrabbitRepository)jcrRepository).shutdown();
    }
}

