/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class TestComponent
extends ComponentBase {
    private static final long serialVersionUID = -5888733281367666385L;

    public Log getLogger() {
        return LogFactory.getLog(TestComponent.class);
    }

    private void message(String message) {
        this.info(message);
        System.out.println(message);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        IActionParameter actionParameter;
        Set inputNames = this.getInputNames();
        for (String inputName : inputNames) {
            actionParameter = this.getInputParameter(inputName);
            this.message(Messages.getInstance().getString("TestComponent.DEBUG_INPUT_DESCRIPTION", new Object[]{inputName, actionParameter.getType()}));
        }
        Set outputNames = this.getOutputNames();
        for (String outputName : outputNames) {
            actionParameter = this.getOutputItem(outputName);
            this.message(Messages.getInstance().getString("TestComponent.DEBUG_OUTPUT_DESCRIPTION", new Object[]{outputName, actionParameter.getType()}));
        }
        Set resourceNames = this.getResourceNames();
        for (String resourceName : resourceNames) {
            IActionSequenceResource actionResource = this.getResource(resourceName);
            this.message(Messages.getInstance().getString("TestComponent.DEBUG_RESOURCE_DESCRIPTION", new Object[]{resourceName, actionResource.getMimeType(), actionResource.getAddress()}));
            try {
                String content = this.getResourceAsString(actionResource);
                this.message(Messages.getInstance().getString("TestComponent.DEBUG_RESOURCE_CONTENTS", new Object[]{content == null ? "null" : content.substring(0, 100)}));
            }
            catch (Exception e) {
                this.message(Messages.getInstance().getString("TestComponent.ERROR_0005_RESOURCE_NOT_LOADED", new Object[]{e.getMessage()}));
            }
        }
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() {
        this.message(Messages.getInstance().getString("TestComponent.DEBUG_EXECUTING_TEST"));
        Node componentNode = this.getComponentDefinition();
        Set inputNames = this.getInputNames();
        for (String inputName : inputNames) {
            IActionParameter actionParameter = this.getInputParameter(inputName);
            this.message(Messages.getInstance().getString("TestComponent.DEBUG_INPUT_DESCRIPTION", new Object[]{inputName, actionParameter.getValue().getClass().toString() + "=" + actionParameter.getValue().toString()}));
        }
        String test = XmlDom4JHelper.getNodeText((String)"test", (Node)componentNode);
        if (test == null || test.length() < 1) {
            this.message(componentNode.asXML());
            return true;
        }
        String newName = XmlDom4JHelper.getNodeText((String)"newname", (Node)componentNode);
        Object theResult = null;
        if ("format".equals(test)) {
            MessageFormat mf = new MessageFormat(XmlDom4JHelper.getNodeText((String)"p1", (Node)componentNode, (String)""));
            Object[] obj = new Object[]{this.getParamFromComponentNode("p2", componentNode), this.getParamFromComponentNode("p3", componentNode)};
            theResult = mf.format(obj);
        } else {
            Object p1 = this.getParamFromComponentNode("p1", componentNode);
            if (p1 == null) {
                return false;
            }
            if ("toupper".equals(test)) {
                theResult = p1.toString().toUpperCase();
            } else if ("rename".equals(test)) {
                theResult = p1;
            } else if ("map2params".equals(test)) {
                if (!(p1 instanceof Map)) {
                    this.error(Messages.getInstance().getErrorString("TestComponent.ERROR_0003_PARAMETER_NOT_MAP", new Object[]{"p1"}));
                    return false;
                }
                Map srcMap = (Map)p1;
                Iterator it = srcMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    this.setOutputValue(key, srcMap.get(key));
                }
            } else if ("print".equals(test)) {
                String delim = "\r\n***************************************************************\r\n";
                theResult = delim + p1.toString() + delim;
            } else if ("getkeys".equals(test)) {
                if (!(p1 instanceof Map)) {
                    this.error(Messages.getInstance().getErrorString("TestComponent.ERROR_0003_PARAMETER_NOT_MAP", new Object[]{"p1"}));
                    return false;
                }
                theResult = new ArrayList(((Map)p1).keySet());
            } else {
                Object p2 = this.getParamFromComponentNode("p2", componentNode);
                if (p2 == null) {
                    return false;
                }
                if ("concat".equals(test)) {
                    theResult = p1.toString() + p2.toString();
                } else if ("print2".equals(test)) {
                    String delim = Messages.getInstance().getString("TestComponent.CODE_PRINT_DELIM");
                    theResult = delim + p1.toString() + " - " + p2.toString() + delim;
                } else {
                    Object p3 = this.getParamFromComponentNode("p3", componentNode);
                    if (p3 == null) {
                        return false;
                    }
                    if ("merge".equals(test)) {
                        if (!(p1 instanceof Map && p2 instanceof List && p3 instanceof String)) {
                            this.error(Messages.getInstance().getErrorString("TestComponent.ERROR_0004_P1_P2_WRONG_TYPE"));
                            return false;
                        }
                        theResult = this.merge((Map)p1, (List)p2, (String)p3);
                    } else {
                        this.message(Messages.getInstance().getErrorString("TestComponent.ERROR_0001_TEST_NODE_NOT_FOUND"));
                        return false;
                    }
                }
            }
        }
        if (newName != null) {
            this.message(newName + " = " + theResult);
            try {
                this.setOutputValue(newName, theResult);
            }
            catch (Exception exception) {}
        } else {
            this.message("The result = " + theResult);
        }
        return true;
    }

    public boolean init() {
        this.message(Messages.getInstance().getString("TestComponent.DEBUG_INITIALIZING_TEST"));
        return true;
    }

    protected Object getActionParameterValue(String name) {
        try {
            return this.getInputValue(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List merge(Map hm, List list, String keyName) {
        ArrayList<Map> al = new ArrayList<Map>();
        for (Object item : list) {
            Map resMap;
            if (!(item instanceof Map) || (resMap = this.merge(hm, (Map)item, keyName)) == null) continue;
            al.add(resMap);
        }
        return al;
    }

    private Map merge(Map srcMap, Map destMap, String keyName) {
        Object keyValue = destMap.get(keyName);
        HashMap rtnMap = null;
        Iterator it = srcMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (keyValue == null || !key.equalsIgnoreCase(keyValue.toString())) continue;
            rtnMap = new HashMap(destMap);
            rtnMap.put("NewKey", srcMap.get(key));
            return rtnMap;
        }
        return rtnMap;
    }

    private Object getParamFromComponentNode(String paramName, Node componentNode) {
        String param = XmlDom4JHelper.getNodeText((String)paramName, (Node)componentNode);
        if (param == null || param.length() < 1) {
            this.error(Messages.getInstance().getErrorString("TestComponent.ERROR_0002_PARAMETER_MISSING", new Object[]{paramName}));
            return null;
        }
        return this.getActionParameterValue(param);
    }
}

