/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AsyncSqlOutputFormat;
import org.apache.sqoop.util.LoggingUtils;

public abstract class AsyncSqlRecordWriter<K extends com.cloudera.sqoop.lib.SqoopRecord, V>
extends RecordWriter<K, V> {
    private static final Log LOG = LogFactory.getLog(AsyncSqlRecordWriter.class);
    private Connection connection;
    private Configuration conf;
    protected final int rowsPerStmt;
    private List<com.cloudera.sqoop.lib.SqoopRecord> records;
    private AsyncSqlOutputFormat.AsyncSqlExecThread execThread;
    private boolean startedExecThread;

    public AsyncSqlRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
        this.conf = context.getConfiguration();
        this.rowsPerStmt = this.conf.getInt("sqoop.export.records.per.statement", 100);
        int stmtsPerTx = this.conf.getInt("sqoop.export.statements.per.transaction", 100);
        DBConfiguration dbConf = new DBConfiguration(this.conf);
        this.connection = dbConf.getConnection();
        this.connection.setAutoCommit(false);
        this.records = new ArrayList<com.cloudera.sqoop.lib.SqoopRecord>(this.rowsPerStmt);
        this.execThread = new AsyncSqlOutputFormat.AsyncSqlExecThread(this.connection, stmtsPerTx);
        this.execThread.setDaemon(true);
        this.startedExecThread = false;
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    protected final Configuration getConf() {
        return this.conf;
    }

    protected boolean isBatchExec() {
        return false;
    }

    protected abstract PreparedStatement getPreparedStatement(List<com.cloudera.sqoop.lib.SqoopRecord> var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execUpdate(boolean commit, boolean stopThread) throws InterruptedException, SQLException {
        if (!this.startedExecThread) {
            this.execThread.start();
            this.startedExecThread = true;
        }
        PreparedStatement stmt = null;
        boolean successfulPut = false;
        try {
            if (this.records.size() > 0) {
                stmt = this.getPreparedStatement(this.records);
                this.records.clear();
            }
            AsyncSqlOutputFormat.AsyncDBOperation op = new AsyncSqlOutputFormat.AsyncDBOperation(stmt, this.isBatchExec(), commit, stopThread);
            this.execThread.put(op);
            successfulPut = true;
        }
        finally {
            if (!successfulPut && null != stmt) {
                stmt.close();
            }
        }
        SQLException lastException = this.execThread.getLastError();
        if (null != lastException) {
            LoggingUtils.logAll(LOG, lastException);
            throw lastException;
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            try {
                this.execUpdate(true, true);
                this.execThread.join();
            }
            catch (SQLException sqle) {
                throw new IOException(sqle);
            }
            SQLException lastErr = this.execThread.getLastError();
            if (null != lastErr) {
                throw new IOException(lastErr);
            }
        }
        finally {
            try {
                this.closeConnection(context);
            }
            catch (SQLException sqle) {
                throw new IOException(sqle);
            }
        }
    }

    public void closeConnection(TaskAttemptContext context) throws SQLException {
        this.connection.close();
    }

    public void write(K key, V value) throws InterruptedException, IOException {
        try {
            this.records.add((com.cloudera.sqoop.lib.SqoopRecord)((SqoopRecord)key).clone());
            if (this.records.size() >= this.rowsPerStmt) {
                this.execUpdate(false, false);
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new IOException("Could not buffer record", cnse);
        }
        catch (SQLException sqlException) {
            throw new IOException(sqlException);
        }
    }
}

