/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.objecttunnel;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.osgi.objecttunnel.TunnelInput;
import org.pentaho.osgi.objecttunnel.TunnelOutput;
import org.pentaho.osgi.objecttunnel.TunnelSerializer;

public class TunnelFactory {
    private Map<Class, TunnelSerializer> serializerMap = new HashMap<Class, TunnelSerializer>();
    private List<TunnelSerializer<?>> serializers = new ArrayList();

    public void setSerializers(List<TunnelSerializer<?>> serializers) {
        if (serializers != null) {
            this.serializers.addAll(serializers);
        }
        this.populateSerializerMap();
    }

    public void populateSerializerMap() {
        this.serializerMap.clear();
        for (TunnelSerializer<?> serializer : this.serializers) {
            List<Class> supportedClasses = serializer.getSupportedClasses();
            for (Class supportedClass : supportedClasses) {
                this.serializerMap.put(supportedClass, serializer);
            }
        }
    }

    public void addSerializer(TunnelSerializer<?> serializer) {
        this.serializers.add(serializer);
        this.populateSerializerMap();
    }

    public void removeSerializer(TunnelSerializer<?> serializer) {
        this.serializers.remove(serializer);
        this.populateSerializerMap();
    }

    Map<Class, TunnelSerializer> getSerializerMap() {
        return this.serializerMap;
    }

    public TunnelSerializer getSerializer(Class clazz) {
        return this.serializerMap.get(clazz);
    }

    public TunnelOutput createOutput(ObjectOutputStream outputStream) {
        return new TunnelOutput(outputStream, this.serializerMap);
    }

    public TunnelInput createInput(ObjectInputStream objectInputStream) {
        return new TunnelInput(objectInputStream, this.serializerMap);
    }
}

