/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.CreateAttribute;
import org.pentaho.agilebi.modeler.models.annotations.CreateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.util.KeyValueClosure;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class ModelAnnotation<T extends AnnotationType>
implements Serializable {
    private static final long serialVersionUID = 5742135911581602697L;
    private static final String CREATE_MEASURE_ENUM_VALUE = "Create Measure";
    private static final String CREATE_ATTRIBUTE_ENUM_VALUE = "Create Attribute";
    private static final String CREATE_DIMENSION_ENUM_VALUE = "Create Dimension Key";
    private static final String CREATE_CALCULATED_MEMBER_ENUM_VALUE = "Create Calculated Measure";
    private static final String REMOVE_MEASURE_ENUM_VALUE = "Remove Measure";
    private static final String LINK_DIMENSION_ENUM_VALUE = "Link Dimension";
    private static final String REMOVE_ATTRIBUTE_ENUM_VALUE = "Remove Attribute";
    private static final String UPDATE_MEASURE_ENUM_VALUE = "Update Measure";
    private static final String UPDATE_CALCULATED_MEMBER_ENUM_VALUE = "Update Calculated Measure";
    private static final String SHOW_HIDE_ATTRIBUTE_ENUM_VALUE = "Show or Hide Level";
    private static final String SHOW_HIDE_MEASURE_ENUM_VALUE = "Show or Hide Measure";
    private static final String UPDATE_ATTRIBUTE_ENUM_VALUE = "Update Attribute";
    private static final String BLANK_ENUM_VALUE = "";
    @MetaStoreAttribute
    private String name = UUID.randomUUID().toString();
    @MetaStoreAttribute
    @Deprecated
    private String field;
    @MetaStoreAttribute
    @Deprecated
    private String cube;
    @MetaStoreAttribute
    private T annotation;

    public ModelAnnotation() {
    }

    @Deprecated
    public ModelAnnotation(String field, T annotation) {
        this.setAnnotation(annotation);
        this.setField(field);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelAnnotation(T annotation) {
        this.setAnnotation(annotation);
    }

    public static List<ModelAnnotation<CreateMeasure>> getMeasures(List<ModelAnnotation<? extends AnnotationType>> annotations) {
        return ModelAnnotation.filter(annotations, CreateMeasure.class);
    }

    public static List<ModelAnnotation<CreateAttribute>> getAttributes(List<ModelAnnotation<? extends AnnotationType>> annotations) {
        return ModelAnnotation.filter(annotations, CreateAttribute.class);
    }

    private static <S extends AnnotationType> List<ModelAnnotation<S>> filter(List<ModelAnnotation<? extends AnnotationType>> annotations, Class<S> cls) {
        ArrayList<ModelAnnotation<S>> list = new ArrayList<ModelAnnotation<S>>();
        if (cls != null && annotations != null && annotations.size() > 0) {
            annotations.removeAll(Collections.singleton(null));
            for (ModelAnnotation<? extends AnnotationType> annotation : annotations) {
                if (annotation.getAnnotation() == null || !cls.equals(annotation.getAnnotation().getClass())) continue;
                list.add(annotation);
            }
        }
        return list;
    }

    @Deprecated
    public String getField() {
        try {
            String f = PropertyUtils.getProperty(this.annotation, (String)"field").toString();
            return f;
        }
        catch (Exception e) {
            return this.field;
        }
    }

    @Deprecated
    public void setField(String field) {
        this.field = field;
        try {
            PropertyUtils.setProperty(this.annotation, (String)"field", (Object)field);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public String getCube() {
        return this.cube;
    }

    @Deprecated
    public void setCube(String cube) {
        this.cube = cube;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(T annotation) {
        this.annotation = annotation;
    }

    public boolean apply(ModelerWorkspace modelerWorkspace, IMetaStore metaStore) throws ModelerException {
        if (this.getField() != null) {
            try {
                PropertyUtils.setProperty(this.annotation, (String)"field", (Object)this.getField());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ((AnnotationType)this.annotation).apply(modelerWorkspace, metaStore);
    }

    public boolean apply(Document schema) throws ModelerException {
        return ((AnnotationType)this.annotation).apply(schema);
    }

    public Type getType() {
        if (this.annotation != null) {
            return ((AnnotationType)this.annotation).getType();
        }
        return null;
    }

    public Map<String, Serializable> describeAnnotation() {
        if (this.annotation != null) {
            return ((AnnotationType)this.annotation).describe();
        }
        return null;
    }

    public void populateAnnotation(Map<String, Serializable> properties) {
        if (this.annotation != null) {
            ((AnnotationType)this.annotation).populate(properties);
        }
    }

    public void iterateProperties(KeyValueClosure closure) {
        if (this.annotation != null) {
            ((AnnotationType)this.annotation).iterateProperties(closure);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static enum GeoType {
        Location,
        Country,
        City,
        State,
        County,
        Postal_Code,
        Continent,
        Territory;


        public static String[] names() {
            GeoType[] types = GeoType.values();
            String[] names = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                names[i] = types[i].name();
            }
            return names;
        }
    }

    public static enum TimeType {
        TimeYears,
        TimeHalfYears,
        TimeQuarters,
        TimeMonths,
        TimeWeeks,
        TimeDays,
        TimeHours,
        TimeMinutes,
        TimeSeconds;


        public static String[] names() {
            TimeType[] types = TimeType.values();
            String[] names = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                names[i] = types[i].name();
            }
            return names;
        }
    }

    public static enum Type {
        CREATE_MEASURE("Create Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return !modelAnnotations.isSharedDimension();
            }
        }
        ,
        CREATE_ATTRIBUTE("Create Attribute"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return true;
            }
        }
        ,
        CREATE_DIMENSION_KEY("Create Dimension Key"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return modelAnnotations.isSharedDimension() && (this.isDimensionKey(modelAnnotation) || !this.hasDimensionKey(modelAnnotations));
            }

            private boolean isDimensionKey(ModelAnnotation modelAnnotation) {
                return CREATE_DIMENSION_KEY.equals((Object)modelAnnotation.getType());
            }

            private boolean hasDimensionKey(ModelAnnotationGroup modelAnnotations) {
                for (ModelAnnotation modelAnnotation : modelAnnotations) {
                    if (!this.isDimensionKey(modelAnnotation)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        LINK_DIMENSION("Link Dimension"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return !modelAnnotations.isSharedDimension();
            }
        }
        ,
        CREATE_CALCULATED_MEMBER("Create Calculated Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        REMOVE_MEASURE("Remove Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        REMOVE_ATTRIBUTE("Remove Attribute"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        UPDATE_MEASURE("Update Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        UPDATE_CALCULATED_MEMBER("Update Calculated Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        BLANK(""){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        SHOW_HIDE_ATTRIBUTE("Show or Hide Level"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        SHOW_HIDE_MEASURE("Show or Hide Measure"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        }
        ,
        UPDATE_ATTRIBUTE("Update Attribute"){

            @Override
            public boolean isApplicable(ModelAnnotationGroup modelAnnotations, ModelAnnotation modelAnnotation, ValueMetaInterface valueMeta) {
                return false;
            }
        };

        private final String description;

        private Type(String description) {
            this.description = description;
        }

        public static String[] names() {
            Type[] types = Type.values();
            String[] names = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                names[i] = types[i].name();
            }
            return names;
        }

        public String description() {
            return this.description;
        }

        public abstract boolean isApplicable(ModelAnnotationGroup var1, ModelAnnotation var2, ValueMetaInterface var3);
    }
}

