/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocol;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocolFactory;

public class LDAPConnection {
    private static Class<?> PKG = LDAPInputMeta.class;
    public static final int SEARCH_SCOPE_OBJECT_SCOPE = 0;
    public static final int SEARCH_SCOPE_ONELEVEL_SCOPE = 1;
    public static final int SEARCH_SCOPE_SUBTREE_SCOPE = 2;
    public static final int DEFAULT_PORT = 389;
    public static final String DEFAUL_FILTER_STRING = "objectclass=*";
    public static final int STATUS_SKIPPED = 0;
    public static final int STATUS_INSERTED = 1;
    public static final int STATUS_UPDATED = 2;
    public static final int STATUS_DELETED = 3;
    public static final int STATUS_ADDED = 4;
    private final LogChannelInterface log;
    private String searchBase;
    private String filter;
    private SearchControls controls;
    private int timeLimit;
    private int pagingSize;
    private NamingEnumeration<SearchResult> results;
    private List<String> sortingAttributes;
    private String[] sortingAttributesKeys;
    private LdapProtocol protocol;

    public LDAPConnection(LogChannelInterface logInterface, VariableSpace variableSpace, LdapMeta meta, Collection<String> binaryAttributes) throws KettleException {
        this.log = logInterface;
        this.protocol = new LdapProtocolFactory(logInterface).createLdapProtocol(variableSpace, meta, binaryAttributes);
        this.sortingAttributes = new ArrayList<String>();
    }

    public void connect() throws KettleException {
        this.connect(null, null);
    }

    public void connect(String username, String password) throws KettleException {
        this.protocol.connect(username, password);
    }

    public void setSortingAttributesKeys(String[] value) {
        this.sortingAttributesKeys = value;
    }

    private String[] getSortingAttributesKeys() {
        return this.sortingAttributesKeys;
    }

    public void addSortingAttributes(String value) {
        this.sortingAttributes.add(value);
    }

    public List<String> getSortingAttributes() {
        return this.sortingAttributes;
    }

    private boolean isSortingAttributes() {
        return !this.sortingAttributes.isEmpty();
    }

    private void setFilter(String filter) {
        this.filter = filter;
    }

    private String getFilter() {
        return this.filter;
    }

    private void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    private String getSearchBase() {
        return this.searchBase;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void SetPagingSize(int value) {
        this.pagingSize = value;
    }

    private int GetPagingSize() {
        return this.pagingSize;
    }

    private boolean isPagingUsed() {
        return this.GetPagingSize() > 0;
    }

    public void search(String searchBase, String filter, int limitRows, String[] attributeReturned, int searchScope) throws KettleException {
        this.setSearchBase(searchBase);
        this.setFilter(Const.NVL((String)LDAPConnection.correctFilter(filter), (String)DEFAUL_FILTER_STRING));
        try {
            if (Utils.isEmpty((CharSequence)this.getSearchBase())) {
                Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"namingContexts"});
                Attribute attr = attrs.get("namingContexts");
                this.setSearchBase(attr.get().toString());
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"LDAPInput.SearchBaseFound", (String[])new String[]{this.getSearchBase()}));
                }
            }
            this.controls = new SearchControls();
            if (limitRows > 0) {
                this.controls.setCountLimit(limitRows);
            }
            if (this.getTimeLimit() > 0) {
                this.controls.setTimeLimit(this.getTimeLimit() * 1000);
            }
            if (attributeReturned != null) {
                this.controls.setReturningAttributes(attributeReturned);
            }
            switch (searchScope) {
                case 0: {
                    this.controls.setSearchScope(0);
                    break;
                }
                case 1: {
                    this.controls.setSearchScope(1);
                    break;
                }
                default: {
                    this.controls.setSearchScope(2);
                }
            }
            PagedResultsControl ctlp = null;
            SortControl ctlk = null;
            int nrCtl = 0;
            if (this.isSortingAttributes()) {
                this.setSortingAttributesKeys(this.getSortingAttributes().toArray(new String[this.getSortingAttributes().size()]));
                ctlk = new SortControl(this.getSortingAttributesKeys(), false);
                ++nrCtl;
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString((String)"LDAPInput.Log.SortingKeys", (String)this.getSortingAttributesKeys().toString()));
                }
            }
            if (this.isPagingUsed()) {
                ctlp = new PagedResultsControl(this.GetPagingSize(), true);
                ++nrCtl;
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString((String)"LDAPInput.Log.PageSize", (String)String.valueOf(this.GetPagingSize())));
                }
            }
            if (nrCtl > 0) {
                Control[] ctls = new Control[nrCtl];
                int index = 0;
                if (ctlk != null) {
                    ctls[index++] = ctlk;
                }
                if (ctlp != null) {
                    ctls[index++] = ctlp;
                }
                this.getInitialContext().setRequestControls(ctls);
            }
            this.results = this.getInitialContext().search(this.getSearchBase(), this.getFilter(), this.getSearchControls());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString((String)"LDAPConnection.Error.Search"), (Throwable)e);
        }
    }

    public int delete(String dn, boolean checkEntry) throws KettleException {
        try {
            if (checkEntry) {
                this.getInitialContext().lookup(dn);
            }
            this.getInitialContext().destroySubcontext(dn);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"LDAPinput.Exception.Deleted", (String[])new String[]{dn}));
            }
            return 3;
        }
        catch (NameNotFoundException n) {
            if (checkEntry) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Deleting.NameNotFound", (String[])new String[]{dn}), (Throwable)n);
            }
            return 0;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Delete", (String[])new String[]{dn}), (Throwable)e);
        }
    }

    public int update(String dn, String[] attributes, String[] values, boolean checkEntry) throws KettleException {
        try {
            int nrAttributes = attributes.length;
            ModificationItem[] mods = new ModificationItem[nrAttributes];
            for (int i = 0; i < nrAttributes; ++i) {
                BasicAttribute mod = new BasicAttribute(attributes[i], values[i]);
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"LDAPConnection.Update.Attribute", (String[])new String[]{attributes[i], values[i]}));
                }
                mods[i] = new ModificationItem(2, mod);
            }
            this.getInitialContext().modifyAttributes(dn, mods);
            return 2;
        }
        catch (NameNotFoundException n) {
            if (checkEntry) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Deleting.NameNotFound", (String[])new String[]{dn}), (Throwable)n);
            }
            return 0;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Update", (String[])new String[]{dn}), (Throwable)e);
        }
    }

    public int add(String dn, String[] attributes, String[] values, String multValuedSeparator, boolean checkEntry) throws KettleException {
        try {
            Attributes attrs = this.buildAttributes(dn, attributes, values, multValuedSeparator);
            this.getInitialContext().modifyAttributes(dn, 1, attrs);
            return 4;
        }
        catch (NameNotFoundException n) {
            if (checkEntry) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Deleting.NameNotFound", (String[])new String[]{dn}), (Throwable)n);
            }
            return 0;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Add", (String[])new String[]{dn}), (Throwable)e);
        }
    }

    public void insert(String dn, String[] attributes, String[] values, String multValuedSeparator) throws KettleException {
        try {
            Attributes attrs = this.buildAttributes(dn, attributes, values, multValuedSeparator);
            this.getInitialContext().createSubcontext(dn, attrs);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Insert", (String[])new String[]{dn}), (Throwable)e);
        }
    }

    public int upsert(String dn, String[] attributes, String[] values, String[] attributesToUpdate, String[] valuesToUpdate, String multValuedSeparator) throws KettleException {
        try {
            boolean found = false;
            try {
                this.getInitialContext().getAttributes(dn);
                found = true;
            }
            catch (NameNotFoundException n) {
                Attributes attrs = this.buildAttributes(dn, attributes, values, multValuedSeparator);
                this.getInitialContext().createSubcontext(dn, attrs);
                return 1;
            }
            if (found && attributesToUpdate != null && attributesToUpdate.length > 0) {
                Attributes attrs = this.buildAttributes(dn, attributesToUpdate, valuesToUpdate, multValuedSeparator);
                this.getInitialContext().modifyAttributes(dn, 2, attrs);
                return 2;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Upsert", (String[])new String[]{dn}), (Throwable)e);
        }
        return 0;
    }

    private Attributes buildAttributes(String dn, String[] attributes, String[] values, String multValuedSeparator) {
        BasicAttributes attrs = new BasicAttributes(true);
        int nrAttributes = attributes.length;
        for (int i = 0; i < nrAttributes; ++i) {
            if (Utils.isEmpty((CharSequence)values[i])) continue;
            String value = values[i].trim();
            if (multValuedSeparator != null && value.indexOf(multValuedSeparator) > 0) {
                BasicAttribute attr = new BasicAttribute(attributes[i]);
                for (String attribute : value.split(multValuedSeparator)) {
                    attr.add(attribute);
                }
                attrs.put(attr);
                continue;
            }
            attrs.put(attributes[i], value);
        }
        return attrs;
    }

    public void rename(String oldDn, String newDn, boolean deleteRDN) throws KettleException {
        try {
            if (!deleteRDN) {
                this.getInitialContext().removeFromEnvironment("java.naming.ldap.deleteRDN");
            }
            HashMap<String, Attributes> childs = new HashMap<String, Attributes>();
            ArrayList<String> paths = new ArrayList<String>();
            this.getPaths(oldDn, childs, paths);
            for (String childName : paths) {
                this.getInitialContext().destroySubcontext(childName);
            }
            try {
                this.getInitialContext().rename(oldDn, newDn);
            }
            catch (Exception e) {
                for (int i = paths.size(); i > 0; --i) {
                    this.getInitialContext().createSubcontext((String)paths.get(i - 1), (Attributes)childs.get(paths.get(i - 1)));
                }
                throw e;
            }
            ArrayList<String> newpaths = new ArrayList<String>();
            for (String childName : paths) {
                newpaths.add(childName.replaceAll(oldDn, newDn));
            }
            for (int i = newpaths.size(); i > 0; --i) {
                this.getInitialContext().createSubcontext((String)newpaths.get(i - 1), (Attributes)childs.get(paths.get(i - 1)));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.Renaming", (String[])new String[]{oldDn, newDn}), (Throwable)e);
        }
        finally {
            try {
                if (!deleteRDN) {
                    this.getInitialContext().addToEnvironment("java.naming.ldap.deleteRDN", "true");
                }
            }
            catch (Exception exception) {}
        }
    }

    private void getPaths(String rootName, Map<String, Attributes> childs, List<String> paths) throws Exception {
        NamingEnumeration<NameClassPair> ne = this.getInitialContext().list(rootName);
        while (ne.hasMore()) {
            NameClassPair nameCP = ne.next();
            childs.put(nameCP.getName() + "," + rootName, this.getInitialContext().getAttributes(nameCP.getName() + "," + rootName));
            this.getPaths(nameCP.getName() + "," + rootName, childs, paths);
            paths.add(nameCP.getName() + "," + rootName);
        }
    }

    public void close() throws KettleException {
        if (this.protocol != null) {
            try {
                this.protocol.close();
            }
            catch (KettleException e) {
                throw e;
            }
            finally {
                this.protocol = null;
                if (this.results != null) {
                    this.results = null;
                }
            }
        }
    }

    public Attributes getAttributes() throws KettleException {
        byte[] cookie = null;
        while (!this.getSearchResult().hasMoreElements()) {
            if (this.isPagingUsed()) {
                try {
                    Control[] rc = this.getInitialContext().getResponseControls();
                    if (rc != null) {
                        for (int i = 0; i < rc.length; ++i) {
                            if (!(rc[i] instanceof PagedResultsResponseControl)) continue;
                            PagedResultsResponseControl prc = (PagedResultsResponseControl)rc[i];
                            cookie = prc.getCookie();
                        }
                    }
                    if (this.isSortingAttributes()) {
                        this.getInitialContext().setRequestControls(new Control[]{new SortControl(this.getSortingAttributesKeys(), false), new PagedResultsControl(this.GetPagingSize(), cookie, true)});
                    } else {
                        this.getInitialContext().setRequestControls(new Control[]{new PagedResultsControl(this.GetPagingSize(), cookie, true)});
                    }
                    if (cookie == null || cookie.length == 0) {
                        return null;
                    }
                    this.results = this.getInitialContext().search(this.getSearchBase(), this.getFilter(), this.getSearchControls());
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.ErrorPaging", (String[])new String[0]), (Throwable)e);
                }
                if (this.getSearchResult().hasMoreElements()) continue;
                return null;
            }
            return null;
        }
        try {
            SearchResult searchResult = this.getSearchResult().next();
            Attributes results = searchResult.getAttributes();
            results.put("dn", searchResult.getNameInNamespace());
            return results;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Exception.GettingAttributes", (String[])new String[0]), (Throwable)e);
        }
    }

    private InitialLdapContext getInitialContext() {
        return this.protocol.getCtx();
    }

    private SearchControls getSearchControls() {
        return this.controls;
    }

    private NamingEnumeration<SearchResult> getSearchResult() {
        return this.results;
    }

    private static String correctFilter(String filter) {
        return Utils.isEmpty((CharSequence)filter) ? "" : filter.replaceAll("(\\r|\\n)", "");
    }

    public static String extractBytesAndConvertToString(Attribute attr, boolean isSID) throws Exception {
        byte[] b;
        try {
            b = (byte[])attr.get();
        }
        catch (Exception e) {
            b = attr.get().toString().getBytes();
        }
        if (isSID) {
            return LDAPConnection.getSIDAsString(b);
        }
        return LDAPConnection.byteToHexEncode(b);
    }

    private static String getSIDAsString(byte[] SID) {
        String strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }

    private static String byteToHexEncode(byte[] inArr) {
        StringBuilder guid = new StringBuilder();
        for (int i = 0; i < inArr.length; ++i) {
            StringBuilder dblByte = new StringBuilder(Integer.toHexString(inArr[i] & 0xFF));
            if (dblByte.length() == 1) {
                guid.append("0");
            }
            guid.append((CharSequence)dblByte);
        }
        return guid.toString();
    }

    public RowMeta getFields(String searchBase) throws KettleException {
        RowMeta fields = new RowMeta();
        ArrayList<String> fieldsl = new ArrayList<String>();
        try {
            this.search(searchBase, null, 0, null, 2);
            Attributes attributes = null;
            fieldsl = new ArrayList();
            while ((attributes = this.getAttributes()) != null) {
                NamingEnumeration<? extends Attribute> ne = attributes.getAll();
                while (ne.hasMore()) {
                    Attribute attr = ne.next();
                    String fieldName = attr.getID();
                    if (fieldsl.contains(fieldName)) continue;
                    fieldsl.add(fieldName);
                    String attributeValue = attr.get().toString();
                    int valueType = this.IsDate(attributeValue) ? 3 : (this.IsInteger(attributeValue) ? 5 : (this.IsNumber(attributeValue) ? 1 : 2));
                    ValueMetaInterface value = ValueMetaFactory.createValueMeta((String)fieldName, (int)valueType);
                    fields.addValueMeta(value);
                }
            }
            RowMeta rowMeta = fields;
            return rowMeta;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPConnection.Error.RetrievingFields", (String[])new String[0]));
        }
        finally {
            fieldsl = null;
        }
    }

    private boolean IsNumber(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean IsDate(String str) {
        try {
            SimpleDateFormat fdate = new SimpleDateFormat("yy-mm-dd");
            fdate.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean IsInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

