/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.json.simple.JSONObject;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.HTTPMeta;

public class HTTP
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HTTPMeta.class;
    private HTTPMeta meta;
    private HTTPData data;

    public HTTP(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] execHttp(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.argnrs = new int[this.meta.getArgumentField().length];
            for (int i = 0; i < this.meta.getArgumentField().length; ++i) {
                this.data.argnrs[i] = rowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                if (this.data.argnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArgumentField()[i] + "]");
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.CouldnotFindField", (String[])new String[]{this.meta.getArgumentField()[i]}));
            }
        }
        return this.callHttpService(rowMeta, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] callHttpService(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        String url = this.determineUrl(rowMeta, rowData);
        try {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.Connecting", (String[])new String[]{url}));
            }
            HttpClient httpClient = SlaveConnectionManager.getInstance().createHttpClient();
            GetMethod method = new GetMethod(url);
            if (this.data.realConnectionTimeout > -1) {
                httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.data.realConnectionTimeout);
            }
            if (this.data.realSocketTimeout > -1) {
                httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.data.realSocketTimeout);
            }
            if (!Utils.isEmpty((CharSequence)this.data.realHttpLogin)) {
                httpClient.getParams().setAuthenticationPreemptive(true);
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.data.realHttpLogin, this.data.realHttpPassword);
                httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            }
            HostConfiguration hostConfiguration = new HostConfiguration();
            if (!Utils.isEmpty((CharSequence)this.data.realProxyHost)) {
                hostConfiguration.setProxy(this.data.realProxyHost, this.data.realProxyPort);
            }
            if (this.data.useHeaderParameters) {
                for (int i = 0; i < this.data.header_parameters_nrs.length; ++i) {
                    method.addRequestHeader(this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i]));
                    if (!this.isDebug()) continue;
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.HeaderValue", (String[])new String[]{this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i])}));
                }
            }
            InputStreamReader inputStreamReader = null;
            Object[] newRow = null;
            if (rowData != null) {
                newRow = (Object[])rowData.clone();
            }
            try {
                long startTime = System.currentTimeMillis();
                int statusCode = this.requestStatusCode((HttpMethod)method, hostConfiguration, httpClient);
                long responseTime = System.currentTimeMillis() - startTime;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseTime", (Object[])new Object[]{responseTime, url}));
                }
                String body = null;
                String headerString = null;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseStatusCode", (String[])new String[]{"" + statusCode}));
                }
                if (statusCode != -1) {
                    if (statusCode == 204) {
                        body = "";
                    } else if (statusCode != 401) {
                        int c;
                        String contentType;
                        Header[] headers = this.searchForHeaders((HttpMethod)method);
                        String encoding = this.meta.getEncoding();
                        if (Utils.isEmpty((CharSequence)encoding) && (contentType = method.getResponseHeader("Content-Type").getValue()) != null && contentType.contains("charset")) {
                            encoding = contentType.replaceFirst("^.*;\\s*charset\\s*=\\s*", "").replace("\"", "").trim();
                        }
                        JSONObject json = new JSONObject();
                        for (Header header : headers) {
                            ArrayList<String> list;
                            Object previousValue = json.get((Object)header.getName());
                            if (previousValue == null) {
                                json.put((Object)header.getName(), (Object)header.getValue());
                                continue;
                            }
                            if (previousValue instanceof List) {
                                list = (ArrayList<String>)previousValue;
                                list.add(header.getValue());
                                continue;
                            }
                            list = new ArrayList<String>();
                            list.add((String)previousValue);
                            list.add(header.getValue());
                            json.put((Object)header.getName(), list);
                        }
                        headerString = json.toJSONString();
                        if (this.isDebug()) {
                            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseHeaderEncoding", (String[])new String[]{encoding})});
                        }
                        inputStreamReader = this.openStream(encoding, (HttpMethod)method);
                        StringBuilder bodyBuffer = new StringBuilder();
                        while ((c = inputStreamReader.read()) != -1) {
                            bodyBuffer.append((char)c);
                        }
                        inputStreamReader.close();
                        body = bodyBuffer.toString();
                        if (this.isDebug()) {
                            this.logDebug("Response body: " + body);
                        }
                    } else {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.Authentication", (String[])new String[]{this.data.realUrl}));
                    }
                }
                int returnFieldsOffset = rowMeta.size();
                if (!Utils.isEmpty((CharSequence)this.meta.getFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResultCodeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(statusCode));
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResponseTimeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResponseHeaderFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, headerString);
                }
            }
            finally {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                method.releaseConnection();
                if (this.data.realcloseIdleConnectionsTime > -1) {
                    httpClient.getHttpConnectionManager().closeIdleConnections((long)this.data.realcloseIdleConnectionsTime);
                }
            }
            return newRow;
        }
        catch (UnknownHostException uhe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableGetResult", (String[])new String[]{url}), (Throwable)e);
        }
    }

    private String determineUrl(RowMetaInterface outputRowMeta, Object[] row) throws KettleValueException, KettleException {
        try {
            if (this.meta.isUrlInField()) {
                this.data.realUrl = outputRowMeta.getString(row, this.data.indexOfUrlField);
            }
            StringBuilder url = new StringBuilder(this.data.realUrl);
            for (int i = 0; i < this.data.argnrs.length; ++i) {
                if (i == 0 && url.indexOf("?") < 0) {
                    url.append('?');
                } else {
                    url.append('&');
                }
                url.append(URIUtil.encodeWithinQuery((String)this.meta.getArgumentParameter()[i]));
                url.append('=');
                String s = outputRowMeta.getString(row, this.data.argnrs[i]);
                if (s != null) {
                    s = URIUtil.encodeWithinQuery((String)s);
                }
                url.append(s);
            }
            return url.toString();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableCreateUrl", (String[])new String[0]), (Throwable)e);
        }
    }

    protected int requestStatusCode(HttpMethod method, HostConfiguration hostConfiguration, HttpClient httpClient) throws IOException {
        return httpClient.executeMethod(hostConfiguration, method);
    }

    protected InputStreamReader openStream(String encoding, HttpMethod method) throws Exception {
        if (!Utils.isEmpty((CharSequence)encoding)) {
            return new InputStreamReader(method.getResponseBodyAsStream(), encoding);
        }
        return new InputStreamReader(method.getResponseBodyAsStream());
    }

    protected Header[] searchForHeaders(HttpMethod method) {
        return method.getResponseHeaders();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block14: {
            this.meta = (HTTPMeta)smi;
            this.data = (HTTPData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrHeaders;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputRowMeta = this.getInputRowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.getInputRowMeta().indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if ((nrHeaders = this.meta.getHeaderField().length) > 0) {
                    this.data.useHeaderParameters = true;
                }
                this.data.header_parameters_nrs = new int[nrHeaders];
                this.data.headerParameters = new NameValuePair[nrHeaders];
                for (int i = 0; i < nrHeaders; ++i) {
                    int fieldIndex = this.data.inputRowMeta.indexOfValue(this.meta.getHeaderField()[i]);
                    if (fieldIndex < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[0]) + this.meta.getHeaderField()[i] + "]");
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[]{this.meta.getHeaderField()[i]}));
                    }
                    this.data.header_parameters_nrs[i] = fieldIndex;
                    this.data.headerParameters[i] = new NameValuePair(this.environmentSubstitute(this.meta.getHeaderParameter()[i]), this.data.outputRowMeta.getString(r, this.data.header_parameters_nrs[i]));
                }
            }
            try {
                Object[] outputRowData = this.execHttp(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTP.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block14;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTP001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        if (super.init(smi, sdi)) {
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getHttpPassword());
            this.data.realSocketTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realConnectionTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        super.dispose(smi, sdi);
    }
}

