/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.performance;

import java.util.Date;

public class StepPerformanceSnapShot {
    private long batchId;
    private int seqNr;
    private Date date;
    private String transName;
    private String stepName;
    private int stepCopy;
    private long totalLinesRead;
    private long totalLinesWritten;
    private long totalLinesInput;
    private long totalLinesOutput;
    private long totalLinesUpdated;
    private long totalLinesRejected;
    private long totalErrors;
    private long timeDifference;
    private long linesRead;
    private long linesWritten;
    private long linesInput;
    private long linesOutput;
    private long linesUpdated;
    private long linesRejected;
    private long errors;
    private long inputBufferSize;
    private long outputBufferSize;

    public StepPerformanceSnapShot(int seqNr, long batchId, Date date, String transName, String stepName, int stepCopy, long totalLinesRead, long totalLinesWritten, long totalLinesInput, long totalLinesOutput, long totalLinesUpdated, long totalLinesRejected, long totalErrors) {
        this.seqNr = seqNr;
        this.batchId = batchId;
        this.date = date;
        this.transName = transName;
        this.stepName = stepName;
        this.stepCopy = stepCopy;
        this.totalLinesRead = totalLinesRead;
        this.totalLinesWritten = totalLinesWritten;
        this.totalLinesInput = totalLinesInput;
        this.totalLinesOutput = totalLinesOutput;
        this.totalLinesUpdated = totalLinesUpdated;
        this.totalLinesRejected = totalLinesRejected;
        this.totalErrors = totalErrors;
    }

    public void diff(StepPerformanceSnapShot previous, long inputBufferSize, long outputBufferSize) {
        this.inputBufferSize = inputBufferSize;
        this.outputBufferSize = outputBufferSize;
        if (previous == null) {
            this.timeDifference = 0L;
            this.linesRead = this.totalLinesRead;
            this.linesWritten = this.totalLinesWritten;
            this.linesInput = this.totalLinesInput;
            this.linesOutput = this.totalLinesOutput;
            this.linesUpdated = this.totalLinesUpdated;
            this.linesRejected = this.totalLinesRejected;
            this.errors = this.totalErrors;
        } else {
            this.timeDifference = this.date.getTime() - previous.date.getTime();
            this.linesRead = this.totalLinesRead - previous.totalLinesRead;
            this.linesWritten = this.totalLinesWritten - previous.totalLinesWritten;
            this.linesInput = this.totalLinesInput - previous.totalLinesInput;
            this.linesOutput = this.totalLinesOutput - previous.totalLinesOutput;
            this.linesUpdated = this.totalLinesUpdated - previous.totalLinesUpdated;
            this.linesRejected = this.totalLinesRejected - previous.totalLinesRejected;
            this.errors = this.totalErrors - previous.totalErrors;
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public int getStepCopy() {
        return this.stepCopy;
    }

    public void setStepCopy(int stepCopy) {
        this.stepCopy = stepCopy;
    }

    public long getTotalLinesRead() {
        return this.totalLinesRead;
    }

    public void setTotalLinesRead(long totalLinesRead) {
        this.totalLinesRead = totalLinesRead;
    }

    public long getTotalLinesWritten() {
        return this.totalLinesWritten;
    }

    public void setTotalLinesWritten(long totalLinesWritten) {
        this.totalLinesWritten = totalLinesWritten;
    }

    public long getTotalLinesInput() {
        return this.totalLinesInput;
    }

    public void setTotalLinesInput(long totalLinesInput) {
        this.totalLinesInput = totalLinesInput;
    }

    public long getTotalLinesOutput() {
        return this.totalLinesOutput;
    }

    public void setTotalLinesOutput(long totalLinesOutput) {
        this.totalLinesOutput = totalLinesOutput;
    }

    public long getTotalLinesUpdated() {
        return this.totalLinesUpdated;
    }

    public void setTotalLinesUpdated(long totalLinesUpdated) {
        this.totalLinesUpdated = totalLinesUpdated;
    }

    public long getTotalLinesRejected() {
        return this.totalLinesRejected;
    }

    public void setTotalLinesRejected(long totalLinesRejected) {
        this.totalLinesRejected = totalLinesRejected;
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }

    public void setTotalErrors(long totalErrors) {
        this.totalErrors = totalErrors;
    }

    public long getTimeDifference() {
        return this.timeDifference;
    }

    public void setTimeDifference(long timeDifference) {
        this.timeDifference = timeDifference;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public void setLinesRead(long linesRead) {
        this.linesRead = linesRead;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public void setLinesWritten(long linesWritten) {
        this.linesWritten = linesWritten;
    }

    public long getLinesInput() {
        return this.linesInput;
    }

    public void setLinesInput(long linesInput) {
        this.linesInput = linesInput;
    }

    public long getLinesOutput() {
        return this.linesOutput;
    }

    public void setLinesOutput(long linesOutput) {
        this.linesOutput = linesOutput;
    }

    public long getLinesUpdated() {
        return this.linesUpdated;
    }

    public void setLinesUpdated(long linesUpdated) {
        this.linesUpdated = linesUpdated;
    }

    public long getLinesRejected() {
        return this.linesRejected;
    }

    public void setLinesRejected(long linesRejected) {
        this.linesRejected = linesRejected;
    }

    public long getErrors() {
        return this.errors;
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    public long getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(long inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public long getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(long outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public int getSeqNr() {
        return this.seqNr;
    }

    public void setSeqNr(int seqNr) {
        this.seqNr = seqNr;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }
}

