/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.SqlTransGenerator;
import org.pentaho.di.trans.dataservice.clients.TransMutators;
import org.pentaho.di.trans.dataservice.execution.CopyParameters;
import org.pentaho.di.trans.dataservice.execution.DefaultTransWiring;
import org.pentaho.di.trans.dataservice.execution.PrepareExecution;
import org.pentaho.di.trans.dataservice.execution.TransStarter;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.ValueMetaResolver;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.metastore.api.IMetaStore;

public class DataServiceExecutor {
    private static final Class<?> PKG = DataServiceExecutor.class;
    private static final String ROW_LIMIT_PROPERTY = "det.dataservice.dynamic.limit";
    private static final int ROW_LIMIT_DEFAULT = 50000;
    private final Trans serviceTrans;
    private final Trans genTrans;
    private final DataServiceMeta service;
    private final SQL sql;
    private final Map<String, String> parameters;
    private final SqlTransGenerator sqlTransGenerator;
    private final ListMultimap<ExecutionPoint, Runnable> listenerMap;

    private DataServiceExecutor(Builder builder) {
        this.sql = builder.sql;
        this.service = builder.service;
        this.parameters = Maps.newHashMap((Map)builder.parameters);
        this.parameters.putAll(this.getWhereConditionParameters());
        this.serviceTrans = builder.serviceTrans;
        this.sqlTransGenerator = builder.sqlTransGenerator;
        this.genTrans = builder.genTrans;
        this.listenerMap = MultimapBuilder.enumKeys(ExecutionPoint.class).linkedListValues().build();
    }

    private void setLogLevel(LogLevel logLevel) {
        if (this.serviceTrans != null) {
            this.serviceTrans.setLogLevel(logLevel);
            this.getServiceTransMeta().setLogLevel(logLevel);
        }
        if (this.genTrans != null) {
            this.genTrans.setLogLevel(logLevel);
            this.getGenTransMeta().setLogLevel(logLevel);
        }
    }

    private static void convertCondition(Condition condition, ValueMetaResolver resolver) {
        if (condition.isAtomic()) {
            if (condition.getFunction() == 9) {
                DataServiceExecutor.convertListCondition(condition, resolver);
            } else {
                DataServiceExecutor.convertAtomicCondition(condition, resolver);
            }
        } else {
            for (Condition child : condition.getChildren()) {
                DataServiceExecutor.convertCondition(child, resolver);
            }
        }
    }

    private static void convertAtomicCondition(Condition condition, ValueMetaResolver resolver) {
        if (condition.getRightExact() == null) {
            return;
        }
        String fieldName = condition.getLeftValuename();
        ValueMetaAndData rhs = condition.getRightExact();
        try {
            ValueMetaInterface resolvedValueMeta = resolver.getValueMeta(fieldName);
            Object resolvedValue = resolver.getTypedValue(fieldName, rhs.getValueMeta().getType(), rhs.getValueData());
            if (resolvedValueMeta.getStorageType() != 0) {
                resolvedValueMeta = resolvedValueMeta.clone();
                resolvedValueMeta.setStorageType(0);
            }
            condition.setRightExact(new ValueMetaAndData(resolvedValueMeta, resolvedValue));
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
    }

    private static void convertListCondition(Condition condition, ValueMetaResolver resolver) {
        String fieldName = condition.getLeftValuename();
        try {
            ValueMetaInterface resolvedValueMeta = resolver.getValueMeta(fieldName);
            Object[] typedValues = resolver.inListToTypedObjectArray(fieldName, condition.getRightExactString());
            Object[] typedValueStrings = new String[typedValues.length];
            for (int i = 0; i < typedValues.length; ++i) {
                typedValueStrings[i] = resolvedValueMeta.getCompatibleString(typedValues[i]);
            }
            condition.getRightExact().setValueData((Object)StringUtils.join((Object[])typedValueStrings, (char)';'));
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
    }

    private void extractConditionParameters(Condition condition, Map<String, String> parameters) {
        if (condition.isAtomic()) {
            if (condition.getFunction() == 14) {
                parameters.put(condition.getLeftValuename(), condition.getRightExactString());
                this.stripFieldNamesFromTrueFunction(condition);
            }
        } else {
            for (Condition sub : condition.getChildren()) {
                this.extractConditionParameters(sub, parameters);
            }
        }
    }

    private void stripFieldNamesFromTrueFunction(Condition condition) {
        assert (condition.getFunction() == 14);
        condition.setLeftValuename(null);
        condition.setRightValuename(null);
    }

    protected void prepareExecution() throws KettleException {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll((Object)ExecutionPoint.PREPARE, (Object[])new Runnable[]{new CopyParameters(this.parameters, (NamedParams)this.serviceTrans, new NamedParams[0]), new PrepareExecution(this.genTrans), new PrepareExecution(this.serviceTrans)});
        builder.putAll((Object)ExecutionPoint.READY, (Object[])new Runnable[]{new DefaultTransWiring(this)});
        builder.putAll((Object)ExecutionPoint.START, (Object[])new Runnable[]{new TransStarter(this.genTrans), new TransStarter(this.serviceTrans)});
        this.listenerMap.putAll((Multimap)builder.build());
    }

    private Map<String, String> getWhereConditionParameters() {
        HashMap<String, String> conditionParameters = new HashMap<String, String>();
        if (this.sql.getWhereCondition() != null) {
            this.extractConditionParameters(this.sql.getWhereCondition().getCondition(), conditionParameters);
        }
        return conditionParameters;
    }

    public static void writeMetadata(DataOutputStream dos, String ... metadatas) throws IOException {
        for (String metadata : metadatas) {
            dos.writeUTF(metadata);
        }
    }

    public DataServiceExecutor executeQuery(final DataOutputStream dos) throws IOException {
        DataServiceExecutor.writeMetadata(dos, this.getServiceName(), DataServiceExecutor.calculateTransname(this.getSql(), true), this.getServiceTrans().getContainerObjectId(), DataServiceExecutor.calculateTransname(this.getSql(), false), this.getGenTrans().getContainerObjectId());
        final AtomicBoolean rowMetaWritten = new AtomicBoolean(false);
        this.getGenTrans().addTransListener((TransListener)new TransAdapter(){

            public void transFinished(Trans trans) throws KettleException {
                if (rowMetaWritten.compareAndSet(false, true)) {
                    RowMetaInterface stepFields = trans.getTransMeta().getStepFields(DataServiceExecutor.this.getResultStepName());
                    stepFields.writeMeta(dos);
                }
            }
        });
        return this.executeQuery((RowListener)new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                block3: {
                    try {
                        if (rowMetaWritten.compareAndSet(false, true)) {
                            rowMeta.writeMeta(dos);
                        }
                        rowMeta.writeData(dos, row);
                    }
                    catch (Exception e) {
                        if (DataServiceExecutor.this.getServiceTrans().isStopped()) break block3;
                        throw new KettleStepException((Throwable)e);
                    }
                }
            }
        });
    }

    public DataServiceExecutor executeQuery(final RowListener resultRowListener) {
        this.listenerMap.get((Object)ExecutionPoint.READY).add(new Runnable(){

            @Override
            public void run() {
                StepInterface resultStep = DataServiceExecutor.this.genTrans.findRunThread(DataServiceExecutor.this.getResultStepName());
                resultStep.addRowListener(resultRowListener);
            }
        });
        return this.executeQuery();
    }

    public DataServiceExecutor executeQuery() {
        for (PushDownOptimizationMeta optimizationMeta : this.service.getPushDownOptimizationMeta()) {
            if (!optimizationMeta.isEnabled()) continue;
            optimizationMeta.activate(this);
        }
        this.executeListeners(ExecutionPoint.values());
        return this;
    }

    public void executeListeners(ExecutionPoint ... stages) {
        for (ExecutionPoint stage : stages) {
            ImmutableList tasks = ImmutableList.copyOf((Collection)this.listenerMap.get((Object)stage));
            for (Runnable task : tasks) {
                task.run();
            }
            if (this.listenerMap.get((Object)stage).equals(tasks)) continue;
            this.getGenTrans().getLogChannel().logError("Listeners were modified while executing {0}. Started with {1} and ended with {2}", new Object[]{stage, tasks, this.listenerMap.get((Object)stage)});
        }
    }

    public RowProducer addRowProducer() throws KettleException {
        return this.genTrans.addRowProducer(this.sqlTransGenerator.getInjectorStepName(), 0);
    }

    public void waitUntilFinished() {
        this.serviceTrans.waitUntilFinished();
        this.genTrans.waitUntilFinished();
    }

    public TransMeta getServiceTransMeta() {
        return this.serviceTrans.getTransMeta();
    }

    public TransMeta getGenTransMeta() {
        return this.genTrans.getTransMeta();
    }

    public DataServiceMeta getService() {
        return this.service;
    }

    public Trans getServiceTrans() {
        return this.serviceTrans;
    }

    public Trans getGenTrans() {
        return this.genTrans;
    }

    public String getServiceName() {
        return this.sql.getServiceName();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getId() {
        return this.serviceTrans.getContainerObjectId();
    }

    public Boolean hasErrors() {
        return this.serviceTrans.getErrors() > 0 || this.genTrans.getErrors() > 0;
    }

    public static String calculateTransname(SQL sql, boolean isService) {
        StringBuilder sbsql = new StringBuilder(sql.getServiceName());
        sbsql.append(" - ");
        if (isService) {
            sbsql.append("Service");
        } else {
            sbsql.append("SQL");
        }
        sbsql.append(" - ");
        sbsql.append(sql.getSqlString().hashCode());
        for (int i = sbsql.length() - 1; i >= 0; --i) {
            if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
            sbsql.setCharAt(i, ' ');
        }
        return sbsql.toString();
    }

    public void stop() {
        if (this.serviceTrans.isRunning()) {
            this.serviceTrans.stopAll();
        }
        if (this.genTrans.isRunning()) {
            this.genTrans.stopAll();
        }
    }

    public boolean isStopped() {
        return this.genTrans.isStopped();
    }

    public SQL getSql() {
        return this.sql;
    }

    public String getResultStepName() {
        return this.sqlTransGenerator.getResultStepName();
    }

    public int getRowLimit() {
        return this.sqlTransGenerator.getRowLimit();
    }

    public int getServiceRowLimit() {
        return this.sqlTransGenerator.getServiceRowLimit();
    }

    public ListMultimap<ExecutionPoint, Runnable> getListenerMap() {
        return this.listenerMap;
    }

    public static enum ExecutionPoint {
        PREPARE,
        OPTIMIZE,
        READY,
        START;

    }

    public static class Builder {
        private final SQL sql;
        private final DataServiceMeta service;
        private final DataServiceContext context;
        private Trans serviceTrans;
        private Trans genTrans;
        private int rowLimit = 0;
        private Map<String, String> parameters = Collections.emptyMap();
        private LogLevel logLevel;
        private SqlTransGenerator sqlTransGenerator;
        private boolean normalizeConditions = true;
        private boolean prepareExecution = true;
        private boolean enableMetrics = false;
        private IMetaStore metastore;
        private BiConsumer<String, TransMeta> transMutator = (stepName, transMeta) -> TransMutators.disableAllUnrelatedHops(stepName, transMeta, true);

        public Builder(SQL sql, DataServiceMeta service, DataServiceContext context) {
            this.sql = (SQL)Preconditions.checkNotNull((Object)sql, (Object)"SQL must not be null.");
            this.service = (DataServiceMeta)Preconditions.checkNotNull((Object)service, (Object)"Service must not be null.");
            this.context = context;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder rowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder metastore(IMetaStore metastore) {
            this.metastore = metastore;
            return this;
        }

        public Builder serviceTrans(Trans serviceTrans) {
            this.serviceTrans = serviceTrans;
            return this;
        }

        Builder serviceTransMutator(BiConsumer<String, TransMeta> transMutator) {
            this.transMutator = transMutator;
            return this;
        }

        public Builder serviceTrans(TransMeta serviceTransMeta) {
            serviceTransMeta = (TransMeta)serviceTransMeta.realClone(false);
            serviceTransMeta.clearNameChangedListeners();
            serviceTransMeta.setName(DataServiceExecutor.calculateTransname(this.sql, true));
            serviceTransMeta.activateParameters();
            this.transMutator.accept(this.service.getStepname(), serviceTransMeta);
            return this.serviceTrans(new Trans(serviceTransMeta));
        }

        public Builder sqlTransGenerator(SqlTransGenerator sqlTransGenerator) {
            this.sqlTransGenerator = sqlTransGenerator;
            return this;
        }

        public Builder genTrans(Trans trans) {
            this.genTrans = trans;
            return this;
        }

        public Builder enableMetrics(boolean enable) {
            this.enableMetrics = enable;
            return this;
        }

        public Builder normalizeConditions(boolean enable) {
            this.normalizeConditions = enable;
            return this;
        }

        public Builder prepareExecution(boolean enable) {
            this.prepareExecution = enable;
            return this;
        }

        public DataServiceExecutor build() throws KettleException {
            RowMetaInterface serviceFields;
            if (this.sql.getServiceName() != null && !this.sql.getServiceName().equals(this.service.getName())) {
                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"DataServiceExecutor.Error.TableNameAndDataServiceNameDifferent", (String[])new String[]{this.sql.getServiceName(), this.service.getName()}));
            }
            if (this.serviceTrans != null) {
                serviceFields = this.serviceTrans.getTransMeta().getStepFields(this.service.getStepname());
            } else if (this.service.getServiceTrans() != null) {
                this.serviceTrans(this.service.getServiceTrans());
                serviceFields = this.serviceTrans.getTransMeta().getStepFields(this.service.getStepname());
            } else {
                serviceFields = new RowMeta();
            }
            ValueMetaResolver resolver = new ValueMetaResolver(serviceFields);
            this.sql.parse(resolver.getRowMeta());
            if (this.normalizeConditions) {
                if (this.sql.getWhereCondition() != null && this.sql.getWhereCondition().getCondition() != null) {
                    DataServiceExecutor.convertCondition(this.sql.getWhereCondition().getCondition(), resolver);
                }
                if (this.sql.getHavingCondition() != null && this.sql.getHavingCondition().getCondition() != null) {
                    DataServiceExecutor.convertCondition(this.sql.getHavingCondition().getCondition(), resolver);
                }
            }
            int serviceRowLimit = this.getServiceRowLimit(this.service);
            if (this.sqlTransGenerator == null) {
                this.sqlTransGenerator = new SqlTransGenerator(this.sql, this.rowLimit, serviceRowLimit);
            }
            if (this.genTrans == null) {
                this.genTrans = new Trans(this.sqlTransGenerator.generateTransMeta());
            }
            this.serviceTrans.setContainerObjectId(UUID.randomUUID().toString());
            this.genTrans.setContainerObjectId(UUID.randomUUID().toString());
            this.serviceTrans.setMetaStore(this.metastore);
            this.genTrans.setMetaStore(this.metastore);
            DataServiceExecutor dataServiceExecutor = new DataServiceExecutor(this);
            this.context.addExecutor(dataServiceExecutor);
            if (this.logLevel != null) {
                dataServiceExecutor.setLogLevel(this.logLevel);
            }
            this.genTrans.setGatheringMetrics(this.enableMetrics);
            if (this.serviceTrans != null) {
                this.serviceTrans.setGatheringMetrics(this.enableMetrics);
            }
            if (this.prepareExecution) {
                dataServiceExecutor.prepareExecution();
            }
            return dataServiceExecutor;
        }

        private int getServiceRowLimit(DataServiceMeta service) throws KettleException {
            if (service.getRowLimit() != null && service.getRowLimit() > 0) {
                return service.getRowLimit();
            }
            if (!service.isUserDefined()) {
                block5: {
                    String limit = this.getKettleProperty(DataServiceExecutor.ROW_LIMIT_PROPERTY);
                    if (!Utils.isEmpty((CharSequence)limit)) {
                        try {
                            return Integer.parseInt(limit);
                        }
                        catch (NumberFormatException e) {
                            if (this.context == null || this.context.getLogChannel() == null) break block5;
                            this.context.getLogChannel().logError(String.format("%s: %s ", DataServiceExecutor.ROW_LIMIT_PROPERTY, e));
                        }
                    }
                }
                return 50000;
            }
            return 0;
        }

        private String getKettleProperty(String propertyName) throws KettleException {
            return System.getProperty(propertyName);
        }
    }
}

