/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdPatBlt
extends MfCmd {
    private static final int RECORD_SIZE = 6;
    private static final int POS_ROP = 0;
    private static final int POS_HEIGHT = 2;
    private static final int POS_WIDTH = 3;
    private static final int POS_Y = 4;
    private static final int POS_X = 5;
    private int rop;
    private int height;
    private int width;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;

    @Override
    public void replay(WmfFile file) {
        switch (this.rop) {
            case 15728673: {
                MfDcState state = file.getCurrentState();
                state.preparePaint();
                Graphics2D g2 = (Graphics2D)file.getGraphics2D().create();
                g2.setPaintMode();
                g2.fill(this.getScaledBounds());
                state.postPaint();
                break;
            }
            case 5898313: {
                MfDcState state = file.getCurrentState();
                state.preparePaint();
                Graphics2D g2 = (Graphics2D)file.getGraphics2D().create();
                g2.setXORMode(g2.getColor());
                g2.fill(this.getScaledBounds());
                state.postPaint();
                break;
            }
            case 0x550009: {
                Graphics2D g2 = (Graphics2D)file.getGraphics2D().create();
                g2.setXORMode(Color.white);
                g2.fill(this.getScaledBounds());
                break;
            }
            case 66: {
                break;
            }
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdPatBlt();
    }

    public int getROP() {
        return this.rop;
    }

    public void setROP(int rop) {
        this.rop = rop;
    }

    @Override
    public void setRecord(MfRecord record) {
        int rop = record.getLongParam(0);
        int height = record.getParam(2);
        int width = record.getParam(3);
        int top = record.getParam(5);
        int left = record.getParam(4);
        this.setBounds(left, top, width, height);
        this.setROP(rop);
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(6);
        record.setParam(0, this.getROP());
        Rectangle bounds = this.getBounds();
        record.setParam(2, bounds.height);
        record.setParam(3, bounds.width);
        record.setParam(4, bounds.y);
        record.setParam(5, bounds.x);
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[PAT_BLT] rop=");
        b.append(this.getROP());
        b.append(" bounds=");
        b.append(this.getBounds());
        return b.toString();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
    }

    @Override
    public int getFunction() {
        return 1565;
    }
}

