/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionGetForSLAJPAExecutor
implements JPAExecutor<WorkflowActionBean> {
    private String wfActionId;

    public WorkflowActionGetForSLAJPAExecutor(String wfActionId) {
        ParamChecker.notNull(wfActionId, "wfActionId");
        this.wfActionId = wfActionId;
    }

    @Override
    public String getName() {
        return "WorkflowActionGetForSLAJPAExecutor";
    }

    @Override
    public WorkflowActionBean execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_ACTION_FOR_SLA");
            q.setParameter("id", (Object)this.wfActionId);
            Object[] obj = (Object[])q.getSingleResult();
            return this.getBeanFromArray(obj);
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private WorkflowActionBean getBeanFromArray(Object[] arr) {
        WorkflowActionBean wab = new WorkflowActionBean();
        if (arr[0] != null) {
            wab.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            wab.setStatus(WorkflowAction.Status.valueOf((String)((String)arr[1])));
        }
        if (arr[2] != null) {
            wab.setStartTime(DateUtils.toDate((Timestamp)arr[2]));
        }
        if (arr[3] != null) {
            wab.setEndTime(DateUtils.toDate((Timestamp)arr[3]));
        }
        return wab;
    }
}

