/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.json.JSONObject;

public class SqoopJsonUtil {
    public static final Log LOG = LogFactory.getLog((String)SqoopJsonUtil.class.getName());

    private SqoopJsonUtil() {
    }

    public static String getJsonStringforMap(Map<String, String> map) {
        JSONObject pathPartMap = new JSONObject(map);
        return pathPartMap.toString();
    }

    public static Map<String, String> getMapforJsonString(String mapJsonStr) {
        if ("".equals(mapJsonStr) || null == mapJsonStr) {
            throw new IllegalArgumentException("Passed Null for map " + mapJsonStr);
        }
        LOG.debug((Object)("Passed mapJsonStr ::" + mapJsonStr + " to parse"));
        HashMap<String, String> partPathMap = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        try {
            partPathMap = (Map)mapper.readValue(mapJsonStr, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return partPathMap;
        }
        catch (JsonParseException e) {
            LOG.error((Object)("JsonParseException:: Illegal json to parse into map :" + mapJsonStr + e.getMessage()));
            throw new IllegalArgumentException("Illegal json to parse into map :" + mapJsonStr + e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            LOG.error((Object)("JsonMappingException:: Illegal json to parse into map :" + mapJsonStr + e.getMessage()));
            throw new IllegalArgumentException("Illegal json to parse into map :" + mapJsonStr + e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while parsing json into map :" + mapJsonStr + e.getMessage()));
            throw new IllegalArgumentException("IOException while parsing json into map :" + mapJsonStr + e.getMessage(), e);
        }
    }

    public static boolean isEmptyJSON(String jsonStr) {
        return null == jsonStr || "".equals(jsonStr) || "{}".equals(jsonStr);
    }
}

