/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.IntWritable;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;
import org.apache.sqoop.lib.SqoopRecord;
import org.codehaus.jackson.map.ObjectMapper;

public class SqoopHCatImportHelper {
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatImportHelper.class.getName());
    private static boolean debugHCatImportMapper = false;
    private InputJobInfo jobInfo;
    private HCatSchema hCatFullTableSchema;
    private int fieldCount;
    private boolean bigDecimalFormatString;
    private LargeObjectLoader lobLoader;
    private HCatSchema partitionSchema = null;
    private HCatSchema dataColsSchema = null;
    private String hiveDelimsReplacement;
    private boolean doHiveDelimsReplacement = false;
    private DelimiterSet hiveDelimiters;
    private String[] staticPartitionKeys;
    private int[] hCatFieldPositions;
    private int colCount;
    private Pattern numberPattern;
    private ObjectMapper mapper;

    public SqoopHCatImportHelper(Configuration conf) throws IOException, InterruptedException {
        String inputJobInfoStr = conf.get("mapreduce.lib.hcat.job.info");
        this.jobInfo = (InputJobInfo)HCatUtil.deserialize((String)inputJobInfoStr);
        this.dataColsSchema = this.jobInfo.getTableInfo().getDataColumns();
        this.partitionSchema = this.jobInfo.getTableInfo().getPartitionColumns();
        StringBuilder storerInfoStr = new StringBuilder(1024);
        StorerInfo storerInfo = this.jobInfo.getTableInfo().getStorerInfo();
        storerInfoStr.append("HCatalog Storer Info : ").append("\n\tHandler = ").append(storerInfo.getStorageHandlerClass()).append("\n\tInput format class = ").append(storerInfo.getIfClass()).append("\n\tOutput format class = ").append(storerInfo.getOfClass()).append("\n\tSerde class = ").append(storerInfo.getSerdeClass());
        Properties storerProperties = storerInfo.getProperties();
        if (!storerProperties.isEmpty()) {
            storerInfoStr.append("\nStorer properties ");
            for (Map.Entry<Object, Object> entry : storerProperties.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                storerInfoStr.append("\n\t").append(key).append('=').append(val);
            }
        }
        storerInfoStr.append("\n");
        LOG.info((Object)storerInfoStr);
        this.hCatFullTableSchema = new HCatSchema(this.dataColsSchema.getFields());
        for (HCatFieldSchema hfs : this.partitionSchema.getFields()) {
            this.hCatFullTableSchema.append(hfs);
        }
        this.fieldCount = this.hCatFullTableSchema.size();
        this.lobLoader = new LargeObjectLoader(conf, new Path(this.jobInfo.getTableInfo().getTableLocation()));
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        debugHCatImportMapper = conf.getBoolean("sqoop.hcat.debug.import.mapper", false);
        IntWritable[] delimChars = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hive.delims.to.replace", IntWritable.class);
        this.hiveDelimiters = new DelimiterSet((char)delimChars[0].get(), (char)delimChars[1].get(), (char)delimChars[2].get(), (char)delimChars[3].get(), delimChars[4].get() == 1);
        this.hiveDelimsReplacement = conf.get("sqoop.hive.delims.replacement");
        if (this.hiveDelimsReplacement == null) {
            this.hiveDelimsReplacement = "";
        }
        this.doHiveDelimsReplacement = Boolean.valueOf(conf.get("sqoop.hive.delims.replacement.enabled"));
        IntWritable[] fPos = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hcat.field.positions", IntWritable.class);
        this.hCatFieldPositions = new int[fPos.length];
        for (int i = 0; i < fPos.length; ++i) {
            this.hCatFieldPositions[i] = fPos[i].get();
        }
        this.numberPattern = Pattern.compile("\\d+");
        this.mapper = new ObjectMapper();
        LOG.debug((Object)("Hive delims replacement enabled : " + this.doHiveDelimsReplacement));
        LOG.debug((Object)("Hive Delimiters : " + this.hiveDelimiters.toString()));
        LOG.debug((Object)("Hive delimiters replacement : " + this.hiveDelimsReplacement));
        this.staticPartitionKeys = conf.getStrings("sqoop.hcat.partition.key");
        String partKeysString = this.staticPartitionKeys == null ? "" : Arrays.toString(this.staticPartitionKeys);
        LOG.debug((Object)("Static partition key used : " + partKeysString));
    }

    public HCatRecord convertToHCatRecord(SqoopRecord sqr) throws IOException, InterruptedException {
        try {
            sqr.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        if (this.colCount == -1) {
            this.colCount = sqr.getFieldMap().size();
        }
        Map<String, Object> fieldMap = sqr.getFieldMap();
        DefaultHCatRecord result = new DefaultHCatRecord(this.fieldCount);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            String hfn = key.toLowerCase();
            boolean skip = false;
            if (this.staticPartitionKeys != null && this.staticPartitionKeys.length > 0) {
                for (int i = 0; i < this.staticPartitionKeys.length; ++i) {
                    if (!this.staticPartitionKeys[i].equals(hfn)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            HCatFieldSchema hfs = null;
            try {
                hfs = this.hCatFullTableSchema.get(hfn);
            }
            catch (Exception e) {
                throw new IOException("Unable to lookup " + hfn + " in the hcat schema");
            }
            if (debugHCatImportMapper) {
                LOG.debug((Object)("SqoopRecordVal: field = " + key + " Val " + val + " of type " + (val == null ? null : val.getClass().getName()) + ", hcattype " + hfs.getTypeString()));
            }
            Object hCatVal = this.toHCat(val, hfs);
            result.set(hfn, this.hCatFullTableSchema, hCatVal);
        }
        return result;
    }

    private Object toHCat(Object val, HCatFieldSchema hfs) throws IOException {
        HCatFieldSchema.Type hfsType = hfs.getType();
        if (val == null) {
            return null;
        }
        Object retVal = null;
        if (hfs.isComplex()) {
            String str;
            Map<?, ?> map = null;
            List<?> struct = null;
            List<?> array = null;
            if (val instanceof Map) {
                map = this.convertJSonMapToHCatMap((Map)val, hfs);
                return map;
            }
            if (val instanceof List) {
                if (hfs.getType() == HCatFieldSchema.Type.ARRAY) {
                    array = this.convertJSonListToHCatArray((List)val, hfs);
                    return array;
                }
                struct = this.convertJSonListToHCatStruct((List)val, hfs);
                return struct;
            }
            if (val instanceof String) {
                str = val.toString();
            } else if (val instanceof ClobRef) {
                ClobRef cr = (ClobRef)val;
                str = cr.isExternal() ? cr.toString() : (String)cr.getData();
            } else {
                return null;
            }
            switch (hfs.getType()) {
                case ARRAY: {
                    array = this.convertJSonStringToHCatArray(str, hfs);
                    return array;
                }
                case MAP: {
                    map = this.convertJSonStringToHCatMap(str, hfs);
                    return map;
                }
                case STRUCT: {
                    struct = this.convertJSonStringToHCatStruct(str, hfs);
                    return struct;
                }
            }
        } else {
            PrimitiveTypeInfo typeInfo = hfs.getTypeInfo();
            if (val instanceof Number) {
                retVal = this.convertNumberToPrimitiveTypes(val, typeInfo);
            } else if (val instanceof Boolean) {
                retVal = this.convertBooleanToPrimitiveTypes(val, typeInfo);
            } else if (val instanceof String) {
                retVal = this.convertStringToPrimitiveTypes(val.toString(), typeInfo);
            } else if (val instanceof java.util.Date) {
                retVal = this.converDateToPrimitiveTypes(val, typeInfo);
            } else if (val instanceof BytesWritable) {
                if (hfsType == HCatFieldSchema.Type.BINARY) {
                    BytesWritable bw = (BytesWritable)val;
                    retVal = bw.getBytes();
                }
            } else if (val instanceof BlobRef) {
                if (hfsType == HCatFieldSchema.Type.BINARY) {
                    BlobRef br = (BlobRef)val;
                    byte[] bytes = br.isExternal() ? br.toString().getBytes() : (byte[])br.getData();
                    retVal = bytes;
                }
            } else if (val instanceof ClobRef) {
                retVal = this.convertClobToPrimitiveTypes(val, typeInfo);
            } else {
                throw new UnsupportedOperationException("Objects of type " + val.getClass().getName() + " are not suported");
            }
            if (retVal == null) {
                LOG.error((Object)("Unable to convert [" + val + "]  of type " + val.getClass().getName() + " to HCatalog type " + hfs.getTypeString()));
            }
        }
        return retVal;
    }

    private Object convertClobToPrimitiveTypes(Object val, PrimitiveTypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory category = typeInfo.getPrimitiveCategory();
        ClobRef cr = (ClobRef)val;
        String s = cr.isExternal() ? cr.toString() : (String)cr.getData();
        switch (category) {
            case STRING: {
                return s;
            }
            case VARCHAR: {
                VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                HiveVarchar hvc = new HiveVarchar(s, vti.getLength());
                return hvc;
            }
            case CHAR: {
                CharTypeInfo cti = (CharTypeInfo)typeInfo;
                HiveChar hc = new HiveChar(s, cti.getLength());
                return hc;
            }
        }
        return null;
    }

    private Object converDateToPrimitiveTypes(Object val, PrimitiveTypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory category = typeInfo.getPrimitiveCategory();
        if (val instanceof Date) {
            Date d = (Date)val;
            switch (category) {
                case DATE: {
                    return d;
                }
                case TIMESTAMP: {
                    return new Timestamp(d.getTime());
                }
                case LONG: {
                    return d.getTime();
                }
                case STRING: {
                    return val.toString();
                }
                case VARCHAR: {
                    VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                    HiveVarchar hvc = new HiveVarchar(val.toString(), vti.getLength());
                    return hvc;
                }
                case CHAR: {
                    CharTypeInfo cti = (CharTypeInfo)typeInfo;
                    HiveChar hChar = new HiveChar(val.toString(), cti.getLength());
                    return hChar;
                }
            }
        } else if (val instanceof Time) {
            Time t = (Time)val;
            switch (category) {
                case DATE: {
                    return new Date(t.getTime());
                }
                case TIMESTAMP: {
                    return new Timestamp(t.getTime());
                }
                case LONG: {
                    return ((Time)val).getTime();
                }
                case STRING: {
                    return val.toString();
                }
                case VARCHAR: {
                    VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                    HiveVarchar hvc = new HiveVarchar(val.toString(), vti.getLength());
                    return hvc;
                }
                case CHAR: {
                    CharTypeInfo cti = (CharTypeInfo)typeInfo;
                    HiveChar hChar = new HiveChar(val.toString(), cti.getLength());
                    return hChar;
                }
            }
        } else if (val instanceof Timestamp) {
            Timestamp ts = (Timestamp)val;
            switch (category) {
                case DATE: {
                    return new Date(ts.getTime());
                }
                case TIMESTAMP: {
                    return ts;
                }
                case LONG: {
                    return ts.getTime();
                }
                case STRING: {
                    return val.toString();
                }
                case VARCHAR: {
                    VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                    HiveVarchar hvc = new HiveVarchar(val.toString(), vti.getLength());
                    return hvc;
                }
                case CHAR: {
                    CharTypeInfo cti = (CharTypeInfo)typeInfo;
                    HiveChar hc = new HiveChar(val.toString(), cti.getLength());
                    return hc;
                }
            }
        }
        return null;
    }

    private Object convertStringToPrimitiveTypes(String str, PrimitiveTypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory category = typeInfo.getPrimitiveCategory();
        switch (category) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                if (this.doHiveDelimsReplacement) {
                    str = FieldFormatter.hiveStringReplaceDelims(str, this.hiveDelimsReplacement, this.hiveDelimiters);
                }
                if (category == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                    return str;
                }
                if (category == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
                    VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                    HiveVarchar hvc = new HiveVarchar(str, vti.getLength());
                    return hvc;
                }
                if (category != PrimitiveObjectInspector.PrimitiveCategory.CHAR) break;
                CharTypeInfo cti = (CharTypeInfo)typeInfo;
                HiveChar hc = new HiveChar(str, cti.getLength());
                return hc;
            }
            case DECIMAL: {
                DecimalTypeInfo dti = (DecimalTypeInfo)typeInfo;
                BigDecimal bd = new BigDecimal(str, new MathContext(dti.precision(), RoundingMode.HALF_UP));
                bd.setScale(dti.scale(), 4);
                return HiveDecimal.create((BigDecimal)bd);
            }
            case BYTE: {
                Byte b = Byte.valueOf(str);
                return b;
            }
            case SHORT: {
                Short s = Short.valueOf(str);
                return s;
            }
            case INT: {
                Integer i = Integer.valueOf(str);
                return i;
            }
            case LONG: {
                Long l = Long.valueOf(str);
                return l;
            }
            case FLOAT: {
                Float f = Float.valueOf(str);
                return f;
            }
            case DOUBLE: {
                Double d = Double.valueOf(str);
                return d;
            }
            case DATE: {
                Matcher m = this.numberPattern.matcher(str);
                Date dt = null;
                if (m.matches()) {
                    Long l1 = Long.valueOf(str);
                    dt = new Date(l1);
                } else {
                    dt = Date.valueOf(str);
                }
                return dt;
            }
            case TIMESTAMP: {
                Matcher m2 = this.numberPattern.matcher(str);
                Timestamp ts = null;
                if (m2.matches()) {
                    Long l2 = Long.valueOf(str);
                    ts = new Timestamp(l2);
                } else {
                    ts = Timestamp.valueOf(str);
                }
                return ts;
            }
            case BOOLEAN: {
                Boolean bool = Boolean.valueOf(str);
                return bool;
            }
        }
        return null;
    }

    private List<?> convertJSonListToHCatArray(List<?> arrayVals, HCatFieldSchema hfs) {
        try {
            HCatSchema arraySchema = hfs.getArrayElementSchema();
            HCatFieldSchema elementSchema = (HCatFieldSchema)arraySchema.getFields().get(0);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object elemVal : arrayVals) {
                LOG.debug((Object)("Converting " + elemVal + " of type " + elemVal.getClass().getName() + " to " + elementSchema.getTypeString()));
                result.add(this.toHCat(elemVal, elementSchema));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to convert [" + arrayVals + "]  of type " + arrayVals.getClass().getName() + " to HCatalog type " + hfs.getTypeString()), (Throwable)e);
            return null;
        }
    }

    private List<?> convertJSonStringToHCatArray(Object obj, HCatFieldSchema hfs) throws IOException {
        LOG.debug((Object)("Converting " + obj + " to " + hfs.getTypeString()));
        List arrayVals = (List)this.mapper.readValue(obj.toString(), List.class);
        return this.convertJSonListToHCatArray(arrayVals, hfs);
    }

    private Map<?, ?> convertJSonMapToHCatMap(Map<?, ?> mapVals, HCatFieldSchema hfs) {
        LOG.debug((Object)("Converting " + mapVals + " to " + hfs.getTypeString()));
        try {
            HCatFieldSchema valueSchema = (HCatFieldSchema)hfs.getMapValueSchema().getFields().get(0);
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry<?, ?> e : mapVals.entrySet()) {
                LOG.debug((Object)("Converting " + e.getKey() + " of type " + e.getKey().getClass().getName() + " to " + hfs.getTypeString()));
                Object key = this.toHCat(e.getKey(), new HCatFieldSchema("_col", hfs.getMapKeyTypeInfo(), ""));
                LOG.debug((Object)("Converting " + e.getValue() + " of type " + e.getValue().getClass().getName() + " to " + valueSchema.getTypeString()));
                Object val = this.toHCat(e.getValue(), valueSchema);
                result.put(key, val);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to convert [" + mapVals + "]  of type " + mapVals.getClass().getName() + " to HCatalog type " + hfs.getTypeString()), (Throwable)e);
            LOG.debug((Object)e);
            return null;
        }
    }

    private Map<?, ?> convertJSonStringToHCatMap(Object obj, HCatFieldSchema hfs) throws IOException {
        LOG.debug((Object)("Converting " + obj + " to " + hfs.getTypeString()));
        Map mapVals = (Map)this.mapper.readValue(obj.toString(), Map.class);
        return this.convertJSonMapToHCatMap(mapVals, hfs);
    }

    private List<?> convertJSonListToHCatStruct(List<?> structVals, HCatFieldSchema hfs) {
        try {
            HCatSchema structSchema = hfs.getStructSubSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            if (structVals.size() != structSchema.getFields().size()) {
                LOG.error((Object)("Cannot  convert [" + structVals + "]  of type " + structVals.getClass().getName() + " to HCatalog type " + hfs.getTypeString() + ". Size mismatch"));
            }
            for (int i = 0; i < structVals.size(); ++i) {
                LOG.debug((Object)("Converting " + structVals.get(i) + " of type " + structVals.get(i).getClass().getName() + " to " + ((HCatFieldSchema)structSchema.getFields().get(i)).getTypeString()));
                Object val = this.toHCat(structVals.get(i), (HCatFieldSchema)structSchema.getFields().get(i));
                result.add(val);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to convert [" + structVals + "]  of type " + structVals.getClass().getName() + " to HCatalog type " + hfs.getTypeString()), (Throwable)e);
            return null;
        }
    }

    private List<?> convertJSonStringToHCatStruct(Object obj, HCatFieldSchema hfs) throws IOException {
        LOG.debug((Object)("Converting " + obj + " to " + hfs.getTypeString()));
        List structVals = (List)this.mapper.readValue(obj.toString(), List.class);
        return this.convertJSonListToHCatStruct(structVals, hfs);
    }

    private Object convertBooleanToPrimitiveTypes(Object val, PrimitiveTypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory category = typeInfo.getPrimitiveCategory();
        Boolean b = (Boolean)val;
        switch (category) {
            case BOOLEAN: {
                return b;
            }
            case BYTE: {
                return (byte)(b != false ? 1 : 0);
            }
            case SHORT: {
                return (short)(b != false ? 1 : 0);
            }
            case INT: {
                return b != false ? 1 : 0;
            }
            case LONG: {
                return (long)(b != false ? 1 : 0);
            }
            case FLOAT: {
                return Float.valueOf(b != false ? 1 : 0);
            }
            case DOUBLE: {
                return (double)(b != false ? 1 : 0);
            }
            case STRING: {
                return val.toString();
            }
            case VARCHAR: {
                VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                HiveVarchar hvc = new HiveVarchar(val.toString(), vti.getLength());
                return hvc;
            }
            case CHAR: {
                CharTypeInfo cti = (CharTypeInfo)typeInfo;
                HiveChar hChar = new HiveChar(val.toString(), cti.getLength());
                return hChar;
            }
        }
        return null;
    }

    private Object convertNumberToPrimitiveTypes(Object val, PrimitiveTypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory category = typeInfo.getPrimitiveCategory();
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof BigDecimal && category == PrimitiveObjectInspector.PrimitiveCategory.STRING || category == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR || category == PrimitiveObjectInspector.PrimitiveCategory.CHAR) {
            BigDecimal bd = (BigDecimal)val;
            String bdStr = null;
            bdStr = this.bigDecimalFormatString ? bd.toPlainString() : bd.toString();
            if (category == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
                VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                HiveVarchar hvc = new HiveVarchar(bdStr, vti.getLength());
                return hvc;
            }
            if (category == PrimitiveObjectInspector.PrimitiveCategory.CHAR) {
                CharTypeInfo cti = (CharTypeInfo)typeInfo;
                HiveChar hChar = new HiveChar(bdStr, cti.getLength());
                return hChar;
            }
            return bdStr;
        }
        Number n = (Number)val;
        switch (category) {
            case BYTE: {
                return n.byteValue();
            }
            case SHORT: {
                return n.shortValue();
            }
            case INT: {
                return n.intValue();
            }
            case LONG: {
                return n.longValue();
            }
            case FLOAT: {
                return Float.valueOf(n.floatValue());
            }
            case DOUBLE: {
                return n.doubleValue();
            }
            case BOOLEAN: {
                return n.byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case STRING: {
                return n.toString();
            }
            case VARCHAR: {
                VarcharTypeInfo vti = (VarcharTypeInfo)typeInfo;
                HiveVarchar hvc = new HiveVarchar(val.toString(), vti.getLength());
                return hvc;
            }
            case CHAR: {
                CharTypeInfo cti = (CharTypeInfo)typeInfo;
                HiveChar hChar = new HiveChar(val.toString(), cti.getLength());
                return hChar;
            }
            case DECIMAL: {
                DecimalTypeInfo dti = (DecimalTypeInfo)typeInfo;
                BigDecimal bd = new BigDecimal(n.doubleValue(), new MathContext(dti.precision(), RoundingMode.HALF_UP));
                bd.setScale(dti.scale(), 4);
                return HiveDecimal.create((BigDecimal)bd);
            }
        }
        return null;
    }

    public void cleanup() throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }
}

