/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.app.command;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.pentaho.pdi.engine.daemon.app.service.HdfsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="pdi", name="install", description="Install PDI Client:  Extracts PDI spark assembly to HDFS")
public class InstallCommand
implements Action {
    private static Logger LOG = LoggerFactory.getLogger(InstallCommand.class);
    @Argument(index=0, name="source", required=false, multiValued=false, description="Local location of PDI client zip file. (ie, /opt/my/client/pdi-ee-client-7.1.zip)")
    private String sourceZip = "";
    @Argument(index=1, name="destination", required=false, multiValued=false, description="Location on HDFS where client will be unzipped. (ie, /org/pentaho)")
    private String destinationFolder = "";
    @Reference
    private HdfsService hdfsService;

    public Object execute() throws Exception {
        LOG.trace("execute()");
        LOG.info("PDI Installation:");
        LOG.info("  - Source Zip:         {}", (Object)this.sourceZip);
        LOG.info("  - Destination Folder: {}", (Object)this.destinationFolder);
        try {
            this.hdfsService.copyFromLocalFile(this.sourceZip, this.destinationFolder);
            return "PDI Install Complete";
        }
        catch (Exception e) {
            LOG.info("Unexpected error trying to extract PDI Client to HDFS.", (Throwable)e);
            return "Error occurred trying to delete folder.  Please look at the log for more information.";
        }
    }
}

