/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import org.apache.oozie.AppType;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.XLog;

public class LogUtils {
    public static void setLogInfo(CoordinatorJobBean cBean) {
        XLog.Info.get().setParameter("GROUP", cBean.getGroup());
        XLog.Info.get().setParameter("USER", cBean.getUser());
        XLog.Info.get().setParameter("JOB", cBean.getId());
        XLog.Info.get().setParameter("TOKEN", "");
        XLog.Info.get().setParameter("APP", cBean.getAppName());
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(CoordinatorActionBean action) {
        XLog.Info.get().setParameter("JOB", action.getJobId());
        XLog.Info.get().setParameter("ACTION", action.getId());
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(WorkflowJobBean workflow) {
        XLog.Info.get().setParameter("GROUP", workflow.getGroup());
        XLog.Info.get().setParameter("USER", workflow.getUser());
        XLog.Info.get().setParameter("JOB", workflow.getId());
        XLog.Info.get().setParameter("TOKEN", workflow.getLogToken());
        XLog.Info.get().setParameter("APP", workflow.getAppName());
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(WorkflowActionBean action) {
        XLog.Info.get().setParameter("JOB", action.getJobId());
        XLog.Info.get().setParameter("TOKEN", action.getLogToken());
        XLog.Info.get().setParameter("ACTION", action.getId());
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(WorkflowAction action) {
        String actionId = action.getId();
        XLog.Info.get().setParameter("JOB", actionId.substring(0, actionId.indexOf("@")));
        XLog.Info.get().setParameter("ACTION", actionId);
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(String id) {
        if (id.contains("@")) {
            String jobId = id.substring(0, id.indexOf("@"));
            XLog.Info.get().setParameter("JOB", jobId);
            XLog.Info.get().setParameter("ACTION", id);
        } else {
            XLog.Info.get().setParameter("JOB", id);
            XLog.Info.get().setParameter("ACTION", "");
        }
        XLog.Info.get().resetPrefix();
    }

    public static void setLogInfo(BundleJobBean bBean) {
        XLog.Info.get().setParameter("GROUP", bBean.getGroup());
        XLog.Info.get().setParameter("USER", bBean.getUser());
        XLog.Info.get().setParameter("JOB", bBean.getId());
        XLog.Info.get().setParameter("TOKEN", "");
        XLog.Info.get().setParameter("APP", bBean.getAppName());
        XLog.Info.get().resetPrefix();
    }

    public static XLog setLogInfo(XLog logObj, String jobId, String actionId, String appName) {
        LogUtils.clearLogPrefix();
        XLog.Info logInfo = XLog.Info.get();
        logInfo.setParameter("JOB", jobId);
        if (actionId != null) {
            logInfo.setParameter("ACTION", actionId);
        }
        if (appName != null) {
            logInfo.setParameter("APP", appName);
        }
        return XLog.resetPrefix(logObj);
    }

    public static XLog setLogPrefix(XLog logObj, Event event) {
        String jobId = null;
        String actionId = null;
        String appName = null;
        if (event instanceof JobEvent) {
            JobEvent je = (JobEvent)event;
            if (je.getAppType() == AppType.WORKFLOW_JOB || je.getAppType() == AppType.COORDINATOR_JOB || je.getAppType() == AppType.BUNDLE_JOB) {
                jobId = je.getId();
            } else {
                actionId = je.getId();
                jobId = Services.get().get(UUIDService.class).getId(actionId);
            }
            appName = je.getAppName();
        } else if (event instanceof SLAEvent) {
            SLAEvent se = (SLAEvent)event;
            if (se.getAppType() == AppType.WORKFLOW_JOB || se.getAppType() == AppType.COORDINATOR_JOB || se.getAppType() == AppType.BUNDLE_JOB) {
                jobId = se.getId();
            } else {
                actionId = se.getId();
                jobId = Services.get().get(UUIDService.class).getId(actionId);
            }
            appName = se.getAppName();
        }
        return LogUtils.setLogInfo(logObj, jobId, actionId, appName);
    }

    public static void clearLogPrefix() {
        XLog.Info.get().clearParameter("JOB");
        XLog.Info.get().clearParameter("ACTION");
        XLog.Info.get().clearParameter("APP");
    }
}

