/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.SLAAlertsXCommand;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class CoordSLAAlertsXCommand
extends SLAAlertsXCommand {
    private String scope;
    private String dates;
    private List<String> actionIds;

    @Override
    protected void loadState() throws CommandException {
        this.actionIds = this.getActionListForScopeAndDate(this.getJobId(), this.scope, this.dates);
    }

    public CoordSLAAlertsXCommand(String jobId, String name, String type, String actions, String dates) {
        super(jobId, name, type);
        this.scope = actions;
        this.dates = dates;
    }

    protected void updateJobConf(Configuration newConf) throws CommandException {
        try {
            CoordinatorJobBean job = new CoordinatorJobBean();
            XConfiguration conf = null;
            conf = this.getJobConf();
            XConfiguration.copy(newConf, conf);
            job.setId(this.getJobId());
            job.setConf(XmlUtils.prettyPrint(conf).toString());
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CONF, job);
        }
        catch (XException e) {
            throw new CommandException(e);
        }
    }

    protected void updateJobSLA(Map<String, String> newParams) throws CommandException {
        try {
            Element eAction;
            CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_XML, this.getJobId());
            try {
                eAction = XmlUtils.parseXml(job.getJobXml());
            }
            catch (JDOMException e) {
                throw new CommandException(ErrorCode.E1005, new Object[]{e.getMessage(), e});
            }
            Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
            if (newParams != null) {
                if (newParams.get("sla-nominal-time") != null) {
                    this.updateSlaTagElement(eSla, "nominal-time", newParams.get("sla-nominal-time"));
                }
                if (newParams.get("sla-should-start") != null) {
                    this.updateSlaTagElement(eSla, "should-start", newParams.get("sla-should-start"));
                }
                if (newParams.get("sla-should-end") != null) {
                    this.updateSlaTagElement(eSla, "should-end", newParams.get("sla-should-end"));
                }
                if (newParams.get("sla-max-duration") != null) {
                    this.updateSlaTagElement(eSla, "max-duration", newParams.get("sla-max-duration"));
                }
            }
            String actualXml = XmlUtils.prettyPrint(eAction).toString();
            job.setJobXml(actualXml);
            job.setId(this.getJobId());
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_XML, job);
        }
        catch (XException e) {
            throw new CommandException(e);
        }
    }

    protected String getActionDateListAsString() {
        StringBuffer bf = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.dates)) {
            bf.append(this.dates);
        }
        if (!StringUtils.isEmpty((String)this.scope)) {
            if (!StringUtils.isEmpty((String)bf.toString())) {
                bf.append(",");
            }
            bf.append(this.scope);
        }
        return bf.toString();
    }

    private List<String> getActionListForScopeAndDate(String id, String scope, String dates) throws CommandException {
        ArrayList<String> actionIds = new ArrayList<String>();
        if (scope == null && dates == null) {
            return null;
        }
        ArrayList<String> parsed = new ArrayList<String>();
        if (dates != null) {
            List<CoordinatorActionBean> actionSet = CoordUtils.getCoordActionsFromDates(id, dates, true);
            for (CoordinatorActionBean action : actionSet) {
                actionIds.add(action.getId());
            }
            parsed.addAll(actionIds);
        }
        if (scope != null) {
            parsed.addAll(CoordUtils.getActionsIds(id, scope));
        }
        return parsed;
    }

    protected List<String> getActionList() {
        return this.actionIds;
    }

    @Override
    protected boolean isJobRequest() {
        return StringUtils.isEmpty((String)this.dates) && StringUtils.isEmpty((String)this.scope);
    }

    public void updateSlaTagElement(Element elem, String tagName, String value) {
        if (elem != null && elem.getChild(tagName, elem.getNamespace("sla")) != null) {
            elem.getChild(tagName, elem.getNamespace("sla")).setText(value);
        }
    }

    protected XConfiguration getJobConf() throws JPAExecutorException, CommandException {
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_CONF, this.getJobId());
        String jobConf = job.getConf();
        XConfiguration conf = null;
        try {
            conf = new XConfiguration(new StringReader(jobConf));
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E1005, e.getMessage(), e);
        }
        return conf;
    }
}

