/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.XLogFilter;

public abstract class BaseEngine {
    public static final String USE_XCOMMAND = "oozie.useXCommand";
    protected String user;

    public String getUser() {
        return this.user;
    }

    public abstract String submitJob(Configuration var1, boolean var2) throws BaseEngineException;

    public abstract void start(String var1) throws BaseEngineException;

    public abstract void resume(String var1) throws BaseEngineException;

    public abstract void suspend(String var1) throws BaseEngineException;

    public abstract void kill(String var1) throws BaseEngineException;

    public abstract void change(String var1, String var2) throws BaseEngineException;

    public abstract void reRun(String var1, Configuration var2) throws BaseEngineException;

    public abstract WorkflowJob getJob(String var1) throws BaseEngineException;

    public abstract WorkflowJob getJob(String var1, int var2, int var3) throws BaseEngineException;

    public abstract CoordinatorJob getCoordJob(String var1) throws BaseEngineException;

    public abstract CoordinatorJob getCoordJob(String var1, String var2, int var3, int var4, boolean var5) throws BaseEngineException;

    public abstract String getDefinition(String var1) throws BaseEngineException;

    public abstract void streamLog(String var1, Writer var2, Map<String, String[]> var3) throws IOException, BaseEngineException;

    public abstract void streamErrorLog(String var1, Writer var2, Map<String, String[]> var3) throws IOException, BaseEngineException;

    public abstract void streamAuditLog(String var1, Writer var2, Map<String, String[]> var3) throws IOException, BaseEngineException;

    public abstract String getJobIdForExternalId(String var1) throws BaseEngineException;

    public abstract String dryRunSubmit(Configuration var1) throws BaseEngineException;

    public String getJMSTopicName(String jobId) throws DagEngineException {
        JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
        if (jmsTopicService != null) {
            try {
                return jmsTopicService.getTopic(jobId);
            }
            catch (JPAExecutorException e) {
                throw new DagEngineException(ErrorCode.E1602, e);
            }
        }
        throw new DagEngineException(ErrorCode.E1602, "JMSTopicService is not initialized. JMS notificationmay not be enabled");
    }

    public abstract String getJobStatus(String var1) throws BaseEngineException;

    public abstract void enableSLAAlert(String var1, String var2, String var3, String var4) throws BaseEngineException;

    public abstract void disableSLAAlert(String var1, String var2, String var3, String var4) throws BaseEngineException;

    public abstract void changeSLA(String var1, String var2, String var3, String var4, String var5) throws BaseEngineException;

    protected void fetchLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params, LOG_TYPE logType) throws IOException {
        switch (logType) {
            case LOG: {
                Services.get().get(XLogStreamingService.class).streamLog(filter, startTime, endTime, writer, params);
                break;
            }
            case ERROR_LOG: {
                Services.get().get(XLogStreamingService.class).streamErrorLog(filter, startTime, endTime, writer, params);
                break;
            }
            case AUDIT_LOG: {
                Services.get().get(XLogStreamingService.class).streamAuditLog(filter, startTime, endTime, writer, params);
                break;
            }
            default: {
                throw new IOException("Unsupported log Type");
            }
        }
    }

    public static enum LOG_TYPE {
        LOG,
        ERROR_LOG,
        AUDIT_LOG;

    }
}

