/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.metainfo.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateOpTraitsProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class OpTraitsRulesProcFactory {
    public static NodeProcessor getTableScanRule() {
        return new TableScanRule();
    }

    public static NodeProcessor getReduceSinkRule() {
        return new ReduceSinkRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultRule();
    }

    public static NodeProcessor getMultiParentRule() {
        return new MultiParentRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinRule();
    }

    public static class MultiParentRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            OpTraits opTraits = new OpTraits(null, -1, null);
            Operator operator = (Operator)nd;
            operator.setOpTraits(opTraits);
            return null;
        }
    }

    public static class JoinRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<List<String>> sortColsList = new ArrayList<List<String>>();
            byte pos = 0;
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                if (!(parentOp instanceof ReduceSinkOperator)) break;
                ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
                if (rsOp.getOpTraits() == null) {
                    ReduceSinkRule rsRule = new ReduceSinkRule();
                    rsRule.process(rsOp, stack, procCtx, nodeOutputs);
                }
                bucketColsList.add(this.getOutputColNames(joinOp, rsOp.getOpTraits().getBucketColNames(), pos));
                sortColsList.add(this.getOutputColNames(joinOp, rsOp.getOpTraits().getSortCols(), pos));
                pos = (byte)(pos + 1);
            }
            joinOp.setOpTraits(new OpTraits(bucketColsList, -1, bucketColsList));
            return null;
        }

        private List<String> getOutputColNames(JoinOperator joinOp, List<List<String>> parentColNames, byte pos) {
            if (parentColNames != null) {
                ArrayList<String> bucketColNames = new ArrayList<String>();
                List<String> colNames = parentColNames.get(0);
                block0: for (String colName : colNames) {
                    for (ExprNodeDesc exprNode : ((JoinDesc)joinOp.getConf()).getExprs().get(pos)) {
                        if (!(exprNode instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)exprNode).getColumn().equals(colName)) continue;
                        for (Map.Entry<String, ExprNodeDesc> entry : joinOp.getColumnExprMap().entrySet()) {
                            if (!entry.getValue().isSame(exprNode)) continue;
                            bucketColNames.add(entry.getKey());
                            continue block0;
                        }
                        continue block0;
                    }
                }
                return bucketColNames;
            }
            return null;
        }
    }

    public static class SelectRule
    implements NodeProcessor {
        public List<List<String>> getConvertedColNames(List<List<String>> parentColNames, SelectOperator selOp) {
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            if (selOp.getColumnExprMap() != null && parentColNames != null) {
                for (List<String> colNames : parentColNames) {
                    ArrayList<String> bucketColNames = new ArrayList<String>();
                    for (String colName : colNames) {
                        for (Map.Entry<String, ExprNodeDesc> entry : selOp.getColumnExprMap().entrySet()) {
                            if (!(entry.getValue() instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)entry.getValue()).getColumn().equals(colName)) continue;
                            bucketColNames.add(entry.getKey());
                        }
                    }
                    listBucketCols.add(bucketColNames);
                }
            }
            return listBucketCols;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator selOp = (SelectOperator)nd;
            List<List<String>> parentBucketColNames = selOp.getParentOperators().get(0).getOpTraits().getBucketColNames();
            List<List<String>> listBucketCols = null;
            List<List<String>> listSortCols = null;
            if (selOp.getColumnExprMap() != null) {
                List<List<String>> parentSortColNames;
                if (parentBucketColNames != null) {
                    listBucketCols = this.getConvertedColNames(parentBucketColNames, selOp);
                }
                if ((parentSortColNames = selOp.getParentOperators().get(0).getOpTraits().getSortCols()) != null) {
                    listSortCols = this.getConvertedColNames(parentSortColNames, selOp);
                }
            }
            int numBuckets = -1;
            if (selOp.getParentOperators().get(0).getOpTraits() != null) {
                numBuckets = selOp.getParentOperators().get(0).getOpTraits().getNumBuckets();
            }
            OpTraits opTraits = new OpTraits(listBucketCols, numBuckets, listSortCols);
            selOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class GroupByRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator gbyOp = (GroupByOperator)nd;
            ArrayList<String> gbyKeys = new ArrayList<String>();
            for (ExprNodeDesc exprDesc : ((GroupByDesc)gbyOp.getConf()).getKeys()) {
                for (Map.Entry<String, ExprNodeDesc> entry : gbyOp.getColumnExprMap().entrySet()) {
                    if (!exprDesc.isSame(entry.getValue())) continue;
                    gbyKeys.add(entry.getKey());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            listBucketCols.add(gbyKeys);
            OpTraits opTraits = new OpTraits(listBucketCols, -1, listBucketCols);
            gbyOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class TableScanRule
    implements NodeProcessor {
        public boolean checkBucketedTable(Table tbl, ParseContext pGraphContext, PrunedPartitionList prunedParts) throws SemanticException {
            if (tbl.isPartitioned()) {
                List<Partition> partitions = prunedParts.getNotDeniedPartns();
                if (!partitions.isEmpty()) {
                    for (Partition p : partitions) {
                        List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(p.getDataLocation(), pGraphContext);
                        int bucketCount = p.getBucketCount();
                        if (fileNames.size() == 0 || fileNames.size() == bucketCount) continue;
                        return false;
                    }
                }
            } else {
                List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(tbl.getDataLocation(), pGraphContext);
                Integer num = new Integer(tbl.getNumBuckets());
                if (fileNames.size() != 0 && fileNames.size() != num.intValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator ts = (TableScanOperator)nd;
            AnnotateOpTraitsProcCtx opTraitsCtx = (AnnotateOpTraitsProcCtx)procCtx;
            Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
            PrunedPartitionList prunedPartList = null;
            try {
                prunedPartList = opTraitsCtx.getParseContext().getPrunedPartitions(((TableScanDesc)ts.getConf()).getAlias(), ts);
            }
            catch (HiveException e) {
                prunedPartList = null;
            }
            boolean isBucketed = this.checkBucketedTable(table, opTraitsCtx.getParseContext(), prunedPartList);
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<List<String>> sortedColsList = new ArrayList<List<String>>();
            int numBuckets = -1;
            if (isBucketed) {
                bucketColsList.add(table.getBucketCols());
                numBuckets = table.getNumBuckets();
                ArrayList<String> sortCols = new ArrayList<String>();
                for (Order colSortOrder : table.getSortCols()) {
                    sortCols.add(colSortOrder.getCol());
                }
                sortedColsList.add(sortCols);
            }
            OpTraits opTraits = new OpTraits(bucketColsList, numBuckets, sortedColsList);
            ts.setOpTraits(opTraits);
            return null;
        }
    }

    public static class ReduceSinkRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rs = (ReduceSinkOperator)nd;
            ArrayList<String> bucketCols = new ArrayList<String>();
            if (rs.getColumnExprMap() != null) {
                for (ExprNodeDesc exprDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                    for (Map.Entry<String, ExprNodeDesc> entry : rs.getColumnExprMap().entrySet()) {
                        if (!exprDesc.isSame(entry.getValue())) continue;
                        bucketCols.add(entry.getKey());
                    }
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            listBucketCols.add(bucketCols);
            int numBuckets = -1;
            OpTraits parentOpTraits = rs.getParentOperators().get(0).getConf().getOpTraits();
            if (parentOpTraits != null) {
                numBuckets = parentOpTraits.getNumBuckets();
            }
            OpTraits opTraits = new OpTraits(listBucketCols, numBuckets, listBucketCols);
            rs.setOpTraits(opTraits);
            return null;
        }
    }

    public static class DefaultRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            op.setOpTraits(op.getParentOperators().get(0).getOpTraits());
            return null;
        }
    }
}

