/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.objecttunnel;

import io.reactivex.processors.PublishProcessor;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.pentaho.osgi.objecttunnel.TunnelMarker;
import org.pentaho.osgi.objecttunnel.TunnelSerializer;
import org.pentaho.osgi.objecttunnel.TunneledInputObject;
import org.pentaho.osgi.objecttunnel.TunneledPayload;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class TunnelInput
implements Publisher<TunneledInputObject>,
AutoCloseable {
    private ObjectInputStream input;
    private Map<String, TunnelSerializer> serializerMap = new HashMap<String, TunnelSerializer>();
    private List<Subscriber<? super TunneledInputObject>> subscribers = new ArrayList<Subscriber<? super TunneledInputObject>>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile int errorThreshold = 5;
    private volatile int errorCount = 0;
    private PublishProcessor<TunneledInputObject> publishProcessor = PublishProcessor.create();
    private int error_dampening_millis = 300;

    public TunnelInput(ObjectInputStream input, Map<Class, TunnelSerializer> rawSerializerMap) {
        this.input = input;
        rawSerializerMap.entrySet().forEach(entry -> this.serializerMap.put(((Class)entry.getKey()).getName(), (TunnelSerializer)entry.getValue()));
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
        this.input.close();
        this.publishProcessor.onComplete();
    }

    int getErrorCount() {
        return this.errorCount;
    }

    public void setDampeningMillis(int millis) {
        this.error_dampening_millis = millis;
    }

    public void setErrorThreshold(int errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    void setDeserializer(Class clazz, final Function<String, Object> func) {
        this.serializerMap.put(clazz.getName(), new TunnelSerializer(){

            @Override
            public List<Class> getSupportedClasses() {
                return null;
            }

            @Override
            public String serialize(Object object) {
                return null;
            }

            public Object deserialize(String serializedString) {
                return func.apply(serializedString);
            }
        });
    }

    public void open() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        Executors.newSingleThreadExecutor().submit(() -> {
            while (!this.closed.get() && this.errorCount < this.errorThreshold) {
                Exception capturedException;
                block11: {
                    capturedException = null;
                    try {
                        Object object = this.input.readObject();
                        if (object instanceof TunneledPayload) {
                            this.processTunneledPayload((TunneledPayload)object);
                            break block11;
                        }
                        if (object == TunnelMarker.END) {
                            this.close();
                            return;
                        }
                        if (object instanceof String) {
                            String str = object.toString();
                            if (str.startsWith("Error: ")) {
                                this.publishProcessor.onError((Throwable)new Exception(str){

                                    @Override
                                    public synchronized Throwable fillInStackTrace() {
                                        return this;
                                    }
                                });
                            }
                            break block11;
                        }
                        throw new IllegalStateException("Unexpected object in stream: " + object.toString());
                    }
                    catch (Exception e) {
                        ++this.errorCount;
                        try {
                            Thread.sleep(this.error_dampening_millis);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        capturedException = e;
                    }
                }
                if (this.errorCount != this.errorThreshold) continue;
                try {
                    this.publishProcessor.onError((Throwable)capturedException);
                    this.close();
                }
                catch (Exception exception) {}
            }
        });
    }

    private void processTunneledPayload(TunneledPayload payload) {
        String type = payload.getType();
        if (this.serializerMap.containsKey(type)) {
            Object unmarshalled = this.serializerMap.get(type).deserialize(payload.getObjectStr());
            this.publishProcessor.onNext((Object)new TunneledInputObject(type, unmarshalled));
        }
        this.errorCount = 0;
    }

    public void subscribe(Subscriber<? super TunneledInputObject> s) {
        if (this.closed.get()) {
            throw new IllegalStateException("TunnelInput has been closed");
        }
        this.publishProcessor.subscribe(s);
    }
}

