/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.examples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.v22.message.ACK;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.parser.PipeParser;
import java.io.IOException;

public class ExampleReceiverApplication
implements Application {
    public boolean canProcess(Message theIn) {
        return true;
    }

    public Message processMessage(Message theIn) throws ApplicationException, HL7Exception {
        ACK retVal;
        String encodedMessage = new PipeParser().encode(theIn);
        System.out.println("Received message:\n" + encodedMessage + "\n\n");
        MSH msh = (MSH)theIn.get("MSH");
        try {
            retVal = (ACK)DefaultApplication.makeACK((Segment)msh);
        }
        catch (IOException e) {
            throw new HL7Exception((Throwable)e);
        }
        return retVal;
    }
}

