/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.fileinput;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.fileinput.NonAccessibleFileObject;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;

public class FileInputList {
    private List<FileObject> files = new ArrayList<FileObject>();
    private List<FileObject> nonExistantFiles = new ArrayList<FileObject>(1);
    private List<FileObject> nonAccessibleFiles = new ArrayList<FileObject>(1);
    private static LogChannelInterface log = new LogChannel("FileInputList");
    private static final String YES = "Y";

    public static String getRequiredFilesDescription(List<FileObject> nonExistantFiles) {
        StringBuilder buffer = new StringBuilder();
        for (FileObject file : nonExistantFiles) {
            buffer.append(file.getName().getURI());
            buffer.append(Const.CR);
        }
        return buffer.toString();
    }

    private static boolean[] includeSubdirsFalse(int iLength) {
        boolean[] includeSubdirs = new boolean[iLength];
        for (int i = 0; i < iLength; ++i) {
            includeSubdirs[i] = false;
        }
        return includeSubdirs;
    }

    public static String[] createFilePathList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFilePathList(space, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFilePathList(space, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs, FileTypeFilter[] filters) {
        List<FileObject> fileList = FileInputList.createFileList(space, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, filters).getFiles();
        String[] filePaths = new String[fileList.size()];
        for (int i = 0; i < filePaths.length; ++i) {
            filePaths[i] = fileList.get(i).getName().getURI();
        }
        return filePaths;
    }

    public static FileInputList createFileList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFileList(space, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static FileInputList createFileList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFileList(space, fileName, fileMask, excludeFileMask, fileRequired, includeSubdirs, null);
    }

    public static FileInputList createFileList(VariableSpace space, String[] fileName, String[] fileMask, String[] excludeFileMask, String[] fileRequired, boolean[] includeSubdirs, FileTypeFilter[] fileTypeFilters) {
        FileInputList fileInputList = new FileInputList();
        String[] realfile = space.environmentSubstitute(fileName);
        String[] realmask = space.environmentSubstitute(fileMask);
        String[] realExcludeMask = space.environmentSubstitute(excludeFileMask);
        for (int i = 0; i < realfile.length; ++i) {
            FileTypeFilter filter;
            String onefile = realfile[i];
            final String onemask = realmask[i];
            final String excludeonemask = realExcludeMask[i];
            boolean onerequired = YES.equalsIgnoreCase(fileRequired[i]);
            final boolean subdirs = includeSubdirs[i];
            FileTypeFilter fileTypeFilter = filter = fileTypeFilters == null || fileTypeFilters[i] == null ? FileTypeFilter.ONLY_FILES : fileTypeFilters[i];
            if (Utils.isEmpty(onefile)) continue;
            if (!Utils.isEmpty(onemask) || !Utils.isEmpty(excludeonemask)) {
                try {
                    int j;
                    FileObject directoryFileObject = KettleVFS.getFileObject(onefile, space);
                    boolean processFolder = true;
                    if (onerequired) {
                        if (!directoryFileObject.exists()) {
                            fileInputList.addNonExistantFile(directoryFileObject);
                            processFolder = false;
                        } else if (!directoryFileObject.isReadable()) {
                            fileInputList.addNonAccessibleFile(directoryFileObject);
                            processFolder = false;
                        }
                    }
                    if (!processFolder) continue;
                    if (directoryFileObject != null && directoryFileObject.getType() == FileType.FOLDER) {
                        Object[] fileObjects = directoryFileObject.findFiles((FileSelector)new AllFileSelector(){

                            public boolean traverseDescendents(FileSelectInfo info) {
                                return info.getDepth() == 0 || subdirs;
                            }

                            public boolean includeFile(FileSelectInfo info) {
                                if (info.getDepth() == 0) {
                                    return false;
                                }
                                FileObject fileObject = info.getFile();
                                try {
                                    if (fileObject != null && filter.isFileTypeAllowed(fileObject.getType())) {
                                        String name = info.getFile().getName().getBaseName();
                                        boolean matches = true;
                                        if (!Utils.isEmpty(onemask)) {
                                            matches = Pattern.matches(onemask, name);
                                        }
                                        boolean excludematches = false;
                                        if (!Utils.isEmpty(excludeonemask)) {
                                            excludematches = Pattern.matches(excludeonemask, name);
                                        }
                                        return matches && !excludematches;
                                    }
                                    return false;
                                }
                                catch (IOException ex) {
                                    return false;
                                }
                            }
                        });
                        if (fileObjects != null) {
                            for (j = 0; j < fileObjects.length; ++j) {
                                if (!fileObjects[j].exists()) continue;
                                fileInputList.addFile((FileObject)fileObjects[j]);
                            }
                        }
                        if (Utils.isEmpty(fileObjects) && onerequired) {
                            fileInputList.addNonAccessibleFile(directoryFileObject);
                        }
                        fileInputList.sortFiles();
                        continue;
                    }
                    FileObject[] children = directoryFileObject.getChildren();
                    for (j = 0; j < children.length; ++j) {
                        String name = children[j].getName().getBaseName();
                        boolean matches = true;
                        if (!Utils.isEmpty(onemask)) {
                            matches = Pattern.matches(onemask, name);
                        }
                        boolean excludematches = false;
                        if (!Utils.isEmpty(excludeonemask)) {
                            excludematches = Pattern.matches(excludeonemask, name);
                        }
                        if (!matches || excludematches) continue;
                        fileInputList.addFile(children[j]);
                    }
                    continue;
                }
                catch (Exception e) {
                    if (onerequired) {
                        fileInputList.addNonAccessibleFile(new NonAccessibleFileObject(onefile));
                    }
                    log.logError(Const.getStackTracker(e));
                    continue;
                }
            }
            try {
                FileObject fileObject = KettleVFS.getFileObject(onefile, space);
                if (fileObject.exists()) {
                    if (fileObject.isReadable()) {
                        fileInputList.addFile(fileObject);
                        continue;
                    }
                    if (!onerequired) continue;
                    fileInputList.addNonAccessibleFile(fileObject);
                    continue;
                }
                if (!onerequired) continue;
                fileInputList.addNonExistantFile(fileObject);
                continue;
            }
            catch (Exception e) {
                if (onerequired) {
                    fileInputList.addNonAccessibleFile(new NonAccessibleFileObject(onefile));
                }
                log.logError(Const.getStackTracker(e));
            }
        }
        return fileInputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInputList createFolderList(VariableSpace space, String[] folderName, String[] folderRequired) {
        FileInputList fileInputList = new FileInputList();
        String[] realfolder = space.environmentSubstitute(folderName);
        for (int i = 0; i < realfolder.length; ++i) {
            String onefile = realfolder[i];
            boolean onerequired = YES.equalsIgnoreCase(folderRequired[i]);
            boolean subdirs = true;
            final FileTypeFilter filter = FileTypeFilter.ONLY_FOLDERS;
            if (Utils.isEmpty(onefile)) continue;
            FileObject directoryFileObject = null;
            try {
                directoryFileObject = KettleVFS.getFileObject(onefile, space);
                if (directoryFileObject != null && directoryFileObject.getType() == FileType.FOLDER) {
                    Object[] fileObjects = directoryFileObject.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            if (info.getDepth() != 0) {
                                // empty if block
                            }
                            return true;
                        }

                        public boolean includeFile(FileSelectInfo info) {
                            if (info.getDepth() == 0) {
                                return false;
                            }
                            FileObject fileObject = info.getFile();
                            try {
                                return fileObject != null && filter.isFileTypeAllowed(fileObject.getType());
                            }
                            catch (IOException ex) {
                                return false;
                            }
                        }
                    });
                    if (fileObjects != null) {
                        for (int j = 0; j < fileObjects.length; ++j) {
                            if (!fileObjects[j].exists()) continue;
                            fileInputList.addFile((FileObject)fileObjects[j]);
                        }
                    }
                    if (Utils.isEmpty(fileObjects) && onerequired) {
                        fileInputList.addNonAccessibleFile(directoryFileObject);
                    }
                    fileInputList.sortFiles();
                    continue;
                }
                if (!onerequired || directoryFileObject.exists()) continue;
                fileInputList.addNonExistantFile(directoryFileObject);
                continue;
            }
            catch (Exception e) {
                log.logError(Const.getStackTracker(e));
                continue;
            }
            finally {
                try {
                    if (directoryFileObject != null) {
                        directoryFileObject.close();
                    }
                    directoryFileObject = null;
                }
                catch (Exception exception) {}
            }
        }
        return fileInputList;
    }

    public List<FileObject> getFiles() {
        return this.files;
    }

    public String[] getFileStrings() {
        String[] fileStrings = new String[this.files.size()];
        for (int i = 0; i < fileStrings.length; ++i) {
            fileStrings[i] = KettleVFS.getFilename(this.files.get(i));
        }
        return fileStrings;
    }

    public List<FileObject> getNonAccessibleFiles() {
        return this.nonAccessibleFiles;
    }

    public List<FileObject> getNonExistantFiles() {
        return this.nonExistantFiles;
    }

    public void addFile(FileObject file) {
        this.files.add(file);
    }

    public void addNonAccessibleFile(FileObject file) {
        this.nonAccessibleFiles.add(file);
    }

    public void addNonExistantFile(FileObject file) {
        this.nonExistantFiles.add(file);
    }

    public void sortFiles() {
        Collections.sort(this.files, KettleVFS.getComparator());
        Collections.sort(this.nonAccessibleFiles, KettleVFS.getComparator());
        Collections.sort(this.nonExistantFiles, KettleVFS.getComparator());
    }

    public FileObject getFile(int i) {
        return this.files.get(i);
    }

    public int nrOfFiles() {
        return this.files.size();
    }

    public int nrOfMissingFiles() {
        return this.nonAccessibleFiles.size() + this.nonExistantFiles.size();
    }

    public static FileInputList createFileList(VariableSpace space, String[] fileName, String[] fileMask, String[] fileRequired, boolean[] includeSubdirs) {
        return FileInputList.createFileList(space, fileName, fileMask, new String[fileName.length], fileRequired, includeSubdirs, null);
    }

    public static String[] createFilePathList(VariableSpace space, String[] fileName, String[] fileMask, String[] fileRequired) {
        boolean[] includeSubdirs = FileInputList.includeSubdirsFalse(fileName.length);
        return FileInputList.createFilePathList(space, fileName, fileMask, new String[fileName.length], fileRequired, includeSubdirs, null);
    }

    public static enum FileTypeFilter {
        FILES_AND_FOLDERS("all_files", FileType.FILE, FileType.FOLDER),
        ONLY_FILES("only_files", FileType.FILE),
        ONLY_FOLDERS("only_folders", FileType.FOLDER);

        private String name;
        private final Collection<FileType> allowedFileTypes;

        private FileTypeFilter(String name, FileType ... allowedFileTypes) {
            this.name = name;
            this.allowedFileTypes = Collections.unmodifiableCollection(Arrays.asList(allowedFileTypes));
        }

        public boolean isFileTypeAllowed(FileType fileType) {
            return this.allowedFileTypes.contains(fileType);
        }

        public String toString() {
            return this.name;
        }

        public static FileTypeFilter getByOrdinal(int ordinal) {
            for (FileTypeFilter filter : FileTypeFilter.values()) {
                if (filter.ordinal() != ordinal) continue;
                return filter;
            }
            return ONLY_FILES;
        }

        public static FileTypeFilter getByName(String name) {
            for (FileTypeFilter filter : FileTypeFilter.values()) {
                if (!filter.name.equals(name)) continue;
                return filter;
            }
            return ONLY_FILES;
        }
    }
}

