/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.New;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private CreateTableData data = new CreateTableData();
    private ArrayList<Prepared> constraintCommands = New.arrayList();
    private IndexColumn[] pkColumns;
    private boolean ifNotExists;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.data.temporary = bl;
    }

    public void setTableName(String string) {
        this.data.tableName = string;
    }

    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void addConstraintCommand(Prepared prepared) {
        if (prepared instanceof CreateIndex) {
            this.constraintCommands.add(prepared);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)prepared;
            boolean bl = alterTableAddConstraint.getType() == 3 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.constraintCommands.add(prepared);
            }
        }
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        block24: {
            this.session.commit(true);
            Database database = this.session.getDatabase();
            if (!database.isPersistent()) {
                this.data.persistIndexes = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.data.tableName) != null) {
                if (this.ifNotExists) {
                    return 0;
                }
                throw DbException.get(42101, this.data.tableName);
            }
            if (this.asQuery != null) {
                this.asQuery.prepare();
                if (this.data.columns.size() == 0) {
                    this.generateColumnsFromQuery();
                } else if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                    throw DbException.get(21002);
                }
            }
            if (this.pkColumns != null) {
                for (Column object2 : this.data.columns) {
                    for (IndexColumn indexColumn : this.pkColumns) {
                        if (!object2.getName().equals(indexColumn.columnName)) continue;
                        object2.setNullable(false);
                    }
                }
            }
            ArrayList arrayList = New.arrayList();
            for (Column column : this.data.columns) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int n = this.getObjectId();
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, this.data.temporary);
                }
                if ((sequence = column.getSequence()) == null) continue;
                arrayList.add(sequence);
            }
            this.data.id = this.getObjectId();
            this.data.create = this.create;
            this.data.session = this.session;
            TableData tableData = this.getSchema().createTable(this.data);
            tableData.setComment(this.comment);
            tableData.setGlobalTemporary(this.globalTemporary);
            if (this.data.temporary && !this.globalTemporary) {
                if (this.onCommitDrop) {
                    tableData.setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    tableData.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(tableData);
            } else {
                database.addSchemaObject(this.session, tableData);
            }
            try {
                for (Column column : this.data.columns) {
                    column.prepareExpression(this.session);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Sequence sequence = (Sequence)iterator.next();
                    tableData.addSequence(sequence);
                }
                for (Prepared prepared : this.constraintCommands) {
                    prepared.update();
                }
                if (this.asQuery == null) break block24;
                boolean bl = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable(tableData);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(bl);
                }
            }
            catch (DbException dbException) {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, tableData);
                this.session.commit(true);
                throw dbException;
            }
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ArrayList<Expression> arrayList = this.asQuery.getExpressions();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = arrayList.get(i);
            int n3 = expression.getType();
            String string = expression.getAlias();
            long l = expression.getPrecision();
            int n4 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n3);
            if (l > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l && dataType.defaultPrecision < 127L)) {
                l = dataType.defaultPrecision;
            }
            if ((n2 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n2)) {
                n2 = dataType.defaultScale;
            }
            Column column = new Column(string, n3, l, n2, n4);
            this.addColumn(column);
        }
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) {
        if (this.pkColumns != null) {
            if (indexColumnArray.length != this.pkColumns.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < indexColumnArray.length; ++i) {
                if (indexColumnArray[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl) {
        this.data.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setPersistData(boolean bl) {
        this.data.persistData = bl;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }
}

