/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.apache.http.protocol;

import com.cloudera.org.apache.http.HttpException;
import com.cloudera.org.apache.http.HttpRequest;
import com.cloudera.org.apache.http.HttpRequestInterceptor;
import com.cloudera.org.apache.http.annotation.Immutable;
import com.cloudera.org.apache.http.params.HttpProtocolParams;
import com.cloudera.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String useragent;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (!request.containsHeader("User-Agent") && (useragent = HttpProtocolParams.getUserAgent(request.getParams())) != null) {
            request.addHeader("User-Agent", useragent);
        }
    }
}

