/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ExtendedResourceBundleFactory;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class LibLoaderResourceBundleFactory
implements ExtendedResourceBundleFactory {
    private transient HashSet<String> failedLoads = new HashSet();
    private transient LFUMap<String, LibLoaderResourceBundle> successfulLoads = new LFUMap(30);
    private transient ResourceManager manager;
    private transient ResourceKey baseKey;
    private Locale locale;
    private TimeZone timeZone;

    public LibLoaderResourceBundleFactory() {
    }

    public LibLoaderResourceBundleFactory(ResourceManager manager, ResourceKey baseKey, Locale locale, TimeZone timeZone) {
        this();
        this.manager = manager;
        this.baseKey = baseKey;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    @Override
    public ResourceBundle getResourceBundle(String key) {
        String propsName;
        String keyAsPath = key.replace('.', '/');
        Locale locale = this.getLocale();
        String variant = locale.getVariant();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String fullName = !"".equals(variant) ? locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant() : null;
        String cntryName = !"".equals(country) ? locale.getLanguage() + '_' + locale.getCountry() : null;
        String langName = !"".equals(language) ? locale.getLanguage() : null;
        LibLoaderResourceBundle fullProperties = null;
        if (fullName != null) {
            String propsName2 = keyAsPath + '_' + fullName + ".properties";
            fullProperties = this.loadProperties(propsName2);
        }
        LibLoaderResourceBundle cntryProperties = null;
        if (cntryName != null) {
            String propsName3 = keyAsPath + '_' + cntryName + ".properties";
            cntryProperties = this.loadProperties(propsName3);
        }
        LibLoaderResourceBundle langProperties = null;
        if (langName != null) {
            propsName = keyAsPath + '_' + langName + ".properties";
            langProperties = this.loadProperties(propsName);
        }
        propsName = keyAsPath + ".properties";
        LibLoaderResourceBundle defaultProperties = this.loadProperties(propsName);
        if (langProperties == null && cntryProperties == null && fullProperties == null && defaultProperties == null) {
            throw new MissingResourceException("No such bundle: " + keyAsPath, key, null);
        }
        if (fullProperties != null) {
            if (cntryProperties != null) {
                fullProperties.setParent(cntryProperties);
            } else if (langProperties != null) {
                fullProperties.setParent(langProperties);
            } else if (defaultProperties != null) {
                fullProperties.setParent(defaultProperties);
            }
        }
        if (cntryProperties != null) {
            if (langProperties != null) {
                cntryProperties.setParent(langProperties);
            } else if (defaultProperties != null) {
                cntryProperties.setParent(defaultProperties);
            }
        }
        if (langProperties != null && defaultProperties != null) {
            langProperties.setParent(defaultProperties);
        }
        if (fullProperties != null) {
            return fullProperties;
        }
        if (cntryProperties != null) {
            return cntryProperties;
        }
        if (langProperties != null) {
            return langProperties;
        }
        return defaultProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibLoaderResourceBundle loadProperties(String propsName) {
        LibLoaderResourceBundle libLoaderResourceBundle;
        InputStream instream;
        ResourceData resource;
        if (this.failedLoads.contains(propsName)) {
            return null;
        }
        LibLoaderResourceBundle bundle = (LibLoaderResourceBundle)this.successfulLoads.get((Object)propsName);
        if (bundle != null) {
            return bundle;
        }
        if (this.manager == null) {
            this.manager = new ResourceManager();
        }
        if (this.baseKey != null) {
            LibLoaderResourceBundle libLoaderResourceBundle2;
            ResourceKey resourceKey2 = this.manager.deriveKey(this.baseKey, propsName);
            resource = this.manager.load(resourceKey2);
            instream = resource.getResourceAsStream(this.manager);
            try {
                LibLoaderResourceBundle resourceBundle = new LibLoaderResourceBundle(instream);
                this.successfulLoads.put((Object)propsName, (Object)resourceBundle);
                libLoaderResourceBundle2 = resourceBundle;
            }
            catch (Throwable throwable) {
                try {
                    instream.close();
                    throw throwable;
                }
                catch (Exception resourceKey2) {
                    // empty catch block
                }
            }
            instream.close();
            return libLoaderResourceBundle2;
        }
        ResourceKey resourceKey = this.manager.createKey((Object)("res://" + propsName));
        resource = this.manager.load(resourceKey);
        instream = resource.getResourceAsStream(this.manager);
        try {
            LibLoaderResourceBundle resourceBundle = new LibLoaderResourceBundle(instream);
            this.successfulLoads.put((Object)propsName, (Object)resourceBundle);
            libLoaderResourceBundle = resourceBundle;
        }
        catch (Throwable throwable) {
            try {
                instream.close();
                throw throwable;
            }
            catch (Exception e) {
                this.failedLoads.add(propsName);
                return null;
            }
        }
        instream.close();
        return libLoaderResourceBundle;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    @Override
    public void setResourceLoader(ResourceManager resourceManager, ResourceKey contextKey) {
        this.manager = resourceManager;
        this.baseKey = contextKey;
        this.failedLoads.clear();
        this.successfulLoads.clear();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LibLoaderResourceBundleFactory o = (LibLoaderResourceBundleFactory)super.clone();
        o.failedLoads = (HashSet)this.failedLoads.clone();
        o.successfulLoads = (LFUMap)this.successfulLoads.clone();
        return o;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.failedLoads = new HashSet();
        this.successfulLoads = new LFUMap(30);
    }

    private static class LibLoaderResourceBundle
    extends PropertyResourceBundle {
        private LibLoaderResourceBundle(InputStream stream) throws IOException {
            super(stream);
            this.setParent(this.parent);
        }

        @Override
        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }
    }
}

